// DAQSys.h: interface for the DAQSys class.
//
//////////////////////////////////////////////////////////////////////
/* File History
 *
 * dec.10.2007			Sam Skuce (ATI Industrial Automation)
 *	Added note explaining that path to NI-DAQ header files can change.
 */
#if !defined(AFX_DAQSYS_H__7532000D_2E31_4585_AB12_BB18D4864927__INCLUDED_)
#define AFX_DAQSYS_H__7532000D_2E31_4585_AB12_BB18D4864927__INCLUDED_

/* If the compiler complains it cannot open this include file, make sure the path to
 * the file is correct.  I have seen the "NI-DAQ" portion of the path spelled as "NI - DAQ",
 * depending on the version of the NI-DAQ software installed.  This issue will also 
 * affect linking in nidaq32.lib and nidex32.lib, so if the linker complains about those,
 * make the same fix. */
#include "C:\Program Files\National Instruments\NI-DAQ\Include\nidaqex.h"
//#include <nidaqex.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define NUM_CHANNELS 7
#define SCAN_BUFFER_SIZE 280

#ifdef _AFXDLL
class DAQException : public CException
#else
class AFX_NOVTABLE DAQException : public CException
#endif
{
public:
	DAQException(CString new_err_msg="", BOOL bAutoDelete=true) : CException(bAutoDelete)
	{
		err_msg = new_err_msg;
		err_no = 0;
	}
	DAQException(int new_err_no, BOOL bAutoDelete = true) : CException(bAutoDelete)
	{
		err_no = new_err_no;
		CString integer;
		integer.Format("%d",err_no);
		switch (err_no) {
// TODO: add more error codes here - these are the 2 most common
		case unknownDeviceError:	// The specified device is not a National Instruments product, so the driver does not support the device, which can happen if the driver was released before the device was supported, or the device has not been configured using the Measurement & Automation Explorer.
			err_msg  = "Failed to setup DAQ device.  ";
			err_msg += integer;
			err_msg += ": UnknownDeviceError.\nPlease verify that the DAQ is properly installed and configured, and then restart the application.";
			break;
		case transferInProgError:	// A transfer is already in progress for the specified resource, or the operation is not allowed because the device is in the process of performing transfers, possibly with different resources.
			err_msg  = " The DAQ device is already in use.  ";
			err_msg += integer;
			err_msg += ": TransferInProgError.\nPlease verify that no other applications are using the DAQ.";
			break;
		default:
			err_msg  = "Unknown NI-DAQ Error Code: ";
			err_msg += integer;
		}
	}
	CString GetErrMsg()		{ return err_msg; }
	int GetErrNo()			{ return err_no; }
private:
	CString err_msg;
	int err_no;
};

/* this is used for development only, so that a DAQ is not required to test the GUI */
#define TEST_WITHOUT_DAQ 0

class DAQSys  
{
public:
	/* this method is used to setup the DAQ during object construction of when changed in the Program Options */
	int init(short changeDeviceNumber, short firstChannel, double scanRate);
	/* this method sets up the min and max used for saturation detection - called by init (possible device change) or by loading a new active calibration */
	void setupMinMax(double DesiredRange, bool bipolar);
	/* scans all 7 gauges, or returns last scan if boolean is true, returns 0 for success or -1 for saturation */
	int ScanGauges(double voltages[7], bool useStoredValues);
	/* scans a single gauge - no saturation checking */
	double ScanGauge(short chan);
	/* return the device number of the DAQ - originally defaults to 1 */
	short getDeviceNumber() { return deviceNumber; }
	/* return the first channel to be scanned by the DAQ - originally defaults to 1 */
	short getFirstChannel() { return firstChannel; }
	/* returns the scan rate to be used when scanning the gauges */
	double getScanRate() { return scanRate; }
	DAQSys();
	virtual ~DAQSys();

private:
	double range;
	bool bipolarity;
	double scanRate;
	short channel_gains[NUM_CHANNELS];
	short channels[NUM_CHANNELS];
	double voltsPerCount;
	short deviceNumber;
	short firstChannel;
	short AIGain;
	unsigned short numChannels;
	int AIMax;
	int AIMin;
	long scanBuffer[SCAN_BUFFER_SIZE]; /*memory buffer used by scanning operation*/
	unsigned int scanCount; /*the number of scans in a reading.  averaged out to get
								the final result*/
#if TEST_WITHOUT_DAQ
	bool random_gen;
#endif
};

#endif // !defined(AFX_DAQSYS_H__7532000D_2E31_4585_AB12_BB18D4864927__INCLUDED_)
