VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ProgramOptions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Class ProgramOptions
'stores and persists program options

'This module uses the MSXML reference.

Public LoadOnStartup As String
Public BeepForSaturation As Boolean
Public Device As Integer
Public BufMode As Boolean
Public TimerInterval As Long
Public BiasRawVoltages As Boolean
Public FilterLevel As Integer
Public ShowThermistor As Boolean
Public ConfigFileDir As String
Public CalFileDir As String
Public ScanRate As Double
Public LogFile As String
Public FirstChannel As Integer
Public ShowGettingStarted As Boolean
Public Show3DCube As Boolean
Private Const SETTINGSFILE = "settings.xml" 'program options are stored in this file

'code to persist program options
Public Sub Load()
On Error GoTo NoMSXML
    Dim SettingsDoc As New MSXML2.DOMDocument
    Dim Settings As MSXML2.IXMLDOMElement
    SettingsDoc.Load App.Path & "\" & SETTINGSFILE
On Error GoTo OtherErrors
    Set Settings = SettingsDoc.documentElement
    TimerInterval = Val(ReadSetting(Settings, "TimerInterval", "100"))
    BeepForSaturation = ReadSetting(Settings, "BeepForSaturation", "True")
    LoadOnStartup = ReadSetting(Settings, "LoadOnStartup", "")
    Device = Val(ReadSetting(Settings, "Device", "1"))
    BufMode = ReadSetting(Settings, "BufMode", "False")
    BiasRawVoltages = ReadSetting(Settings, "BiasRawVoltages", "False")
    FilterLevel = Val(ReadSetting(Settings, "FilterLevel", "1"))
    ShowThermistor = ReadSetting(Settings, "ShowThermistor", "False")
    ConfigFileDir = ReadSetting(Settings, "ConfigFileDir", App.Path)
    CalFileDir = ReadSetting(Settings, "CalFileDir", App.Path)
    ScanRate = Val(ReadSetting(Settings, "ScanRate", 1000))
    LogFile = ReadSetting(Settings, "LogFile", App.Path & "\data.txt")
    FirstChannel = Val(ReadSetting(Settings, "FirstChannel", 0))
    ShowGettingStarted = ReadSetting(Settings, "ShowGettingStarted", "True")
    Show3DCube = ReadSetting(Settings, "Show3DCube", "True")
    Set SettingsDoc = Nothing
    Exit Sub

NoMSXML:
    Err.Raise vbObjectError, , "MSXML3.DLL is not registered.  Install Internet Explorer 5.01 or later, then reinstall this application."
    Exit Sub

OtherErrors:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub
Public Sub Save()
    Dim SettingsDoc As New MSXML2.DOMDocument
    Dim Settings As MSXML2.IXMLDOMElement
    Set Settings = SettingsDoc.createElement("Settings")
    SettingsDoc.appendChild Settings
    WriteSetting SettingsDoc, Settings, "Device", Device
    WriteSetting SettingsDoc, Settings, "BufMode", BufMode
    WriteSetting SettingsDoc, Settings, "LoadOnStartup", LoadOnStartup
    WriteSetting SettingsDoc, Settings, "BeepForSaturation", BeepForSaturation
    WriteSetting SettingsDoc, Settings, "TimerInterval", TimerInterval
    WriteSetting SettingsDoc, Settings, "BiasRawVoltages", BiasRawVoltages
    WriteSetting SettingsDoc, Settings, "FilterLevel", FilterLevel
    WriteSetting SettingsDoc, Settings, "ShowThermistor", ShowThermistor
    WriteSetting SettingsDoc, Settings, "ConfigFileDir", ConfigFileDir
    WriteSetting SettingsDoc, Settings, "CalFileDir", CalFileDir
    WriteSetting SettingsDoc, Settings, "ScanRate", ScanRate
    WriteSetting SettingsDoc, Settings, "LogFile", LogFile
    WriteSetting SettingsDoc, Settings, "FirstChannel", FirstChannel
    WriteSetting SettingsDoc, Settings, "ShowGettingStarted", ShowGettingStarted
    WriteSetting SettingsDoc, Settings, "Show3DCube", Show3DCube
    SettingsDoc.Save App.Path & "\" & SETTINGSFILE
    Set Settings = Nothing
    Set SettingsDoc = Nothing
End Sub
Private Sub WriteSetting(ByRef SettingsDoc As MSXML2.DOMDocument, ByRef Settings As MSXML2.IXMLDOMElement, ByVal Key As String, ByVal Value As String)
    Dim NewElem As MSXML2.IXMLDOMElement
    Set NewElem = SettingsDoc.createElement(Key)
    NewElem.Text = Value
    Settings.appendChild NewElem
    Set NewElem = Nothing
End Sub
Private Function ReadSetting(ByRef Settings As MSXML2.IXMLDOMElement, ByVal Key As String, Optional ByVal default As String = "") As String
    Dim NodeList As MSXML2.IXMLDOMNodeList
    Set NodeList = Settings.getElementsByTagName(Key)
    
    If NodeList.length < 1 Then
        ReadSetting = default
    Else
        ReadSetting = NodeList(0).Text
    End If
End Function
