VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form frmDataCollection 
   Caption         =   "Data Collection"
   ClientHeight    =   3630
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8850
   LinkTopic       =   "Form1"
   ScaleHeight     =   3630
   ScaleWidth      =   8850
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer tmrUpdateNumCollected 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   0
      Top             =   3120
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   375
      Left            =   840
      TabIndex        =   7
      Top             =   2760
      Width           =   735
   End
   Begin VB.CommandButton cmdGo 
      Caption         =   "Go"
      Height          =   375
      Left            =   0
      TabIndex        =   6
      Top             =   2760
      Width           =   855
   End
   Begin VB.TextBox txtCollectTime 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   0
      TabIndex        =   5
      Text            =   "60"
      Top             =   2400
      Width           =   1095
   End
   Begin VB.TextBox txtFileName 
      Height          =   285
      Left            =   600
      TabIndex        =   2
      Top             =   1680
      Width           =   3975
   End
   Begin VB.CommandButton cmdChooseFile 
      Caption         =   "..."
      Height          =   255
      Left            =   0
      TabIndex        =   1
      Top             =   1680
      Width           =   615
   End
   Begin MSComDlg.CommonDialog cdlgFileChooser 
      Left            =   8280
      Top             =   2760
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Label lblNumCollected 
      Caption         =   "Number Collected: 0"
      Height          =   255
      Left            =   0
      TabIndex        =   8
      Top             =   3120
      Width           =   4695
   End
   Begin VB.Label Label3 
      Caption         =   "Number of seconds to collect data"
      Height          =   255
      Left            =   0
      TabIndex        =   4
      Top             =   2040
      Width           =   4575
   End
   Begin VB.Label Label2 
      Caption         =   "Filename"
      Height          =   255
      Left            =   0
      TabIndex        =   3
      Top             =   1440
      Width           =   3135
   End
   Begin VB.Label Label1 
      Caption         =   $"frmDataCollection.frx":0000
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   1215
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   8775
   End
End
Attribute VB_Name = "frmDataCollection"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'frmDataCollection
'used to collect data to file

'PRIVATE DATA
Private myDAQSystem As DAQSystem 'the DAQ system which fetches the voltages
Private myCalibration As Calibration 'the calibration which calculates f/t values
Private myCollecting As Boolean 'whether or not we're currently collecting data
Private myNumSamples As Long 'the number of samples collected.

'PUBLIC INTERFACE
Public Sub SetDAQSystem(ByRef ds As DAQSystem)
    Set myDAQSystem = ds
End Sub

Public Sub SetCalibration(ByRef ca As Calibration)
    Set myCalibration = ca
End Sub

'PRIVATE INTERFACE
Private Sub cmdChooseFile_Click()
    With cdlgFileChooser
        .FileName = ""
        .DialogTitle = "File to Save Data In"
        .Filter = "Comma-Separated Value(*.csv)|*.csv|Text File(*.txt)|*.txt|All Files|*"
        .ShowSave
        txtFileName = .FileName
    End With
End Sub

Private Sub cmdGo_Click()
    If Not IsNumeric(txtCollectTime.Text) Then
        MsgBox "You must enter a valid number of seconds to collect data", vbInformation Or vbOKOnly, "Format Error"
        Exit Sub
    End If
    If txtFileName.Text = "" Then
        MsgBox "You must enter a filename to save data in.", vbOKOnly Or vbInformation, "Need File"
        Exit Sub
    End If
    myCollecting = True
    cmdGo.Enabled = False
    cmdStop.Enabled = True
    Dim fileNum As Integer 'the file handle
    fileNum = FreeFile
    Open txtFileName For Output As #fileNum
    Print #fileNum, "Time(s), Fx, Fy, Fz, Tx, Ty, Tz"
    myNumSamples = 0
    tmrUpdateNumCollected.Enabled = True 'allow update of number collected
        'display
    Dim startTime As Double 'the time at which data collection started
    startTime = Timer
    'precondition: mycollecting = true, startTime ~ now, myDaqSystem and
    '   myCalibration are valid, cmdStop is enabled, fileNum points to
    '   an open file, myNumSamples = 0
    'postcondition: myCollecting = false iff user pressed stop button,
    '   file pointed to by filenum will have f/t records, myNumSamples =
    '   number of valid samples collected
    While myCollecting And ((Timer - startTime < txtCollectTime))
        Dim voltages(0 To 6) As Double
        Dim status As Integer
        status = myDAQSystem.Scan(voltages)
        If status <> 0 Then
            MsgBox "Error occurred (status = " & status & ".  Force/Torque values are invalid.  Data collection will now stop.", vbOKOnly Or vbExclamation, "Saturation"
            myCollecting = False
        End If
        If myCollecting Then
            myNumSamples = myNumSamples + 1
            Dim ftValues
            ftValues = myCalibration.ConvertToFT(voltages)
            Print #fileNum, (Timer - startTime) & ", " & FloatListAsString(ftValues, 6, "")
        End If
        DoEvents
    Wend
    tmrUpdateNumCollected.Enabled = False
    Close #fileNum
    lblNumCollected.Caption = "Number Collectd: " & myNumSamples
    myCollecting = False
    cmdGo.Enabled = True
    cmdStop.Enabled = False
End Sub

Private Sub cmdStop_Click()
    myCollecting = False
End Sub

Private Sub Form_Activate()
    If (myDAQSystem Is Nothing) Or (myCalibration Is Nothing) Then
        MsgBox "Application Error: No Calibration or DAQSystem was set"
        Unload Me
    End If
End Sub

Private Sub Form_Load()
    myCollecting = False
End Sub

'FloatListAsString( floatList, size, numberFormat, textFormat )
'arguments:
'   floatList - an array of floating point numbers
'   size - the number of elements in floatList
'   numberFormat - the format of the number, i.e. "0.000"
'   textFormat - the text format once the number is converted to a string, for
'       stuff like field width, etc.
'returns:
'   comma separated list of values, each formatted according to numberformat and
'       textFormat
Private Function FloatListAsString(floatList, ByVal size As Long, Optional ByVal numberFormat As String = "0.000", Optional ByVal textFormat As String = "") As String
    Dim i As Integer 'generic loop/array index
    Dim retVal As String 'just easier to type than floatlistasstring
    retVal = Format(Format(floatList(0), numberFormat), textFormat)
    For i = 1 To (size - 1)
        retVal = retVal & "," & Format(Format(floatList(i), numberFormat), textFormat)
    Next i
    FloatListAsString = retVal
End Function

Private Sub tmrUpdateNumCollected_Timer()
    lblNumCollected.Caption = "Number Collected: " & myNumSamples
End Sub
