VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{F262B582-48A4-11D6-8423-00B0D0CBE16A}#1.0#0"; "atiftvisualizer.ocx"
Begin VB.Form frmMain 
   Caption         =   "ATI DAQ F/T Demo"
   ClientHeight    =   7620
   ClientLeft      =   4365
   ClientTop       =   3105
   ClientWidth     =   7275
   HelpContextID   =   2200
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7620
   ScaleWidth      =   7275
   StartUpPosition =   2  'CenterScreen
   Begin ATIFTVISUALIZERLib.ATIFTVisualizer ATIFTVisualizer1 
      Height          =   2355
      Left            =   4020
      TabIndex        =   27
      Top             =   4560
      Width           =   2775
      _Version        =   65536
      _ExtentX        =   4895
      _ExtentY        =   4154
      _StockProps     =   0
      Elevation       =   30
      Azimuth         =   -20
   End
   Begin VB.CommandButton btnLogData 
      Caption         =   "Log Data"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   420
      TabIndex        =   26
      ToolTipText     =   "Write the current F/T values and raw voltages to the file specified in Program Settings"
      Top             =   5460
      Width           =   1995
   End
   Begin VB.CommandButton btnUnbias 
      Caption         =   "Unbias"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2220
      TabIndex        =   25
      ToolTipText     =   "Remove the bias and show actual voltages measured by DAQ system"
      Top             =   4860
      Width           =   1095
   End
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   255
      Left            =   0
      TabIndex        =   22
      Top             =   7365
      Width           =   7275
      _ExtentX        =   12832
      _ExtentY        =   450
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   3
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Object.Width           =   4233
            MinWidth        =   4233
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Object.Width           =   3528
            MinWidth        =   3528
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   4498
         EndProperty
      EndProperty
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   6660
      Top             =   4860
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      InitDir         =   "c:\"
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   6720
      Top             =   4560
   End
   Begin VB.Frame Frame1 
      Caption         =   "Force"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   1575
      Left            =   240
      TabIndex        =   7
      Top             =   960
      Width           =   6615
      Begin VB.Label FTValue 
         Alignment       =   1  'Right Justify
         Caption         =   "0000000"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   0
         Left            =   480
         TabIndex        =   18
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label FTValue 
         Alignment       =   1  'Right Justify
         Caption         =   "0000000"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   1
         Left            =   480
         TabIndex        =   17
         Top             =   720
         Width           =   1215
      End
      Begin VB.Label FTValue 
         Alignment       =   1  'Right Justify
         Caption         =   "0000000"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   2
         Left            =   480
         TabIndex        =   16
         Top             =   1080
         Width           =   1215
      End
      Begin VB.Label Axis 
         Caption         =   "X"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   372
         Index           =   0
         Left            =   240
         TabIndex        =   10
         Top             =   360
         Width           =   372
      End
      Begin VB.Label Axis 
         Caption         =   "Y"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   372
         Index           =   1
         Left            =   240
         TabIndex        =   9
         Top             =   720
         Width           =   372
      End
      Begin VB.Label Axis 
         Caption         =   "Z"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   372
         Index           =   2
         Left            =   240
         TabIndex        =   8
         Top             =   1080
         Width           =   372
      End
      Begin VB.Shape fgauge 
         BackColor       =   &H000000FF&
         BackStyle       =   1  'Opaque
         BorderColor     =   &H00000000&
         FillColor       =   &H000000FF&
         FillStyle       =   0  'Solid
         Height          =   375
         Index           =   0
         Left            =   1800
         Top             =   360
         Width           =   255
      End
      Begin VB.Shape fgauge 
         BackColor       =   &H000000FF&
         BackStyle       =   1  'Opaque
         BorderColor     =   &H00000000&
         FillColor       =   &H000000FF&
         FillStyle       =   0  'Solid
         Height          =   375
         Index           =   1
         Left            =   1800
         Top             =   720
         Width           =   375
      End
      Begin VB.Shape fgauge 
         BackColor       =   &H000000FF&
         BackStyle       =   1  'Opaque
         BorderColor     =   &H00000000&
         FillColor       =   &H000000FF&
         FillStyle       =   0  'Solid
         Height          =   375
         Index           =   2
         Left            =   1800
         Top             =   1080
         Width           =   255
      End
      Begin VB.Shape Shape1 
         Height          =   375
         Left            =   1800
         Top             =   720
         Width           =   4695
      End
      Begin VB.Shape Shape2 
         Height          =   375
         Left            =   1800
         Top             =   360
         Width           =   4695
      End
      Begin VB.Shape Shape3 
         Height          =   375
         Left            =   1800
         Top             =   1080
         Width           =   4695
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Torque"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   1575
      Left            =   240
      TabIndex        =   3
      Top             =   2640
      Width           =   6615
      Begin VB.Label FTValue 
         Alignment       =   1  'Right Justify
         Caption         =   "0000000"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   3
         Left            =   480
         TabIndex        =   21
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label FTValue 
         Alignment       =   1  'Right Justify
         Caption         =   "0000000"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   4
         Left            =   480
         TabIndex        =   20
         Top             =   720
         Width           =   1215
      End
      Begin VB.Label FTValue 
         Alignment       =   1  'Right Justify
         Caption         =   "0000000"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   5
         Left            =   480
         TabIndex        =   19
         Top             =   1080
         Width           =   1215
      End
      Begin VB.Shape Shape4 
         Height          =   375
         Left            =   1800
         Top             =   360
         Width           =   4695
      End
      Begin VB.Label TAxis 
         Caption         =   "X"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   372
         Index           =   0
         Left            =   240
         TabIndex        =   6
         Top             =   360
         Width           =   372
      End
      Begin VB.Label TAxis 
         Caption         =   "Y"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   372
         Index           =   1
         Left            =   240
         TabIndex        =   5
         Top             =   720
         Width           =   372
      End
      Begin VB.Label TAxis 
         Caption         =   "Z"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   372
         Index           =   2
         Left            =   240
         TabIndex        =   4
         Top             =   1080
         Width           =   372
      End
      Begin VB.Shape fgauge 
         BackColor       =   &H00C0C000&
         BackStyle       =   1  'Opaque
         FillColor       =   &H00FFFF00&
         FillStyle       =   0  'Solid
         Height          =   375
         Index           =   3
         Left            =   1800
         Top             =   360
         Width           =   255
      End
      Begin VB.Shape fgauge 
         BackColor       =   &H00C0C000&
         BackStyle       =   1  'Opaque
         FillColor       =   &H00FFFF00&
         FillStyle       =   0  'Solid
         Height          =   375
         Index           =   4
         Left            =   1800
         Top             =   720
         Width           =   375
      End
      Begin VB.Shape fgauge 
         BackColor       =   &H00C0C000&
         BackStyle       =   1  'Opaque
         FillColor       =   &H00FFFF00&
         FillStyle       =   0  'Solid
         Height          =   375
         Index           =   5
         Left            =   1800
         Top             =   1080
         Width           =   255
      End
      Begin VB.Shape Shape5 
         Height          =   375
         Left            =   1800
         Top             =   720
         Width           =   4695
      End
      Begin VB.Shape Shape6 
         Height          =   375
         Left            =   1800
         Top             =   1080
         Width           =   4695
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Display"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   915
      Left            =   240
      TabIndex        =   1
      Top             =   4320
      Width           =   1572
      Begin VB.OptionButton DispOption 
         Caption         =   "Gauges"
         Height          =   252
         Index           =   1
         Left            =   120
         TabIndex        =   14
         ToolTipText     =   "Show raw voltages"
         Top             =   540
         Value           =   -1  'True
         Width           =   1332
      End
      Begin VB.OptionButton DispOption 
         Caption         =   "F/T Units"
         Height          =   252
         Index           =   0
         Left            =   120
         TabIndex        =   2
         ToolTipText     =   "Show force and torque measurements"
         Top             =   240
         Width           =   1332
      End
   End
   Begin VB.CommandButton btnBias 
      Caption         =   "Bias"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2220
      TabIndex        =   0
      ToolTipText     =   "Zero out the load on the transducer"
      Top             =   4440
      Width           =   1095
   End
   Begin MSComDlg.CommonDialog CommonDialog2 
      Left            =   6660
      Top             =   4860
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      InitDir         =   "c:\"
   End
   Begin VB.Label lblThermistor 
      Caption         =   "Label5"
      Height          =   255
      Left            =   6060
      TabIndex        =   24
      ToolTipText     =   "Thermistor reading (used for temperature compensation)"
      Top             =   4320
      Width           =   795
   End
   Begin VB.Label lblThermLabel 
      Caption         =   "Thermistor (V):"
      Height          =   195
      Left            =   4920
      TabIndex        =   23
      Top             =   4320
      Width           =   1095
   End
   Begin VB.Label lblWarning 
      Alignment       =   2  'Center
      Caption         =   "WARNING: ADC Saturation"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   735
      Left            =   60
      TabIndex        =   15
      Top             =   6180
      Visible         =   0   'False
      Width           =   3855
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label1 
      Caption         =   "ATI Industrial Automation"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   13
      Top             =   480
      Width           =   2655
   End
   Begin VB.Label Label2 
      Caption         =   "Copyright 2001, 2002. All rights reserved"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   -1  'True
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3240
      TabIndex        =   12
      Top             =   480
      Width           =   3015
   End
   Begin VB.Label Label3 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      Caption         =   "ATI DAQ F/T Demo"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   360
      TabIndex        =   11
      Top             =   120
      Width           =   5415
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuOpenCalibration 
         Caption         =   "Open &Calibration..."
      End
      Begin VB.Menu mnuDivider3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuOpenConfiguration 
         Caption         =   "&Open Configuration..."
      End
      Begin VB.Menu mnuSaveConfiguration 
         Caption         =   "&Save Configuration..."
      End
      Begin VB.Menu mnuDivider2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuTools 
      Caption         =   "&Tools"
      Begin VB.Menu mnuSettings 
         Caption         =   "&Settings..."
      End
      Begin VB.Menu mnuSensorInfo 
         Caption         =   "Sensor &Information..."
      End
      Begin VB.Menu mnuDivider1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuProgramOptions 
         Caption         =   "Program &Options..."
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpContents 
         Caption         =   "&Contents..."
      End
      Begin VB.Menu mnuDivider4 
         Caption         =   "-"
      End
      Begin VB.Menu mnuAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This is the main form of the application.

'It references ATIDAQFT for configuration of the F/T system and
'converting voltages to forces and torques.

'All hardware and device driver operations are contained in the
'DAQSystem class, which uses NI-DAQ driver function calls.
Option Explicit

Private Const PosColor = &HFF00&            ' green
Private Const NegColor = &HFF&              ' red
Private Const OverflowColor = &HFF0000      ' blue

Private FTFormat(0 To 5) As String          'stores format strings for the F/T outputs
Private CalFileLoaded As Boolean            'determines whether or not readings can be displayed in F/T units

Public MyFT As ATIDAQFT.FTSensor             'top-level object in ATIDAQFT
Public MyCalibration As ATIDAQFT.Calibration 'reference to the active Calibration object
Public MyOptions As ProgramOptions          'a structure containing all persistent program options
Private MyDAQSystem As DAQSystem            'hardware interface
Private MyBiasVector() As Double            'reference voltage level
Private m_bLogging As Double                'true if we're currently logging
'data

Private Sub Form_Activate()
'The timer should only be enabled when the form is active, hardware is configured, and
    If MyDAQSystem.Configured Then Timer1.Enabled = True
End Sub
Private Sub Form_Load()
On Error GoTo OtherError
    Set MyFT = New FTSensor
    Set MyDAQSystem = New DAQSystem
    Set MyOptions = New ProgramOptions
    ReDim MyBiasVector(0 To 6) As Double
    m_bLogging = False
On Error GoTo LoadOptionsError
    ChDir App.Path  'change directory to the app. path so that help files can be found
    MyOptions.Load                 'load persistent program options
    
    If MyOptions.ShowGettingStarted Then
        If Len(App.HelpFile) = 0 Then
            MsgBox "Unable to display Help contents. There is no Help associated with this project.", vbInformation, Me.Caption
        Else
            On Error Resume Next
            HtmlHelp Me.hwnd, App.HelpFile & "::\html\Demo Getting Started.htm", 1, 0 'show Getting Started page
            If Err Then
                MsgBox Err.Description
            End If
            MyOptions.ShowGettingStarted = False    'don't show it next time
        End If
    End If
    
On Error GoTo LoadConfigError
    'load startup configuration file
    If MyOptions.LoadOnStartup <> "" Then LoadScript MyOptions.LoadOnStartup

On Error GoTo DAQError
    SetupDAQ
    
LoadExit:
    'refresh units and other labels
    RefreshLabels
    Timer1.Interval = MyOptions.TimerInterval
    Exit Sub

LoadOptionsError:
    MsgBox "Warning: Could not restore settings. " & vbCrLf & Err.Description & " (" & Err.Number & ")"
    Resume Next
LoadConfigError:
    MsgBox "Warning: Could not restore configuration. " & vbCrLf & Err.Description & " (" & Err.Number & ")"
    Resume Next

DAQError:
    Select Case Err.Number
        Case 48: MsgBox "NI-DAQ driver could not be started.  Close any other programs that use NI-DAQ, and make sure the correct version of NI-DAQ is installed."
        Case Else: MsgBox "Error configuring NI-DAQ: " & Err.Description
    End Select
    Resume LoadExit
    
OtherError:
    MsgBox "A critical system component is missing: " & Err.Description
    End
End Sub

Private Sub Form_Unload(Cancel As Integer)
On Error GoTo SaveOptionsError
    MyOptions.Save
On Error GoTo DAQError
    Set MyDAQSystem = Nothing
    Set MyCalibration = Nothing
    Set MyFT = Nothing
    Set MyOptions = Nothing
    Exit Sub
DAQError:
    MsgBox "Error closing NI-DAQ: " & Err.Description
    Resume Next 'a DAQ error will not prevent closing the program
SaveOptionsError:
    MsgBox "Warning: Could not save settings." & vbCrLf & Err.Description & " (" & Err.Number & ")"
    Resume Next 'if settings cannot be saved, it's not a fatal error
End Sub

Private Sub SetupDAQ()
'start communication with hardware
    If CalFileLoaded Then
        'use input ranges from calibration file
        Dim OutputMode As Integer
        Select Case MyCalibration.OutputMode
            Case "True Differential": OutputMode = 0
            Case "Ground Referenced Differential": OutputMode = 0
            Case "Referenced Single-Ended": OutputMode = 1
            Case "Nonreferenced Single-Ended": OutputMode = 2
            Case Else: OutputMode = 0
        End Select
        MyDAQSystem.Setup MyOptions.Device, MyOptions.BufMode, MyOptions.FilterLevel, MyOptions.ScanRate, OutputMode, MyCalibration.OutputRange, MyCalibration.OutputBipolar, MyOptions.FirstChannel, MyCalibration.TempCompEnabled
    Else
        'use default input ranges
        MyDAQSystem.Setup MyOptions.Device, MyOptions.BufMode, MyOptions.FilterLevel, MyOptions.ScanRate, , , , MyOptions.FirstChannel, False
    End If
End Sub


Private Sub Timer1_Timer()
'Updates the F/T reading displays
    Dim status As Integer
    Dim i As Integer
    Dim voltages(0 To 6) As Double
    Dim FTValues As Variant
    
    'get data from NI-DAQ
    status = MyDAQSystem.Scan(voltages)

    'check for saturation
    lblWarning.Visible = status
    Select Case status
        Case 0: lblWarning.Visible = False
        Case 1: 'gauge saturation
                If MyOptions.BeepForSaturation Then Beep
                lblWarning.Caption = "WARNING: ADC Saturation"
                lblWarning.Visible = True
        Case 2: 'buffer overflow
                lblWarning.Caption = "WARNING: Buffer Overflow Decrease Scan Rate"
                lblWarning.Visible = True
    End Select
    
    If m_bLogging Then
        writeDataToFile voltages
    End If
    
    If CalFileLoaded Then
        FTValues = MyCalibration.ConvertToFT(voltages)
        'if MyOptions.Show3DCube then
            ATIFTVisualizer1.setForceVector FTValues(0), FTValues(1), FTValues(2)
            ATIFTVisualizer1.setTorqueVector FTValues(3), FTValues(4), FTValues(5)
        'end if
    End If
    
    'update text boxes and bar graphs
    If DispOption(1).Value = True Then
        For i = 0 To 5
            If MyOptions.BiasRawVoltages Then voltages(i) = voltages(i) - MyBiasVector(i)
            FTValue(i) = Format(voltages(i), FTFormat(i))
            UpdateBar i, voltages(i), MyDAQSystem.MaxVoltage
        Next i
    Else
        For i = 0 To 5
            FTValue(i) = Format(FTValues(i), FTFormat(i))
            UpdateBar i, FTValues(i), MyCalibration.AxisMaxLoad(i + 1)
        Next i
    End If
    
    If MyOptions.ShowThermistor Then
        lblThermistor = Format(voltages(6), "0.0000")
    End If
    
    Me.Refresh
End Sub

'utility functions
Private Sub UpdateBar(ByVal i As Integer, ByVal Value As Double, ByVal MaxValue As Double)
'This function updates the bar graph for one axis/voltage channel
    Dim BarWidth As Double
    Dim NewWidth As Double
    BarWidth = Shape1.Width     'get the full width of a bar
    If Value < 0 Then
        Value = -Value
        fgauge(i).FillColor = NegColor
    Else
        fgauge(i).FillColor = PosColor
    End If
    NewWidth = Value / MaxValue * BarWidth
    If (NewWidth > BarWidth) Then     'overflow
        NewWidth = BarWidth
        fgauge(i).FillColor = fgauge(i).FillColor Or OverflowColor
    End If
    fgauge(i).Width = NewWidth
End Sub
Private Sub RefreshLabels()
'This function is called whenever F/T settings or program settings are changed.
'It updates the axis labels, unit labels, status bar, and other information.
    Dim i As Integer
    If DispOption(1) Then           ' set up labels on screen
        Axis(0).Caption = "0"
        Axis(1).Caption = "1"
        Axis(2).Caption = "2"
        TAxis(0).Caption = "3"
        TAxis(1).Caption = "4"
        TAxis(2).Caption = "5"
        Frame1.Caption = "Gauges (V)"
        Frame2.Caption = "Gauges (V)"
        For i = 0 To 5
            FTFormat(i) = "0.0000"
        Next i
    Else
        Axis(0).Caption = "X"
        Axis(1).Caption = "Y"
        Axis(2).Caption = "Z"
        TAxis(0).Caption = "X"
        TAxis(1).Caption = "Y"
        TAxis(2).Caption = "Z"
        If CalFileLoaded Then   'just a precaution
            Frame1.Caption = "Force (" & MyCalibration.ForceUnits & ")"
            Frame2.Caption = "Torque (" & MyCalibration.TorqueUnits & ")"
            For i = 0 To 5
                Select Case MyCalibration.AxisMaxLoad(i + 1)
                    Case Is < 10: FTFormat(i) = "0.0000"
                    Case Is < 100: FTFormat(i) = "#0.000"
                    Case Is < 1000: FTFormat(i) = "##0.00"
                    Case Is < 10000: FTFormat(i) = "###0.0"
                    Case Is < 100000: FTFormat(i) = "######"
                End Select
            Next i
        End If
    End If
    
    If CalFileLoaded Then
        btnBias.Enabled = True
        DispOption(0).Enabled = True
        mnuSettings.Enabled = True
        mnuSensorInfo.Enabled = True
        mnuSaveConfiguration.Enabled = True
        Me.Caption = "ATI DAQ F/T Demo: " & MyFT.Serial
        StatusBar1.Panels(1).Text = MyFT.Serial
        StatusBar1.Panels(2).Text = MyFT.BodyStyle & "/" & MyCalibration.PartNumber
        ATIFTVisualizer1.MaxForce = MyCalibration.AxisMaxLoad(1)
        ATIFTVisualizer1.MaxTorque = MyCalibration.AxisMaxLoad(6)
    Else
        btnBias.Enabled = False
        DispOption(0).Enabled = False
        mnuSettings.Enabled = False
        mnuSensorInfo.Enabled = False
        mnuSaveConfiguration.Enabled = False
        Me.Caption = "ATI DAQ F/T Demo"
        StatusBar1.Panels(1).Text = "No Calibration Loaded"
        StatusBar1.Panels(2).Text = ""
    End If
    
    If MyDAQSystem.Configured Then
        StatusBar1.Panels(3).Text = "Input Range: " & MyDAQSystem.InputRange
    Else
        StatusBar1.Panels(3).Text = "NI-DAQ Not Configured"
    End If
    
    If MyOptions.ShowThermistor Then
        lblThermLabel.Visible = True
        lblThermistor.Visible = True
    Else
        lblThermLabel.Visible = False
        lblThermistor.Visible = False
    End If
    If MyOptions.BiasRawVoltages Then
        btnBias.Enabled = True
        btnUnbias.Visible = True
    Else
        btnBias.Enabled = DispOption(0) 'only enabled in F/T units mode
        btnUnbias.Visible = False
    End If
    ATIFTVisualizer1.Visible = MyOptions.Show3DCube
End Sub
Private Sub SetCalibration(Index As Integer)
'Sets the active calibration.  Checks for unsupported calibration
'(such as wrong number of gauges or channels)
    Set MyCalibration = MyFT.Calibrations(Index)
    If MyCalibration.NumAxes <> 6 Or MyFT.NumChannels <> 7 Then
        MsgBox "This demo only works for 6-axis transducers with 7 voltage channels."
        CalFileLoaded = False
        Timer1.Enabled = False
        DispOption(0).Enabled = True
        DispOption(1).Value = True
    Else
        CalFileLoaded = True
        DispOption(0).Enabled = False
        DispOption(0).Value = True
    End If
End Sub
Private Sub LoadScript(ScriptPath)
'Loads a configuration file to return MyFT to a previous state
    MyFT.LoadScript ScriptPath
    SetCalibration 1 'start with first calibration, by default
End Sub

'On-screen controls
Private Sub btnBias_Click()
'Performs a hardware scan and passes the results to ATIDAQFT.
    Dim voltages(0 To 6) As Double
    Dim status As Integer
    
On Error GoTo errhand
    'get data from NI-DAQ
    status = MyDAQSystem.Scan(voltages)
    If status Then Exit Sub     'saturation condition
    If CalFileLoaded Then MyCalibration.Bias voltages 'Now ConvertToFT will automatically account for the bias reading.
    MyBiasVector = voltages    'record bias vector for raw voltages
    Exit Sub
errhand:
    MsgBox Err.Description
End Sub
Private Sub btnUnbias_Click()
    Dim i As Integer
    For i = 0 To 6
        MyBiasVector(i) = 0
    Next i
    If CalFileLoaded Then MyCalibration.ClearBias
End Sub
Private Sub DispOption_Click(Index As Integer)
    RefreshLabels
End Sub
Private Sub btnLogData_Click()
    m_bLogging = Not m_bLogging
    If m_bLogging Then
        btnLogData.Caption = "Stop Logging"
    Else
        btnLogData.Caption = "Log Data"
    End If
End Sub

Private Sub writeDataToFile(voltages() As Double)

    'write F/T data to a tab-delimited file
    On Error GoTo errhand

    Dim i As Integer
    Dim FTValues As Variant
    Dim OutFile As Integer
    Dim NewFile As Boolean
    OutFile = FreeFile
    
    
    
    If Dir(MyOptions.LogFile) = "" Then NewFile = True
    
    'write to file
    Open MyOptions.LogFile For Append As #OutFile
    
    If NewFile Then
        Print #OutFile, "Time" & vbTab & "Fx" & vbTab & "Fy" & _
        vbTab & "Fz" & vbTab & "Tx" & vbTab & "Ty" & vbTab & "Tz" & _
        vbTab & "G0" & vbTab & "G1" & vbTab & "G2" & vbTab & "G3" & _
        vbTab & "G4" & vbTab & "G5" & vbTab & "G6" & vbTab & vbCrLf;
    End If
    
    Print #OutFile, Now & vbTab;
    
    If CalFileLoaded Then
        FTValues = MyCalibration.ConvertToFT(voltages)
    Else
        FTValues = Array(0, 0, 0, 0, 0, 0)
    End If
    For i = 0 To 5
        Print #OutFile, FTValues(i) & vbTab;
    Next i
    For i = 0 To 6
        If MyOptions.BiasRawVoltages Then voltages(i) = voltages(i) - MyBiasVector(i)
        Print #OutFile, voltages(i) & vbTab;
    Next i
    Print #OutFile, vbCrLf;
    
LogExit:
    Close #OutFile
    Exit Sub
errhand:
    m_bLogging = False
    MsgBox "Error logging data: " & Err.Description & vbCr & vbLf & _
        "Data collection stopped"
    Resume LogExit

End Sub

'Menu handlers
Private Sub mnuOpenCalibration_Click()
'loads a calibration file into the FTSensor object.
On Error GoTo errhand
    Dim FilePath As String
    With CommonDialog2
        .CancelError = True
        .InitDir = MyOptions.CalFileDir
        .Filter = "ATI DAQ F/T Calibration Files (*.cal)|*.cal|All files (*.*)|*.*"
        .FilterIndex = 0
        .ShowOpen
        FilePath = .FileName
        MyOptions.CalFileDir = FilePath
        
        'check to see if the calibration file is still on the CD-ROM
        If IsOnCDROM(FilePath) Then
            If MsgBox("It is recommended that your calibration file be located in your ATI DAQ F/T program directory, " & _
                "so that it will always be available for loading.  Would you like to copy the file to your program directory?", vbYesNo) _
                = vbYes Then
                FileCopy FilePath, App.Path & "\" & .FileTitle
                FilePath = App.Path & "\" & .FileTitle
            End If
        End If
    End With
    
    MyFT.CalFilePath = FilePath
    
    SetCalibration 1 'start with first calibration, by default
    SetupDAQ
subexit:
    RefreshLabels
    Exit Sub
errhand:
    Select Case Err.Number
        Case cdlCancel: Exit Sub    'cancel button
        Case Else:                  'unknown error
            MsgBox Err.Description & " (" & Err.Number & ")"
    End Select
    Resume subexit
End Sub
Private Function IsOnCDROM(FilePath As String) As Boolean
On Error GoTo NoScrrun
    Dim fs As New FileSystemObject
    Dim d As Drive
    Dim DriveSpec As String
    DriveSpec = fs.GetDriveName(fs.GetAbsolutePathName(FilePath))
    Set d = fs.GetDrive(DriveSpec)
    IsOnCDROM = (d.DriveType = CDRom)
    Exit Function
NoScrrun:
    'Err.Raise vbObjectError, , "The system component scrrun.dll is not registered."
    IsOnCDROM = False
End Function
Private Sub mnuOpenConfiguration_Click()
'loads a previous state of the FTSensor object from a file.
On Error GoTo errhand
    Dim FilePath As String
    With CommonDialog1
        .CancelError = True
        .InitDir = MyOptions.ConfigFileDir
        .Filter = "ATI DAQ F/T Configuration Files (*" & CONFIGEXT & ")|*" & CONFIGEXT & "|All files (*.*)|*.*"
        .FilterIndex = 0
        .ShowOpen
        FilePath = .FileName
        MyOptions.ConfigFileDir = FilePath
    End With
    LoadScript FilePath 'load the configuration file
subexit:
    RefreshLabels
    Exit Sub
errhand:
    Select Case Err.Number
        Case cdlCancel: Exit Sub    'cancel button
        Case Else:              'unknown error
            MsgBox Err.Description & " (" & Err.Number & ")"
    End Select
    Resume subexit
End Sub
Private Sub mnuSaveConfiguration_Click()
'saves the current state of the ATIDAQFT.FTSensor object to a file.
'this includes the calibration file, current output units,
'tool transforms, etc.
On Error GoTo errhand
    Dim FilePath As String
    With CommonDialog1
        .CancelError = True
        .InitDir = MyOptions.ConfigFileDir
        .Filter = "ATI DAQ F/T Configuration Files (*" & CONFIGEXT & ")|*" & CONFIGEXT & "|All files (*.*)|*.*"
        .FilterIndex = 0
        .ShowSave
        FilePath = .FileName
        MyOptions.ConfigFileDir = FilePath
    End With
    MyFT.SaveScript FilePath    'save the configuration file
    
    If MsgBox("Would you like this configuration to load automatically when this program starts?", vbYesNo) = vbYes Then
        MyOptions.LoadOnStartup = FilePath
    End If
    
subexit:
    Exit Sub
errhand:
    Select Case Err.Number
        Case cdlCancel: Exit Sub    'cancel button
        Case Else:              'unknown error
            MsgBox Err.Description & " (" & Err.Number & ")"
    End Select
    Resume subexit
End Sub
Private Sub mnuProgramOptions_Click()
'displays a dialog with program preferences and hardware settings
'such as screen update rate, default device number, and startup
'options.
    Dim MyOptionsForm As New frmProgramOptions
    Set MyOptionsForm.MyOptions = MyOptions
    Timer1.Enabled = False
    MyOptionsForm.Show vbModal
    If Not MyOptionsForm.Cancelled Then
        'implement new program options
        Timer1.Interval = MyOptions.TimerInterval
On Error GoTo DAQError
        SetupDAQ
        RefreshLabels
    End If
subexit:
    Unload MyOptionsForm
    Set MyOptionsForm = Nothing
    RefreshLabels
    Exit Sub
DAQError:
    MsgBox "Error configuring NI-DAQ: " & Err.Description
    Resume subexit
End Sub
Private Sub mnuSettings_Click()
'displays a dialog with transducer configuration information
'such as output units and tool transforms.
'These are the settings handled by ATIDAQFT.Calibration object.
    Dim MySettings As New frmSettings
    Set MySettings.MyCalibration = MyCalibration
    Timer1.Enabled = False
On Error GoTo errhand
    MySettings.Show vbModal
    MyDAQSystem.Ch6Saturates = MyCalibration.TempCompEnabled
    
subexit:
    Unload MySettings
    Set MySettings = Nothing
    RefreshLabels
    Exit Sub
errhand:
    MsgBox Err.Description & " (" & Err.Number & ")"
    Resume subexit
End Sub
Private Sub mnuSensorInfo_Click()
'displays a dialog with information about the transducer and calibrations
'you can change the active calibration from this dialog
    Dim MySensorInfo As New frmSensorInfo
    Set MySensorInfo.MyFT = MyFT
    Timer1.Enabled = False
    MySensorInfo.ActiveCalibration = MyCalibration.Index
On Error GoTo errhand
    MySensorInfo.Show vbModal
    SetCalibration MySensorInfo.ActiveCalibration
    SetupDAQ
subexit:
    Unload MySensorInfo
    Set MySensorInfo = Nothing
    RefreshLabels
    Exit Sub
errhand:
    MsgBox Err.Description & " (" & Err.Number & ")"
    Resume subexit
End Sub
Private Sub mnuHelpContents_Click()
    Dim nRet As Integer

    'if there is no helpfile for this project display a message to the user
    'you can set the HelpFile for your application in the
    'Project Properties dialog
    If Len(App.HelpFile) = 0 Then
        MsgBox "Unable to display Help Contents. There is no Help associated with this project.", vbInformation, Me.Caption
    Else
        On Error Resume Next
        nRet = HtmlHelp(Me.hwnd, App.HelpFile, 1, 0)
        If Err Then
            MsgBox Err.Description
        End If
    End If
End Sub
Private Sub mnuAbout_Click()
'shows an about box with software versions and copyright info
    Dim MyAbout As New frmAbout
    Set MyAbout.MyFT = MyFT
On Error GoTo errhand
    MyAbout.Show vbModal
subexit:
    Unload MyAbout
    Set MyAbout = Nothing
    Exit Sub
errhand:
    MsgBox Err.Description & " (" & Err.Number & ")"
    Resume subexit
End Sub
Private Sub mnuExit_Click()
    Unload Me
End Sub
