VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Begin VB.Form frmProgramOptions 
   Caption         =   "Program Options"
   ClientHeight    =   3900
   ClientLeft      =   4785
   ClientTop       =   2205
   ClientWidth     =   7035
   HelpContextID   =   2500
   Icon            =   "frmProgramOptions.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3900
   ScaleWidth      =   7035
   Begin VB.CommandButton btnHelp 
      Caption         =   "Help"
      Height          =   375
      Left            =   5820
      TabIndex        =   28
      Top             =   3420
      Width           =   1095
   End
   Begin TabDlg.SSTab SSTab1 
      Height          =   3135
      Left            =   120
      TabIndex        =   2
      Top             =   180
      Width           =   6795
      _ExtentX        =   11986
      _ExtentY        =   5530
      _Version        =   393216
      Tabs            =   4
      Tab             =   1
      TabsPerRow      =   4
      TabHeight       =   520
      TabCaption(0)   =   "General"
      TabPicture(0)   =   "frmProgramOptions.frx":0D82
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "txtTimerInterval"
      Tab(0).Control(1)=   "chkShow3DCube"
      Tab(0).Control(2)=   "chkBeepForSaturation"
      Tab(0).Control(3)=   "chkBiasRawVoltages"
      Tab(0).Control(4)=   "chkShowThermistor"
      Tab(0).Control(5)=   "Label3"
      Tab(0).Control(6)=   "Label2"
      Tab(0).ControlCount=   7
      TabCaption(1)   =   "NI-DAQ"
      TabPicture(1)   =   "frmProgramOptions.frx":0D9E
      Tab(1).ControlEnabled=   -1  'True
      Tab(1).Control(0)=   "Label7"
      Tab(1).Control(0).Enabled=   0   'False
      Tab(1).Control(1)=   "Label6"
      Tab(1).Control(1).Enabled=   0   'False
      Tab(1).Control(2)=   "Label5"
      Tab(1).Control(2).Enabled=   0   'False
      Tab(1).Control(3)=   "Label4"
      Tab(1).Control(3).Enabled=   0   'False
      Tab(1).Control(4)=   "Label9"
      Tab(1).Control(4).Enabled=   0   'False
      Tab(1).Control(5)=   "Label1"
      Tab(1).Control(5).Enabled=   0   'False
      Tab(1).Control(6)=   "txtScanRate"
      Tab(1).Control(6).Enabled=   0   'False
      Tab(1).Control(7)=   "txtFilterLevel"
      Tab(1).Control(7).Enabled=   0   'False
      Tab(1).Control(8)=   "chkBufMode"
      Tab(1).Control(8).Enabled=   0   'False
      Tab(1).Control(9)=   "txtFirstChannel"
      Tab(1).Control(9).Enabled=   0   'False
      Tab(1).Control(10)=   "txtDevice"
      Tab(1).Control(10).Enabled=   0   'False
      Tab(1).ControlCount=   11
      TabCaption(2)   =   "Startup"
      TabPicture(2)   =   "frmProgramOptions.frx":0DBA
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "Frame2"
      Tab(2).ControlCount=   1
      TabCaption(3)   =   "Data Logging"
      TabPicture(3)   =   "frmProgramOptions.frx":0DD6
      Tab(3).ControlEnabled=   0   'False
      Tab(3).Control(0)=   "Frame1"
      Tab(3).ControlCount=   1
      Begin VB.Frame Frame2 
         Caption         =   "When this program starts:"
         Height          =   1275
         Left            =   -74820
         TabIndex        =   24
         Top             =   780
         Width           =   6495
         Begin VB.TextBox txtLoadOnStartup 
            Enabled         =   0   'False
            Height          =   285
            Left            =   420
            ScrollBars      =   1  'Horizontal
            TabIndex        =   27
            ToolTipText     =   "Specifies the path to the configuration file to load at startup"
            Top             =   780
            Width           =   5475
         End
         Begin VB.CommandButton btnStartupConfigBrowse 
            Caption         =   "..."
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   12
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Left            =   6000
            TabIndex        =   26
            ToolTipText     =   "Browse for the startup configuration file"
            Top             =   780
            Width           =   375
         End
         Begin VB.CheckBox chkLoadOnStartup 
            Caption         =   "Load this configuration file:"
            Height          =   375
            Left            =   300
            TabIndex        =   25
            ToolTipText     =   "If checked, the specified configuration file will be loaded when the program starts"
            Top             =   300
            Width           =   2895
         End
      End
      Begin VB.Frame Frame1 
         Caption         =   "Append Data To File:"
         Height          =   795
         Left            =   -74820
         TabIndex        =   21
         Top             =   1200
         Width           =   6495
         Begin VB.CommandButton btnLogFileBrowse 
            Caption         =   "..."
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   12
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Left            =   6000
            TabIndex        =   23
            ToolTipText     =   "Browse for data file"
            Top             =   300
            Width           =   375
         End
         Begin VB.TextBox txtLogFile 
            Height          =   285
            Left            =   120
            ScrollBars      =   1  'Horizontal
            TabIndex        =   22
            ToolTipText     =   "Specifies the path to a file to append data to when Log Data button is pressed"
            Top             =   300
            Width           =   5775
         End
      End
      Begin VB.TextBox txtDevice 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   3000
         TabIndex        =   18
         ToolTipText     =   "Specifies the device number assigned to NI-DAQ system by MAX"
         Top             =   720
         Width           =   735
      End
      Begin VB.TextBox txtFirstChannel 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   3000
         TabIndex        =   17
         ToolTipText     =   "Specifies the index of first channel for this transducer (typically 0)"
         Top             =   1080
         Width           =   735
      End
      Begin VB.CheckBox chkBufMode 
         Caption         =   "Buffer Mode (better performance in Windows NT/2000)"
         Height          =   375
         Left            =   360
         TabIndex        =   12
         ToolTipText     =   "Enable/disable continuous double-buffering mode"
         Top             =   1680
         Width           =   4215
      End
      Begin VB.TextBox txtFilterLevel 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   3000
         TabIndex        =   11
         ToolTipText     =   "If buffer mode is used, specifies the number of samples to average for each measurement"
         Top             =   2400
         Width           =   735
      End
      Begin VB.TextBox txtScanRate 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   3000
         TabIndex        =   10
         ToolTipText     =   "If buffer mode is used, specifies the update rate"
         Top             =   2040
         Width           =   735
      End
      Begin VB.TextBox txtTimerInterval 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   -71940
         TabIndex        =   7
         ToolTipText     =   "Specifies the screen refresh rate"
         Top             =   780
         Width           =   735
      End
      Begin VB.CheckBox chkShow3DCube 
         Caption         =   "Show 3D Cube"
         Height          =   375
         Left            =   -74640
         TabIndex        =   6
         ToolTipText     =   "Enable/disable 3D cube display on main screen"
         Top             =   2280
         Width           =   1635
      End
      Begin VB.CheckBox chkBeepForSaturation 
         Caption         =   "Beep for ADC saturation"
         Height          =   375
         Left            =   -74640
         TabIndex        =   5
         ToolTipText     =   "Enable/disable the audible beep when transducer exceeds saturation loads"
         Top             =   1380
         Width           =   2535
      End
      Begin VB.CheckBox chkBiasRawVoltages 
         Caption         =   "Allow Bias/Unbias of Raw Voltages"
         Height          =   375
         Left            =   -74640
         TabIndex        =   4
         ToolTipText     =   "Enable/disable biasing and unbiasing of raw voltages on the main screen"
         Top             =   1680
         Width           =   3435
      End
      Begin VB.CheckBox chkShowThermistor 
         Caption         =   "Show Thermistor Reading"
         Height          =   375
         Left            =   -74640
         TabIndex        =   3
         ToolTipText     =   "Enable/disable thermistor display on main screen"
         Top             =   1980
         Width           =   3435
      End
      Begin VB.Label Label1 
         Caption         =   "NI-DAQ Device Number:"
         Height          =   255
         Left            =   360
         TabIndex        =   20
         Top             =   720
         Width           =   1935
      End
      Begin VB.Label Label9 
         Caption         =   "First Channel Index:"
         Height          =   255
         Left            =   360
         TabIndex        =   19
         Top             =   1080
         Width           =   1935
      End
      Begin VB.Label Label4 
         Caption         =   "Filter Level:"
         Height          =   255
         Left            =   900
         TabIndex        =   16
         Top             =   2400
         Width           =   975
      End
      Begin VB.Label Label5 
         Caption         =   "Scan Rate:"
         Height          =   255
         Left            =   900
         TabIndex        =   15
         Top             =   2040
         Width           =   975
      End
      Begin VB.Label Label6 
         Caption         =   "Hz"
         Height          =   255
         Left            =   3900
         TabIndex        =   14
         Top             =   2040
         Width           =   375
      End
      Begin VB.Label Label7 
         Caption         =   "samples"
         Height          =   255
         Left            =   3900
         TabIndex        =   13
         Top             =   2400
         Width           =   735
      End
      Begin VB.Label Label3 
         Caption         =   "ms"
         Height          =   255
         Left            =   -71100
         TabIndex        =   9
         Top             =   780
         Width           =   375
      End
      Begin VB.Label Label2 
         Caption         =   "Timer Interval for Screen Updates:"
         Height          =   255
         Left            =   -74580
         TabIndex        =   8
         Top             =   780
         Width           =   2775
      End
   End
   Begin MSComDlg.CommonDialog CommonDialog2 
      Left            =   180
      Top             =   3300
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton btnCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   4620
      TabIndex        =   1
      Top             =   3420
      Width           =   1095
   End
   Begin VB.CommandButton btnOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   3420
      TabIndex        =   0
      Top             =   3420
      Width           =   1095
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   180
      Top             =   3300
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
End
Attribute VB_Name = "frmProgramOptions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'frmProgramOptions
'This form allows the user to set program options such as screen update rate
'and startup options.
'The settings on this screen are saved at shutdown and restored at startup.
Option Explicit
Public Cancelled As Boolean         'Did the user click Cancel or OK?
Public MyOptions As ProgramOptions  'object that holds all persistable program options
Const MaxFilterLevel = 1000        'maximum number of records to average

Private Sub btnLogFileBrowse_Click()
'This procedure lets the user pick the data log file
'from an Open file dialog.
On Error GoTo errhand
    Dim FilePath As String
    With CommonDialog2
        .CancelError = True
        .InitDir = MyOptions.LogFile
        .Filter = "Text Files (*.txt)|*.txt|Excel Files (*.xls)|*.xls|All files (*.*)|*.*"
        .FilterIndex = 0
        .DefaultExt = ".txt"
        .ShowOpen
        FilePath = .FileName
        MyOptions.LogFile = FilePath
    End With
    txtLogFile.Text = FilePath
    Exit Sub
errhand:
    Select Case Err.Number
        Case cdlCancel: Exit Sub    'cancel button
        Case Else:              'unknown error
            MsgBox Err.Description
    End Select
    Resume Next
End Sub
Private Sub btnStartupConfigBrowse_Click()
'This procedure lets the user pick the startup
'configuration file from an Open file dialog.
On Error GoTo errhand
    Dim FilePath As String
    With CommonDialog1
        .CancelError = True
        .InitDir = MyOptions.ConfigFileDir
        .Filter = "ATI DAQ F/T Configuration Files (*" & CONFIGEXT & ")|*" & CONFIGEXT & "|All files (*.*)|*.*"
        .FilterIndex = 0
        .ShowOpen
        FilePath = .FileName
        MyOptions.ConfigFileDir = FilePath
    End With
    txtLoadOnStartup.Text = FilePath
    Exit Sub
errhand:
    Select Case Err.Number
        Case cdlCancel: Exit Sub    'cancel button
        Case Else:              'unknown error
            MsgBox Err.Description
    End Select
    Resume Next
End Sub
Private Sub btnCancel_Click()
'No changes are retained.
    Cancelled = True
    Me.Hide
End Sub
Private Sub btnHelp_Click()
    If Len(App.HelpFile) = 0 Then
        MsgBox "Unable to display Help contents. There is no Help associated with this project.", vbInformation, Me.Caption
    Else
        On Error Resume Next
        HtmlHelp Me.hwnd, App.HelpFile & "::\html\Demo Program Options Screen.htm", 1, 0
        If Err Then
            MsgBox Err.Description
        End If
    End If
End Sub
Private Sub btnOK_Click()
'validate entries and store settings
    Dim TI As Long
    Dim temp As Double
    Dim Device As Integer
    Dim FL As Integer
    Dim SR As Double
    Dim FC As Integer
    temp = Int(Val(txtDevice.Text))
    If temp < 1 Or temp > 32767 Then
        MsgBox "Device number must be a positive integer less than 32767."
        Exit Sub
    End If
    Device = temp
    temp = Int(Val(txtTimerInterval.Text))
    If temp < 1 Or temp > 65535 Then
        MsgBox "Timer interval must be a number between 1 and 65535."
        Exit Sub
    End If
    TI = temp
    temp = Int(Val(txtFilterLevel.Text))
    If temp < 0 Or temp > MaxFilterLevel Then
        MsgBox "Filter level must be between 0 and " & MaxFilterLevel & "."
        Exit Sub
    End If
    FL = temp
    temp = Val(txtScanRate.Text)
    If temp < 1 Then
        MsgBox "Scan rate must be greater than 1 Hz."
        Exit Sub
    End If
    If temp > MAX_IFPS_SCAN_RATE Then
        MsgBox "Warning: F/T IFPS only supports a scan rate of " & MAX_IFPS_SCAN_RATE & " Hz.  Accuracy is not guaranteed at higher scan rates.", vbExclamation
    End If
    SR = temp
    temp = Val(txtFirstChannel.Text)
    If temp < 0 Or temp > 63 Then
        MsgBox "First channel index must be between 0 and 63."
        Exit Sub
    End If
    FC = temp
    MyOptions.FirstChannel = FC
    MyOptions.BeepForSaturation = chkBeepForSaturation.Value
    MyOptions.BufMode = chkBufMode.Value
    MyOptions.Device = Device
    MyOptions.LoadOnStartup = txtLoadOnStartup.Text
    MyOptions.TimerInterval = TI
    MyOptions.BiasRawVoltages = chkBiasRawVoltages.Value
    MyOptions.FilterLevel = FL
    MyOptions.ShowThermistor = chkShowThermistor.Value
    MyOptions.ScanRate = SR
    MyOptions.LogFile = txtLogFile.Text
    MyOptions.Show3DCube = chkShow3DCube.Value
    Cancelled = False
    Me.Hide
End Sub
Private Sub chkBufMode_Click()
    txtFilterLevel.Enabled = (chkBufMode.Value = vbChecked)
    txtScanRate.Enabled = (chkBufMode.Value = vbChecked)
End Sub
Private Sub chkLoadOnStartup_Click()
    If chkLoadOnStartup.Value = vbChecked Then
        txtLoadOnStartup.Enabled = True
        btnStartupConfigBrowse.Enabled = True
    Else
        txtLoadOnStartup.Text = ""
        txtLoadOnStartup.Enabled = False
        btnStartupConfigBrowse.Enabled = False
    End If
End Sub

Private Sub Form_Load()
'fill the input controls with the current options.
    Cancelled = True
    txtFirstChannel.Text = MyOptions.FirstChannel
    chkBeepForSaturation.Value = CheckBox(MyOptions.BeepForSaturation)
    chkBufMode.Value = CheckBox(MyOptions.BufMode)
    chkBiasRawVoltages = CheckBox(MyOptions.BiasRawVoltages)
    txtDevice.Text = MyOptions.Device
    txtLoadOnStartup = MyOptions.LoadOnStartup
    chkLoadOnStartup = CheckBox(MyOptions.LoadOnStartup <> "")
    chkLoadOnStartup_Click
    txtTimerInterval.Text = MyOptions.TimerInterval
    txtFilterLevel.Text = MyOptions.FilterLevel
    txtScanRate.Text = MyOptions.ScanRate
    chkShowThermistor.Value = CheckBox(MyOptions.ShowThermistor)
    chkBufMode_Click
    txtLogFile.Text = MyOptions.LogFile
    chkShow3DCube.Value = CheckBox(MyOptions.Show3DCube)
End Sub
