VERSION 5.00
Begin VB.Form frmSensorInfo 
   Caption         =   "Sensor Information"
   ClientHeight    =   7725
   ClientLeft      =   4830
   ClientTop       =   2700
   ClientWidth     =   6360
   HelpContextID   =   2400
   Icon            =   "frmSensorInfo.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7725
   ScaleWidth      =   6360
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton btnOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   3900
      TabIndex        =   25
      Top             =   7200
      Width           =   1095
   End
   Begin VB.CommandButton btnHelp 
      Caption         =   "Help"
      Height          =   375
      Left            =   5100
      TabIndex        =   24
      Top             =   7200
      Width           =   1095
   End
   Begin VB.Frame Frame2 
      Caption         =   "Sensor"
      Height          =   1455
      Left            =   120
      TabIndex        =   5
      Top             =   240
      Width           =   6075
      Begin VB.Label lblFamily 
         Caption         =   "<n/a>"
         Height          =   255
         Left            =   2280
         TabIndex        =   13
         Top             =   840
         Width           =   1215
      End
      Begin VB.Label lblNumChannels 
         Caption         =   "<n/a>"
         Height          =   255
         Left            =   2280
         TabIndex        =   12
         Top             =   1080
         Width           =   1215
      End
      Begin VB.Label lblSerial 
         Caption         =   "<n/a>"
         Height          =   255
         Left            =   2280
         TabIndex        =   11
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label Label5 
         Alignment       =   1  'Right Justify
         Caption         =   "Family:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   840
         Width           =   1815
      End
      Begin VB.Label Label4 
         Alignment       =   1  'Right Justify
         Caption         =   "No. of Channels:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   1080
         Width           =   1815
      End
      Begin VB.Label Label3 
         Alignment       =   1  'Right Justify
         Caption         =   "Serial Number:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   240
         TabIndex        =   8
         Top             =   360
         Width           =   1815
      End
      Begin VB.Label lblBodyStyle 
         Caption         =   "<n/a>"
         Height          =   255
         Left            =   2280
         TabIndex        =   7
         Top             =   600
         Width           =   1215
      End
      Begin VB.Label Label1 
         Alignment       =   1  'Right Justify
         Caption         =   "Body Style:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   240
         TabIndex        =   6
         Top             =   600
         Width           =   1815
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Calibrations"
      Height          =   5295
      Left            =   120
      TabIndex        =   0
      Top             =   1800
      Width           =   6075
      Begin VB.ListBox lstCalibrations 
         Height          =   1620
         Left            =   360
         TabIndex        =   15
         ToolTipText     =   "Changes the active calibration, if more than one exists in the calibration file"
         Top             =   660
         Width           =   1575
      End
      Begin VB.ListBox lstAxes 
         Appearance      =   0  'Flat
         BackColor       =   &H8000000F&
         ForeColor       =   &H80000012&
         Height          =   1590
         Left            =   360
         TabIndex        =   1
         TabStop         =   0   'False
         Top             =   2940
         Width           =   3855
      End
      Begin VB.Label lblOutputMode 
         Caption         =   "<n/a>"
         Height          =   375
         Left            =   3900
         TabIndex        =   23
         Top             =   1620
         Width           =   2115
      End
      Begin VB.Label Label10 
         Alignment       =   1  'Right Justify
         Caption         =   "Output Mode:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2220
         TabIndex        =   22
         Top             =   1620
         Width           =   1455
      End
      Begin VB.Label lblOutputRange 
         Caption         =   "<n/a>"
         Height          =   255
         Left            =   3900
         TabIndex        =   21
         Top             =   2040
         Width           =   1215
      End
      Begin VB.Label Label12 
         Alignment       =   1  'Right Justify
         Caption         =   "Output Range:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2160
         TabIndex        =   20
         Top             =   2040
         Width           =   1515
      End
      Begin VB.Label Label6 
         Alignment       =   1  'Right Justify
         Caption         =   "Output Polarity:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2160
         TabIndex        =   19
         Top             =   2280
         Width           =   1515
      End
      Begin VB.Label lblOutputPolarity 
         Caption         =   "<n/a>"
         Height          =   255
         Left            =   3900
         TabIndex        =   18
         Top             =   2280
         Width           =   1215
      End
      Begin VB.Label txtTempComp 
         Caption         =   "<n/a>"
         Height          =   255
         Left            =   3900
         TabIndex        =   17
         Top             =   1140
         Width           =   1095
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "Temperature Compensation:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   435
         Left            =   2220
         TabIndex        =   16
         Top             =   960
         Width           =   1455
      End
      Begin VB.Label Label8 
         Caption         =   "Active Calibration"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   360
         TabIndex        =   14
         Top             =   360
         Width           =   1815
      End
      Begin VB.Label Label7 
         Alignment       =   1  'Right Justify
         Caption         =   "Calibration Date:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2100
         TabIndex        =   4
         Top             =   660
         Width           =   1575
      End
      Begin VB.Label lblCalDate 
         Caption         =   "<n/a>"
         Height          =   255
         Left            =   3900
         TabIndex        =   3
         Top             =   660
         Width           =   1095
      End
      Begin VB.Label Label9 
         Caption         =   "Rated Loads:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   360
         TabIndex        =   2
         Top             =   2700
         Width           =   1455
      End
   End
End
Attribute VB_Name = "frmSensorInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'frmSensorInfo
'This form reveals information about the transducer system
'read from the calibration file by ATIDAQFT.  This includes
'calibration date, rated loads, and other information.
'It is also where you go to change the active calibration,
'if the transducer has multiple calibrations.
Option Explicit
Public MyFT As FTSensor             'points to frmMain.MyFT
Public ActiveCalibration As Integer

Private Sub btnHelp_Click()
    If Len(App.HelpFile) = 0 Then
        MsgBox "Unable to display Help contents. There is no Help associated with this project.", vbInformation, Me.Caption
    Else
        On Error Resume Next
        HtmlHelp Me.hwnd, App.HelpFile & "::\html\Demo Sensor Information Screen.htm", 1, 0
        If Err Then
            MsgBox Err.Description
        End If
    End If
End Sub

Private Sub btnOK_Click()
    Unload Me
End Sub

Private Sub Form_Load()
'populate the dialog box
    lblBodyStyle.Caption = MyFT.BodyStyle
    lblFamily.Caption = MyFT.Family
    lblNumChannels.Caption = MyFT.NumChannels
    lblSerial.Caption = MyFT.Serial
    
    Dim Cal As Calibration
    For Each Cal In MyFT.Calibrations
        lstCalibrations.AddItem Cal.PartNumber
    Next Cal
    lstCalibrations.ListIndex = ActiveCalibration - 1
    RefreshCalInfo
End Sub
Private Sub lstCalibrations_Click()
'When the list box selection changes, the active calibration
'changes for the entire program.
    ActiveCalibration = lstCalibrations.ListIndex + 1
    RefreshCalInfo
End Sub
Private Sub RefreshCalInfo()
'updates the calibration properties based on the chosen calibration.
    With MyFT.Calibrations(ActiveCalibration)
        lblCalDate = .CalDate
    
        If .TempCompAvailable Then
            txtTempComp.Caption = "Yes"
        Else
            txtTempComp.Caption = "No"
        End If
        
        lblOutputMode.Caption = .OutputMode
        lblOutputRange.Caption = .OutputRange & " V"
        If .OutputBipolar Then
            lblOutputPolarity.Caption = "Bipolar"
        Else
            lblOutputPolarity.Caption = "Unipolar"
        End If
        
        RemoveAll lstAxes
        Dim units As String
        Dim i As Integer
        For i = 1 To .NumAxes
            If .AxisName(i) Like "F*" Then
                units = .ForceUnits
            Else
                units = .TorqueUnits
            End If
            lstAxes.AddItem .AxisName(i) & ": " & Format(.AxisMaxLoad(i), "#.###") & " " & units
        Next i
    End With
End Sub
