VERSION 5.00
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Begin VB.Form frmSettings 
   Caption         =   "Settings"
   ClientHeight    =   4830
   ClientLeft      =   4365
   ClientTop       =   3990
   ClientWidth     =   6855
   HelpContextID   =   2300
   Icon            =   "frmSettings.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4830
   ScaleWidth      =   6855
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton btnHelp 
      Caption         =   "Help"
      Height          =   375
      Left            =   5640
      TabIndex        =   14
      Top             =   4320
      Width           =   1095
   End
   Begin VB.CommandButton btnOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   4440
      TabIndex        =   13
      Top             =   4320
      Width           =   1095
   End
   Begin VB.CommandButton btnResetDefaults 
      Caption         =   "Reset Defaults"
      Height          =   375
      Left            =   2760
      TabIndex        =   12
      ToolTipText     =   "Reset all settings to factory defaults"
      Top             =   4320
      Width           =   1575
   End
   Begin TabDlg.SSTab SSTab1 
      Height          =   3975
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   6615
      _ExtentX        =   11668
      _ExtentY        =   7011
      _Version        =   393216
      Tabs            =   2
      Tab             =   1
      TabHeight       =   520
      TabCaption(0)   =   "Output Options"
      TabPicture(0)   =   "frmSettings.frx":0D82
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "Frame1"
      Tab(0).Control(1)=   "chkTempComp"
      Tab(0).ControlCount=   2
      TabCaption(1)   =   "Tool Transforms"
      TabPicture(1)   =   "frmSettings.frx":0D9E
      Tab(1).ControlEnabled=   -1  'True
      Tab(1).Control(0)=   "lstTransforms"
      Tab(1).Control(0).Enabled=   0   'False
      Tab(1).Control(1)=   "btnAdd"
      Tab(1).Control(1).Enabled=   0   'False
      Tab(1).Control(2)=   "btnRemove"
      Tab(1).Control(2).Enabled=   0   'False
      Tab(1).Control(3)=   "btnEdit"
      Tab(1).Control(3).Enabled=   0   'False
      Tab(1).Control(4)=   "btnRemoveAll"
      Tab(1).Control(4).Enabled=   0   'False
      Tab(1).ControlCount=   5
      Begin VB.CheckBox chkTempComp 
         Caption         =   "Temperature Compensation"
         Height          =   255
         Left            =   -74040
         TabIndex        =   11
         ToolTipText     =   "Enable/disable temperature compensation, if available"
         Top             =   960
         Width           =   2295
      End
      Begin VB.Frame Frame1 
         Caption         =   "Units"
         Height          =   1335
         Left            =   -74040
         TabIndex        =   6
         Top             =   1680
         Width           =   3135
         Begin VB.ComboBox cmbForceUnits 
            Height          =   315
            Left            =   1560
            Style           =   2  'Dropdown List
            TabIndex        =   8
            ToolTipText     =   "Selects the force units of the output"
            Top             =   360
            Width           =   1455
         End
         Begin VB.ComboBox cmbTorqueUnits 
            Height          =   315
            Left            =   1560
            Style           =   2  'Dropdown List
            TabIndex        =   7
            ToolTipText     =   "Selects the torque units of the output"
            Top             =   840
            Width           =   1455
         End
         Begin VB.Label Label1 
            Caption         =   "Force Units"
            Height          =   255
            Left            =   240
            TabIndex        =   10
            Top             =   360
            Width           =   1095
         End
         Begin VB.Label Label2 
            Caption         =   "Torque Units"
            Height          =   255
            Left            =   240
            TabIndex        =   9
            Top             =   840
            Width           =   1095
         End
      End
      Begin VB.CommandButton btnRemoveAll 
         Caption         =   "Remove All"
         Height          =   375
         Left            =   3600
         TabIndex        =   5
         ToolTipText     =   "Remove all tool transforms"
         Top             =   2520
         Width           =   975
      End
      Begin VB.CommandButton btnEdit 
         Caption         =   "Edit"
         Height          =   375
         Left            =   3600
         TabIndex        =   4
         ToolTipText     =   "Edit the selected tool transform"
         Top             =   1560
         Width           =   975
      End
      Begin VB.CommandButton btnRemove 
         Caption         =   "Remove"
         Height          =   375
         Left            =   3600
         TabIndex        =   3
         ToolTipText     =   "Remove the selected tool transform"
         Top             =   2040
         Width           =   975
      End
      Begin VB.CommandButton btnAdd 
         Caption         =   "Add"
         Height          =   375
         Left            =   3600
         TabIndex        =   2
         ToolTipText     =   "Add a translation or rotation to the list of tool transforms"
         Top             =   1080
         Width           =   975
      End
      Begin VB.ListBox lstTransforms 
         Height          =   1815
         Left            =   1320
         TabIndex        =   1
         Top             =   1080
         Width           =   2175
      End
   End
End
Attribute VB_Name = "frmSettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'frmSettings
'This form allows the user to change the configuration of
'their transducer system by invoking methods and properties
'of the ATIDAQFT.FTSensor object.
'These settings can be stored and recalled in configuration files.

Option Explicit
Public MyCalibration As ATIDAQFT.Calibration

Private Sub btnHelp_Click()
    If Len(App.HelpFile) = 0 Then
        MsgBox "Unable to display Help contents. There is no Help associated with this project.", vbInformation, Me.Caption
    Else
        On Error Resume Next
        HtmlHelp Me.hwnd, App.HelpFile & "::\html\Demo Settings Screen.htm", 1, 0
        If Err Then
            MsgBox Err.Description
        End If
    End If
End Sub
Private Sub btnOK_Click()
    Unload Me
End Sub

Private Sub btnResetDefaults_Click()
    MyCalibration.ResetDefaults
    RefreshTTs
    cmbForceUnits.Text = MyCalibration.ForceUnits
    cmbTorqueUnits.Text = MyCalibration.TorqueUnits
    chkTempComp.Value = CheckBox(MyCalibration.TempCompEnabled)
    chkTempComp.Enabled = MyCalibration.TempCompAvailable
End Sub

Private Sub Form_Load()
    RefreshTTs
    cmbForceUnits.AddItem "lb"
    cmbForceUnits.AddItem "N"
    cmbForceUnits.AddItem "kN"
    cmbForceUnits.AddItem "g"
    cmbForceUnits.AddItem "kg"
    cmbTorqueUnits.AddItem "in-lb"
    cmbTorqueUnits.AddItem "ft-lb"
    cmbTorqueUnits.AddItem "Nm"
    cmbTorqueUnits.AddItem "Nmm"
    cmbTorqueUnits.AddItem "kgcm"
    cmbTorqueUnits.AddItem "kNm"
    cmbForceUnits.Text = MyCalibration.ForceUnits
    cmbTorqueUnits.Text = MyCalibration.TorqueUnits
    chkTempComp.Value = CheckBox(MyCalibration.TempCompEnabled)
    chkTempComp.Enabled = MyCalibration.TempCompAvailable
End Sub

'Output Options
Private Sub chkTempComp_Click()
    MyCalibration.TempCompEnabled = chkTempComp.Value
End Sub
Private Sub cmbForceUnits_Click()
    MyCalibration.ForceUnits = cmbForceUnits.Text
End Sub
Private Sub cmbTorqueUnits_Click()
    MyCalibration.TorqueUnits = cmbTorqueUnits.Text
End Sub

'Tool Transforms
Private Sub btnAdd_Click()
    Dim TTForm As New frmToolTransform
    TTForm.cmbAxis.Text = "Dx"
    TTForm.txtValue.Text = 0
    TTForm.cmbUnits.Text = "in"
    
    TTForm.Show vbModal
    If Not TTForm.Cancelled Then
        MyCalibration.ToolTransforms.Add TTForm.cmbAxis.Text, TTForm.txtValue, TTForm.cmbUnits.Text
    End If
    Unload TTForm
    Set TTForm = Nothing
    RefreshTTs
End Sub
Private Sub btnEdit_Click()
    Dim TTForm As New frmToolTransform
    If lstTransforms.ListIndex = -1 Then Exit Sub   'no selection made
    With MyCalibration.ToolTransforms(lstTransforms.ListIndex + 1)
        TTForm.cmbAxis.Text = .Axis
        TTForm.txtValue.Text = .Value
        TTForm.cmbUnits.Text = .units
    End With
    TTForm.Show vbModal
    If Not TTForm.Cancelled Then
        With MyCalibration.ToolTransforms(lstTransforms.ListIndex + 1)
            .Axis = TTForm.cmbAxis.Text
            .Value = TTForm.txtValue.Text
            .units = TTForm.cmbUnits.Text
        End With
    End If
    Unload TTForm
    Set TTForm = Nothing
    RefreshTTs
End Sub
Private Sub btnRemove_Click()
    If lstTransforms.ListIndex = -1 Then Exit Sub   'no selection made
    MyCalibration.ToolTransforms.Remove lstTransforms.ListIndex + 1
    RefreshTTs
End Sub
Private Sub btnRemoveAll_Click()
    MyCalibration.ToolTransforms.RemoveAll
    RefreshTTs
End Sub
Private Sub RefreshTTs()
    RemoveAll lstTransforms
    Dim TT As ToolTransform
    For Each TT In MyCalibration.ToolTransforms
        lstTransforms.AddItem TT.Axis & ": " & TT.Value & " " & TT.units
    Next TT
    RefreshTTButtons
End Sub
Private Sub lstTransforms_Click()
    RefreshTTButtons
End Sub
Private Sub RefreshTTButtons()
'the Edit and Remove buttons are only enabled when a transform is selected
    btnRemoveAll.Enabled = MyCalibration.ToolTransforms.Count > 0
    If lstTransforms.SelCount < 1 Then
        btnEdit.Enabled = False
        btnRemove.Enabled = False
    Else
        btnEdit.Enabled = True
        btnRemove.Enabled = True
    End If
End Sub
