Attribute VB_Name = "NIDAQCNS"
Option Explicit
'*********************************************************************'
'*                                                                   *'
'* This file contains definitions for constants required for some    *'
'* of the NI-DAQ functions.                                          *'
'*                                                                   *'
'* You should use symbols defined here in your programs;  do not     *'
'* use the numerical values.                                         *'
'*                                                                   *'
'* See your NI-DAQ Function Reference Manual for details concerning  *'
'* use of constants defined here.                                    *'
'*                                                                   *'
'*********************************************************************'
Global Const ND_ABOVE_HIGH_LEVEL& = 11020
Global Const ND_AC& = 11025
Global Const ND_ACK_REQ_EXCHANGE_GR1& = 11030
Global Const ND_ACK_REQ_EXCHANGE_GR2& = 11035
Global Const ND_ACTIVE& = 11037
Global Const ND_ADC_RESOLUTION& = 11040
Global Const ND_AI_CALDAC_COUNT& = 11050
Global Const ND_AI_CHANNEL_COUNT& = 11060
Global Const ND_AI_COUPLING& = 11055
Global Const ND_AI_FIFO_INTERRUPTS& = 11600
Global Const ND_ANALOG_FILTER& = 11065
Global Const ND_AO48XDC_SET_POWERUP_STATE& = 42100
Global Const ND_AO_CALDAC_COUNT& = 11070
Global Const ND_AO_CHANNEL_COUNT& = 11080
Global Const ND_AO_EXT_REF_CAPABLE& = 11090
Global Const ND_AO_UNIPOLAR_CAPABLE& = 11095
Global Const ND_ARM& = 11100
Global Const ND_ARMED& = 11200
Global Const ND_ATC_OUT& = 11250
Global Const ND_ATTENUATION& = 11260
Global Const ND_AUTOINCREMENT_COUNT& = 11300
Global Const ND_AUTOMATIC& = 11400
Global Const ND_AVAILABLE_POINTS& = 11500

Global Const ND_BASE_ADDRESS& = 12100
Global Const ND_BELOW_LOW_LEVEL& = 12130
Global Const ND_BOARD_CLOCK& = 12170
Global Const ND_BUFFERED_EVENT_CNT& = 12200
Global Const ND_BUFFERED_PERIOD_MSR& = 12300
Global Const ND_BUFFERED_PULSE_WIDTH_MSR& = 12400
Global Const ND_BUFFERED_SEMI_PERIOD_MSR& = 12500
Global Const ND_BURST& = 12600
Global Const ND_BURST_INTERVAL& = 12700

Global Const ND_CAL_CONST_AUTO_LOAD& = 13050
Global Const ND_CALIBRATION_ENABLE& = 13055
Global Const ND_CALIBRATION_FRAME_SIZE& = 13060
Global Const ND_CALIBRATION_FRAME_PTR& = 13065
Global Const ND_CJ_TEMP% = &H8000
Global Const ND_CALGND% = &H8001
Global Const ND_CLEAN_UP& = 13100
Global Const ND_CLOCK_REVERSE_MODE_GR1& = 13120
Global Const ND_CLOCK_REVERSE_MODE_GR2& = 13130
Global Const ND_CONFIG_MEMORY_SIZE& = 13150
Global Const ND_CONTINUOUS& = 13160
Global Const ND_COUNT& = 13200

Global Const ND_COUNTER_0& = 13300
Global Const ND_COUNTER_1& = 13400
Global Const ND_COUNTER_2& = 13310
Global Const ND_COUNTER_3& = 13320
Global Const ND_COUNTER_4& = 13330
Global Const ND_COUNTER_5& = 13340
Global Const ND_COUNTER_6& = 13350
Global Const ND_COUNTER_7& = 13360

Global Const ND_COUNTER_1_SOURCE& = 13430
Global Const ND_COUNT_AVAILABLE& = 13450
Global Const ND_COUNT_DOWN& = 13465
Global Const ND_COUNT_UP& = 13485
Global Const ND_COUNT_1& = 13500
Global Const ND_COUNT_2& = 13600
Global Const ND_COUNT_3& = 13700
Global Const ND_COUNT_4& = 13800
Global Const ND_CURRENT_OUTPUT& = 40200

Global Const ND_DAC_RESOLUTION& = 13950
Global Const ND_DATA_TRANSFER_CONDITION& = 13960
Global Const ND_DATA_XFER_MODE_AI& = 14000
Global Const ND_DATA_XFER_MODE_AO_GR1& = 14100
Global Const ND_DATA_XFER_MODE_AO_GR2& = 14200
Global Const ND_DATA_XFER_MODE_DIO_GR1& = 14300
Global Const ND_DATA_XFER_MODE_DIO_GR2& = 14400
Global Const ND_DATA_XFER_MODE_DIO_GR3& = 14500
Global Const ND_DATA_XFER_MODE_DIO_GR4& = 14600
Global Const ND_DATA_XFER_MODE_DIO_GR5& = 14700
Global Const ND_DATA_XFER_MODE_DIO_GR6& = 14800
Global Const ND_DATA_XFER_MODE_DIO_GR7& = 14900
Global Const ND_DATA_XFER_MODE_DIO_GR8& = 15000

Global Const ND_DATA_XFER_MODE_GPCTR0& = 15100
Global Const ND_DATA_XFER_MODE_GPCTR1& = 15200
Global Const ND_DATA_XFER_MODE_GPCTR2& = 15110
Global Const ND_DATA_XFER_MODE_GPCTR3& = 15120
Global Const ND_DATA_XFER_MODE_GPCTR4& = 15130
Global Const ND_DATA_XFER_MODE_GPCTR5& = 15140
Global Const ND_DATA_XFER_MODE_GPCTR6& = 15150
Global Const ND_DATA_XFER_MODE_GPCTR7& = 15160
Global Const ND_DATA_XFER_MODE_GPCTR8& = 15165
Global Const ND_DATA_XFER_MODE_GPCTR9& = 15170
Global Const ND_DATA_XFER_MODE_GPCTR10& = 15175
Global Const ND_DATA_XFER_MODE_GPCTR11& = 15180

Global Const ND_DC& = 15250
Global Const ND_DDS_BUFFER_SIZE& = 15255
Global Const ND_DEVICE_NAME& = 15260
Global Const ND_DEVICE_POWER& = 15270
Global Const ND_DEVICE_SERIAL_NUMBER& = 15280
Global Const ND_DEVICE_STATE_DURING_SUSPEND_MODE& = 15290
Global Const ND_DEVICE_TYPE_CODE& = 15300
Global Const ND_DIGITAL_FILTER& = 15350
Global Const ND_DIGITAL_RESTART& = 15375
Global Const ND_DIO128_GET_PORT_THRESHOLD& = 41200
Global Const ND_DIO128_SELECT_INPUT_PORT& = 41100
Global Const ND_DIO128_SET_PORT_THRESHOLD& = 41300
Global Const ND_DISABLED& = 15400
Global Const ND_DISARM& = 15450
Global Const ND_DIVIDE_DOWN_SAMPLING_SUPPORTED& = 15475
Global Const ND_DMA_A_LEVEL& = 15500
Global Const ND_DMA_B_LEVEL& = 15600
Global Const ND_DMA_C_LEVEL& = 15700
Global Const ND_DONE& = 15800
Global Const ND_DONT_CARE& = 15900
Global Const ND_DONT_KNOW& = 15950

Global Const ND_EDGE_SENSITIVE& = 16000
Global Const ND_ENABLED& = 16050
Global Const ND_END& = 16055
Global Const ND_EXTERNAL& = 16060
Global Const ND_EXTERNAL_CALIBRATE& = 16100

Global Const ND_FACTORY_CALIBRATION_EQUIP& = 16210
Global Const ND_FACTORY_EEPROM_AREA& = 16220
Global Const ND_FIFO_EMPTY& = 16230
Global Const ND_FIFO_HALF_FULL_OR_LESS& = 16240
Global Const ND_FIFO_HALF_FULL_OR_LESS_UNTIL_FULL& = 16245
Global Const ND_FIFO_NOT_FULL& = 16250
Global Const ND_FIFO_TRANSFER_COUNT& = 16260
Global Const ND_FILTER_CORRECTION_FREQ& = 16300
Global Const ND_FOREGROUND& = 16350
Global Const ND_FREQ_OUT& = 16400
Global Const ND_FSK& = 16500
Global Const ND_EDGE_BASED_FSK& = 16500

Global Const ND_GATE& = 17100
Global Const ND_GATE_POLARITY& = 17200

Global Const ND_GPCTR0_GATE& = 17300
Global Const ND_GPCTR0_OUTPUT& = 17400
Global Const ND_GPCTR0_SOURCE& = 17500

Global Const ND_GPCTR1_GATE& = 17600
Global Const ND_GPCTR1_OUTPUT& = 17700
Global Const ND_GPCTR1_SOURCE& = 17800

Global Const ND_GPCTR2_GATE& = 17320
Global Const ND_GPCTR2_OUTPUT& = 17420
Global Const ND_GPCTR2_SOURCE& = 17520

Global Const ND_GPCTR3_GATE& = 17330
Global Const ND_GPCTR3_OUTPUT& = 17430
Global Const ND_GPCTR3_SOURCE& = 17530

Global Const ND_GPCTR4_GATE& = 17340
Global Const ND_GPCTR4_OUTPUT& = 17440
Global Const ND_GPCTR4_SOURCE& = 17540

Global Const ND_GPCTR5_GATE& = 17350
Global Const ND_GPCTR5_OUTPUT& = 17450
Global Const ND_GPCTR5_SOURCE& = 17550

Global Const ND_GPCTR6_GATE& = 17360
Global Const ND_GPCTR6_OUTPUT& = 17460
Global Const ND_GPCTR6_SOURCE& = 17660

Global Const ND_GPCTR7_GATE& = 17370
Global Const ND_GPCTR7_OUTPUT& = 17470
Global Const ND_GPCTR7_SOURCE& = 17570





Global Const ND_GROUND_DAC_REFERENCE& = 17900

Global Const ND_HARDWARE& = 18000
Global Const ND_HI_RES_SAMPLING& = 18020
Global Const ND_HIGH& = 18050
Global Const ND_HIGH_HYSTERESIS& = 18080
Global Const ND_HIGH_TO_LOW& = 18100
Global Const ND_HW_ANALOG_TRIGGER& = 18900

Global Const ND_IMPEDANCE& = 19000
Global Const ND_INACTIVE& = 19010
Global Const ND_INITIAL_COUNT& = 19100
Global Const ND_INIT_PLUGPLAY_DEVICES& = 19110
Global Const ND_INSIDE_REGION& = 19150
Global Const ND_INTERNAL& = 19160
Global Const ND_INTERNAL_100_KHZ& = 19200
Global Const ND_INTERNAL_10_MHZ& = 19300
Global Const ND_INTERNAL_1250_KHZ& = 19320
Global Const ND_INTERNAL_20_MHZ& = 19400
Global Const ND_INTERNAL_25_MHZ& = 19410
Global Const ND_INTERNAL_2500_KHZ& = 19420
Global Const ND_INTERNAL_5_MHZ& = 19450
Global Const ND_INTERNAL_7160_KHZ& = 19460
Global Const ND_INTERNAL_TIMER& = 19500
Global Const ND_INTERRUPTS& = 19600
Global Const ND_INTERRUPT_A_LEVEL& = 19700
Global Const ND_INTERRUPT_B_LEVEL& = 19800
Global Const ND_INTERRUPT_TRIGGER_MODE& = 19850
Global Const ND_IN_CHANNEL_CLOCK_TIMEBASE& = 19900
Global Const ND_IN_CHANNEL_CLOCK_TB_POL& = 20000
Global Const ND_IN_CONVERT& = 20100
Global Const ND_IN_CONVERT_POL& = 20200
Global Const ND_IN_DATA_FIFO_SIZE& = 20250
Global Const ND_IN_EXTERNAL_GATE& = 20300
Global Const ND_IN_EXTERNAL_GATE_POL& = 20400
Global Const ND_IN_SCAN_CLOCK_TIMEBASE& = 20500
Global Const ND_IN_SCAN_CLOCK_TB_POL& = 20600
Global Const ND_IN_SCAN_IN_PROG& = 20650
Global Const ND_IN_SCAN_START& = 20700
Global Const ND_IN_SCAN_START_POL& = 20800
Global Const ND_IN_START_TRIGGER& = 20900
Global Const ND_IN_START_TRIGGER_POL& = 21000
Global Const ND_IN_STOP_TRIGGER& = 21100
Global Const ND_IN_STOP_TRIGGER_POL& = 21200
Global Const ND_INT_AI_GND& = 21210
Global Const ND_INT_AO_CH_0& = 21230
Global Const ND_INT_AO_CH_0_VS_REF_5V& = 21235
Global Const ND_INT_AO_CH_1& = 21240
Global Const ND_INT_AO_CH_1_VS_AO_CH_0& = 21245
Global Const ND_INT_AO_CH_1_VS_REF_5V& = 21250
Global Const ND_INT_AO_CH_2& = 21220
Global Const ND_INT_AO_CH_3& = 21221
Global Const ND_INT_AO_CH_4& = 21222
Global Const ND_INT_AO_CH_5& = 21223
Global Const ND_INT_AO_CH_6& = 21224
Global Const ND_INT_AO_CH_7& = 21225
Global Const ND_INT_AO_GND& = 21260
Global Const ND_INT_AO_GND_VS_AI_GND& = 21265
Global Const ND_INT_CM_REF_5V& = 21270
Global Const ND_INT_DEV_TEMP& = 21280
Global Const ND_INT_REF_5V& = 21290
Global Const ND_INT_REF_EXTERN& = 21296
Global Const ND_INT_CAL_BUS& = 21295
Global Const ND_INT_MUX_BUS& = 21305

Global Const ND_INT_AI_GND_AMP_0& = 21211
Global Const ND_INT_AI_GND_AMP_1& = 21212
Global Const ND_INT_AI_GND_AMP_2& = 21213
Global Const ND_INT_AI_GND_AMP_3& = 21214
Global Const ND_INT_AO_CH_0_AMP_0& = 21231
Global Const ND_INT_AO_CH_0_AMP_1& = 21232
Global Const ND_INT_AO_CH_0_AMP_2& = 21233
Global Const ND_INT_AO_CH_0_AMP_3& = 21234
Global Const ND_INT_AO_CH_1_AMP_0& = 21241
Global Const ND_INT_AO_CH_1_AMP_1& = 21242
Global Const ND_INT_AO_CH_1_AMP_2& = 21243
Global Const ND_INT_AO_CH_1_AMP_3& = 21244
Global Const ND_INT_AO_CH_0_VS_REF_AMP_0& = 21236
Global Const ND_INT_AO_CH_0_VS_REF_AMP_1& = 21237
Global Const ND_INT_AO_CH_0_VS_REF_AMP_2& = 21238
Global Const ND_INT_AO_CH_0_VS_REF_AMP_3& = 21239
Global Const ND_INT_AO_CH_1_VS_REF_AMP_0& = 21251
Global Const ND_INT_AO_CH_1_VS_REF_AMP_1& = 21252
Global Const ND_INT_AO_CH_1_VS_REF_AMP_2& = 21253
Global Const ND_INT_AO_CH_1_VS_REF_AMP_3& = 21254
Global Const ND_INT_AO_GND_VS_AI_GND_AMP_0& = 21266
Global Const ND_INT_AO_GND_VS_AI_GND_AMP_1& = 21267
Global Const ND_INT_AO_GND_VS_AI_GND_AMP_2& = 21268
Global Const ND_INT_AO_GND_VS_AI_GND_AMP_3& = 21269
Global Const ND_INT_CM_REF_AMP_0& = 21271
Global Const ND_INT_CM_REF_AMP_1& = 21272
Global Const ND_INT_CM_REF_AMP_2& = 21273
Global Const ND_INT_CM_REF_AMP_3& = 21274
Global Const ND_INT_REF_AMP_0& = 21291
Global Const ND_INT_REF_AMP_1& = 21292
Global Const ND_INT_REF_AMP_2& = 21293
Global Const ND_INT_REF_AMP_3& = 21294

Global Const ND_INTERRUPT_EVERY_SAMPLE& = 11700
Global Const ND_INTERRUPT_HALF_FIFO& = 11800
Global Const ND_IO_CONNECTOR& = 21300

Global Const ND_LEVEL_SENSITIVE& = 24000
Global Const ND_LINK_COMPLETE_INTERRUPTS& = 24010
Global Const ND_LOW& = 24050
Global Const ND_LOW_HYSTERESIS& = 24080
Global Const ND_LOW_TO_HIGH& = 24100
Global Const ND_LPT_DEVICE_MODE& = 24200

Global Const ND_MARKER& = 24500
Global Const ND_MARKER_QUANTUM& = 24550
Global Const ND_MAX_ARB_SEQUENCE_LENGTH& = 24600
Global Const ND_MAX_FUNC_SEQUENCE_LENGTH& = 24610
Global Const ND_MAX_LOOP_COUNT& = 24620
Global Const ND_MAX_NUM_WAVEFORMS& = 24630
Global Const ND_MAX_SAMPLE_RATE& = 24640
Global Const ND_MAX_WFM_SIZE& = 24650
Global Const ND_MEMORY_TRANSFER_WIDTH& = 24700
Global Const ND_MIN_SAMPLE_RATE& = 24800
Global Const ND_MIN_WFM_SIZE& = 24810

Global Const ND_NEGATIVE& = 26100
Global Const ND_NEW& = 26190
Global Const ND_NI_DAQ_SW_AREA& = 26195
Global Const ND_NO& = 26200
Global Const ND_NO_STRAIN_GAUGE& = 26225
Global Const ND_NO_TRACK_AND_HOLD& = 26250
Global Const ND_NONE& = 26300
Global Const ND_NOT_APPLICABLE& = 26400
Global Const ND_NUMBER_DIG_PORTS& = 26500

Global Const ND_OFF& = 27010
Global Const ND_OFFSET& = 27020
Global Const ND_ON& = 27050
Global Const ND_OTHER& = 27060
Global Const ND_OTHER_GPCTR_OUTPUT& = 27300
Global Const ND_OTHER_GPCTR_TC& = 27400
Global Const ND_OUT_DATA_FIFO_SIZE& = 27070
Global Const ND_OUT_EXTERNAL_GATE& = 27080
Global Const ND_OUT_EXTERNAL_GATE_POL& = 27082
Global Const ND_OUT_START_TRIGGER& = 27100
Global Const ND_OUT_START_TRIGGER_POL& = 27102
Global Const ND_OUT_UPDATE& = 27200
Global Const ND_OUT_UPDATE_POL& = 27202
Global Const ND_OUT_UPDATE_CLOCK_TIMEBASE& = 27210
Global Const ND_OUT_UPDATE_CLOCK_TB_POL& = 27212
Global Const ND_OUTPUT_ENABLE& = 27220
Global Const ND_OUTPUT_MODE& = 27230
Global Const ND_OUTPUT_POLARITY& = 27240
Global Const ND_OUTPUT_STATE& = 27250
Global Const ND_OUTPUT_TYPE& = 40000

Global Const ND_DIGITAL_PATTERN_GENERATION& = 28030
Global Const ND_PAUSE& = 28040
Global Const ND_PAUSE_ON_HIGH& = 28045
Global Const ND_PAUSE_ON_LOW& = 28050
Global Const ND_PFI_0& = 28100
Global Const ND_PFI_1& = 28200
Global Const ND_PFI_2& = 28300
Global Const ND_PFI_3& = 28400
Global Const ND_PFI_4& = 28500
Global Const ND_PFI_5& = 28600
Global Const ND_PFI_6& = 28700
Global Const ND_PFI_7& = 28800
Global Const ND_PFI_8& = 28900
Global Const ND_PFI_9& = 29000
Global Const ND_PFI_10& = 50280
Global Const ND_PFI_11& = 50290
Global Const ND_PFI_12& = 50300
Global Const ND_PFI_13& = 50310
Global Const ND_PFI_14& = 50320
Global Const ND_PFI_15& = 50330
Global Const ND_PFI_16& = 50340
Global Const ND_PFI_17& = 50350
Global Const ND_PFI_18& = 50360
Global Const ND_PFI_19& = 50370
Global Const ND_PFI_20& = 50380
Global Const ND_PFI_21& = 50390
Global Const ND_PFI_22& = 50400
Global Const ND_PFI_23& = 50410
Global Const ND_PFI_24& = 50420
Global Const ND_PFI_25& = 50430
Global Const ND_PFI_26& = 50440
Global Const ND_PFI_27& = 50450
Global Const ND_PFI_28& = 50460
Global Const ND_PFI_29& = 50470
Global Const ND_PFI_30& = 50480
Global Const ND_PFI_31& = 50490
Global Const ND_PFI_32& = 50500
Global Const ND_PFI_33& = 50510
Global Const ND_PFI_34& = 50520
Global Const ND_PFI_35& = 50530
Global Const ND_PFI_36& = 50540
Global Const ND_PFI_37& = 50550
Global Const ND_PFI_38& = 50560
Global Const ND_PFI_39& = 50570

Global Const ND_PLL_REF_FREQ& = 29010
Global Const ND_PLL_REF_SOURCE& = 29020
Global Const ND_PRE_ARM& = 29050
Global Const ND_POSITIVE& = 29100
Global Const ND_PREPARE& = 29200
Global Const ND_PROGRAM& = 29300
Global Const ND_PULSE& = 29350
Global Const ND_PULSE_SOURCE& = 29500
Global Const ND_PULSE_TRAIN_GNR& = 29600
Global Const ND_PXI_BACKPLANE_CLOCK& = 29900

Global Const ND_REGLITCH& = 31000
Global Const ND_RESERVED& = 31100
Global Const ND_RESET& = 31200
Global Const ND_RESUME& = 31250
Global Const ND_RETRIG_PULSE_GNR& = 31300
Global Const ND_REVISION& = 31350
Global Const ND_RTSI_0& = 31400
Global Const ND_RTSI_1& = 31500
Global Const ND_RTSI_2& = 31600
Global Const ND_RTSI_3& = 31700
Global Const ND_RTSI_4& = 31800
Global Const ND_RTSI_5& = 31900
Global Const ND_RTSI_6& = 32000
Global Const ND_RTSI_CLOCK& = 32100

Global Const ND_SCANCLK& = 32400
Global Const ND_SCANCLK_LINE& = 32420
Global Const ND_SC_2040_MODE& = 32500
Global Const ND_SC_2043_MODE& = 32600
Global Const ND_SELF_CALIBRATE& = 32700
Global Const ND_SET_DEFAULT_LOAD_AREA& = 32800
Global Const ND_RESTORE_FACTORY_CALIBRATION& = 32810
Global Const ND_SET_POWERUP_STATE& = 42100
Global Const ND_SIMPLE_EVENT_CNT& = 33100
Global Const ND_SINGLE& = 33150
Global Const ND_SINGLE_PERIOD_MSR& = 33200
Global Const ND_SINGLE_PULSE_GNR& = 33300
Global Const ND_SINGLE_PULSE_WIDTH_MSR& = 33400
Global Const ND_SINGLE_TRIG_PULSE_GNR& = 33500
Global Const ND_SOURCE& = 33700
Global Const ND_SOURCE_POLARITY& = 33800
Global Const ND_STABLE_10_MHZ& = 33810
Global Const ND_STEPPED& = 33825
Global Const ND_STRAIN_GAUGE& = 33850
Global Const ND_STRAIN_GAUGE_EX0& = 33875
Global Const ND_SUB_REVISION& = 33900
Global Const ND_SYNC_DUTY_CYCLE_HIGH& = 33930
Global Const ND_SYNC_OUT& = 33970

Global Const ND_TC_REACHED& = 34100
Global Const ND_THE_AI_CHANNEL& = 34400
Global Const ND_TOGGLE& = 34700
Global Const ND_TOGGLE_GATE& = 34800
Global Const ND_TRACK_AND_HOLD& = 34850
Global Const ND_TRIG_PULSE_WIDTH_MSR& = 34900
Global Const ND_TRIGGER_SOURCE& = 34930
Global Const ND_TRIGGER_MODE& = 34970

Global Const ND_UI2_TC& = 35100
Global Const ND_UP_DOWN& = 35150
Global Const ND_UP_TO_1_DMA_CHANNEL& = 35200
Global Const ND_UP_TO_2_DMA_CHANNELS& = 35300
Global Const ND_USE_CAL_CHAN& = 36000
Global Const ND_USE_AUX_CHAN& = 36100
Global Const ND_USER_EEPROM_AREA& = 37000
Global Const ND_USER_EEPROM_AREA_2& = 37010
Global Const ND_USER_EEPROM_AREA_3& = 37020
Global Const ND_USER_EEPROM_AREA_4& = 37030
Global Const ND_USER_EEPROM_AREA_5& = 37040

Global Const ND_DSA_RTSI_CLOCK_AD& = 44000
Global Const ND_DSA_RTSI_CLOCK_DA& = 44010
Global Const ND_DSA_OUTPUT_TRIGGER& = 44020
Global Const ND_DSA_INPUT_TRIGGER& = 44030
Global Const ND_DSA_SHARC_TRIGGER& = 44040
Global Const ND_DSA_ANALOG_TRIGGER& = 44050
Global Const ND_DSA_HOST_TRIGGER& = 44060
Global Const ND_DSA_EXTERNAL_DIGITAL_TRIGGER& = 44070

Global Const ND_VOLTAGE_OUTPUT& = 40100
Global Const ND_VOLTAGE_REFERENCE& = 38000

Global Const ND_VXI_SC% = &H2000
Global Const ND_PXI_SC% = &H2010
Global Const ND_VXIMIO_SET_ALLOCATE_MODE& = 43100
Global Const ND_VXIMIO_USE_ONBOARD_MEMORY_AI& = 43500
Global Const ND_VXIMIO_USE_ONBOARD_MEMORY_AO& = 43600
Global Const ND_VXIMIO_USE_ONBOARD_MEMORY_GPCTR& = 43700
Global Const ND_VXIMIO_USE_PC_MEMORY_AI& = 43200
Global Const ND_VXIMIO_USE_PC_MEMORY_AO& = 43300
Global Const ND_VXIMIO_USE_PC_MEMORY_GPCTR& = 43400

Global Const ND_WFM_QUANTUM& = 45000

Global Const ND_YES& = 39100
Global Const ND_3V_LEVEL& = 43450

Global Const ND_WRITE_MARK& = 50000
Global Const ND_READ_MARK& = 50010
Global Const ND_BUFFER_START& = 50020
Global Const ND_TRIGGER_POINT& = 50025
Global Const ND_BUFFER_MODE& = 50030
Global Const ND_DOUBLE& = 50050
Global Const ND_QUADRATURE_ENCODER_X1& = 50070
Global Const ND_QUADRATURE_ENCODER_X2& = 50080
Global Const ND_QUADRATURE_ENCODER_X4& = 50090
Global Const ND_TWO_PULSE_COUNTING& = 50100
Global Const ND_LINE_FILTER& = 50110
Global Const ND_SYNCHRONIZATION& = 50120
Global Const ND_5_MICROSECONDS& = 50130
Global Const ND_1_MICROSECOND& = 50140
Global Const ND_500_NANOSECONDS& = 50150
Global Const ND_100_NANOSECONDS& = 50160
Global Const ND_1_MILLISECOND& = 50170
Global Const ND_10_MILLISECONDS& = 50180
Global Const ND_100_MILLISECONDS& = 50190


Global Const ND_OTHER_GPCTR_SOURCE& = 50580
Global Const ND_OTHER_GPCTR_GATE& = 50590
Global Const ND_AUX_LINE& = 50600
Global Const ND_AUX_LINE_POLARITY& = 50610
Global Const ND_TWO_SIGNAL_EDGE_SEPARATION_MSR& = 50630
Global Const ND_BUFFERED_TWO_SIGNAL_EDGE_SEPARATION_MSR& = 50640
Global Const ND_SWITCH_CYCLE& = 50650
Global Const ND_INTERNAL_MAX_TIMEBASE& = 50660
Global Const ND_PRESCALE_VALUE& = 50670
Global Const ND_MAX_PRESCALE& = 50690
Global Const ND_INTERNAL_LINE_0& = 50710
Global Const ND_INTERNAL_LINE_1& = 50720
Global Const ND_INTERNAL_LINE_2& = 50730
Global Const ND_INTERNAL_LINE_3& = 50740
Global Const ND_INTERNAL_LINE_4& = 50750
Global Const ND_INTERNAL_LINE_5& = 50760
Global Const ND_INTERNAL_LINE_6& = 50770
Global Const ND_INTERNAL_LINE_7& = 50780
Global Const ND_INTERNAL_LINE_8& = 50790
Global Const ND_INTERNAL_LINE_9& = 50800
Global Const ND_INTERNAL_LINE_10& = 50810
Global Const ND_INTERNAL_LINE_11& = 50820
Global Const ND_INTERNAL_LINE_12& = 50830
Global Const ND_INTERNAL_LINE_13& = 50840
Global Const ND_INTERNAL_LINE_14& = 50850
Global Const ND_INTERNAL_LINE_15& = 50860
Global Const ND_INTERNAL_LINE_16& = 50862
Global Const ND_INTERNAL_LINE_17& = 50864
Global Const ND_INTERNAL_LINE_18& = 50866
Global Const ND_INTERNAL_LINE_19& = 50868
Global Const ND_INTERNAL_LINE_20& = 50870
Global Const ND_INTERNAL_LINE_21& = 50872
Global Const ND_INTERNAL_LINE_22& = 50874
Global Const ND_INTERNAL_LINE_23& = 50876





Global Const ND_START_TRIGGER& = 51150
Global Const ND_START_TRIGGER_POLARITY& = 51151



Global Const ND_COUNTING_SYNCHRONOUS& = 51200
Global Const ND_SYNCHRONOUS& = 51210
Global Const ND_ASYNCHRONOUS& = 51220
Global Const ND_CONFIGURABLE_FILTER& = 51230
Global Const ND_ENCODER_TYPE& = 51240
Global Const ND_Z_INDEX_ACTIVE& = 51250
Global Const ND_Z_INDEX_VALUE& = 51260
Global Const ND_SNAPSHOT& = 51270
Global Const ND_POSITION_MSR& = 51280
Global Const ND_BUFFERED_POSITION_MSR& = 51290
Global Const ND_SAVED_COUNT& = 51300
Global Const ND_READ_MARK_H_SNAPSHOT& = 51310
Global Const ND_READ_MARK_L_SNAPSHOT& = 51320
Global Const ND_WRITE_MARK_H_SNAPSHOT& = 51330
Global Const ND_WRITE_MARK_L_SNAPSHOT& = 51340
Global Const ND_BACKLOG_H_SNAPSHOT& = 51350
Global Const ND_BACKLOG_L_SNAPSHOT& = 51360
Global Const ND_ARMED_SNAPSHOT& = 51370
Global Const ND_EDGE_GATED_FSK& = 51371
Global Const ND_SIMPLE_GATED_EVENT_CNT& = 51372

Global Const ND_VIDEO_TYPE& = 51380
Global Const ND_PAL_B& = 51390
Global Const ND_PAL_G& = 51400
Global Const ND_PAL_H& = 51410
Global Const ND_PAL_I& = 51420
Global Const ND_PAL_D& = 51430
Global Const ND_PAL_N& = 51440
Global Const ND_PAL_M& = 51450
Global Const ND_NTSC_M& = 51460
Global Const ND_COUNTER_TYPE& = 51470
Global Const ND_NI_TIO& = 51480
Global Const ND_AM9513& = 51490
Global Const ND_STC& = 51500
Global Const ND_8253& = 51510
Global Const ND_A_HIGH_B_HIGH& = 51520
Global Const ND_A_HIGH_B_LOW& = 51530
Global Const ND_A_LOW_B_HIGH& = 51540
Global Const ND_A_LOW_B_LOW& = 51550
Global Const ND_Z_INDEX_RELOAD_PHASE& = 51560
Global Const ND_UPDOWN_LINE& = 51570
Global Const ND_DEFAULT_PFI_LINE& = 51580
Global Const ND_BUFFER_SIZE& = 51590
Global Const ND_ELEMENT_SIZE& = 51600
Global Const ND_NUMBER_GP_COUNTERS& = 51610
Global Const ND_BUFFERED_TIME_STAMPING& = 51620
Global Const ND_TIME_0_DATA_32& = 51630
Global Const ND_TIME_8_DATA_24& = 51640
Global Const ND_TIME_16_DATA_16& = 51650
Global Const ND_TIME_24_DATA_8& = 51660
Global Const ND_TIME_32_DATA_32& = 51670
Global Const ND_TIME_48_DATA_16& = 51680
Global Const ND_ABSOLUTE& = 51690
Global Const ND_RELATIVE& = 51700
Global Const ND_TIME_DATA_SIZE& = 51710
Global Const ND_TIME_FORMAT& = 51720
Global Const ND_HALT_ON_OVERFLOW& = 51730
Global Const ND_OVERLAY_RTSI_ON_PFI_LINES& = 51740
Global Const ND_STOP_TRIGGER& = 51750
Global Const ND_TS_INPUT_MODE& = 51760
Global Const ND_BOTH_EDGES& = 51770

Global Const ND_CLOCK_0& = 51780
Global Const ND_CLOCK_1& = 51790
Global Const ND_CLOCK_2& = 51800
Global Const ND_CLOCK_3& = 51810
Global Const ND_SYNCHRONIZATION_LINE& = 51820
Global Const ND_TRANSFER_METHOD& = 51830
Global Const ND_SECONDS& = 51840
Global Const ND_PRECISION& = 51850
Global Const ND_NANO_SECONDS& = 51860
Global Const ND_SYNCHRONIZATION_METHOD& = 51870
Global Const ND_PULSE_PER_SECOND& = 51880
Global Const ND_IRIG_B& = 51890
Global Const ND_SIMPLE_TIME_MSR& = 51900
Global Const ND_SINGLE_TIME_MSR& = 51910
Global Const ND_BUFFERED_TIME_MSR& = 51920
Global Const ND_DMA& = 51930

