Attribute VB_Name = "NIDAQERR"
Option Explicit
'*********************************************************************'
'* nidaqerr.inc                                                      *'
'*    header file for platform-independent ni-daq errors/warnings    *'
'*                                                                   *'
'* NOTE:                                                             *'
'*    You should use symbols defined here in your programs;  do not  *'
'*    use the numerical values.                                      *'
'*                                                                   *'
'*    Warnings are returned as positive numbers. For example         *'
'*    overWriteError may be returned as a warning and its value      *'
'*    would be -(overWriteError).                                    *'
'*                                                                   *'
'* THIS FILE IS AUTOMATICALLY GENERATED FROM A DATABASE: DO NOT EDIT *'
'*                                                                   *'
'*********************************************************************'

Global Const noError = 0

Global Const syntaxError = -10001                      ' An error was detected in the input string; the arrangement or ordering ...
Global Const semanticsError = -10002                   ' An error was detected in the input string; the syntax of the string is ...
Global Const invalidValueError = -10003                ' The value of a numeric parameter is invalid.
Global Const valueConflictError = -10004               ' The value of a numeric parameter is inconsistent with another one, and ...
Global Const badDeviceError = -10005                   ' The device is invalid.
Global Const badLineError = -10006                     ' The line is invalid.
Global Const badChanError = -10007                     ' A channel, port, or counter is out of range for the device type or device ...
Global Const badGroupError = -10008                    ' The group is invalid.
Global Const badCounterError = -10009                  ' The counter is invalid.
Global Const badCountError = -10010                    ' The count is too small or too large for the specified counter, or the ...
Global Const badIntervalError = -10011                 ' The analog input scan rate is too fast for the number of channels and ...
Global Const badRangeError = -10012                    ' The analog input or analog output voltage or current range is invalid ...
Global Const badErrorCodeError = -10013                ' The driver returned an unrecognized or unlisted error code.
Global Const groupTooLargeError = -10014               ' The group size is too large for the board.
Global Const badTimeLimitError = -10015                ' The time limit is invalid.
Global Const badReadCountError = -10016                ' The read count is invalid.
Global Const badReadModeError = -10017                 ' The read mode is invalid.
Global Const badReadOffsetError = -10018               ' The offset is unreachable.
Global Const badClkFrequencyError = -10019             ' The frequency is invalid.
Global Const badTimebaseError = -10020                 ' The timebase is invalid.
Global Const badLimitsError = -10021                   ' The limits are beyond the range of the board.
Global Const badWriteCountError = -10022               ' Your data array contains an incomplete update, or you are trying to write ...
Global Const badWriteModeError = -10023                ' The write mode is out of range or is disallowed.
Global Const badWriteOffsetError = -10024              ' Adding the write offset to the write mark places the write mark outside ...
Global Const limitsOutOfRangeError = -10025            ' The requested input limits exceed the board's capability or configuration. ...
Global Const badBufferSpecificationError = -10026      ' The requested number of buffers or the buffer size is not allowed. For ...
Global Const badDAQEventError = -10027                 ' For DAQEvents 0 and 1 general value A must be greater than 0 and less ...
Global Const badFilterCutoffError = -10028             ' The cutoff frequency specified is not valid for this device.
Global Const obsoleteFunctionError = -10029            ' The function you are calling is no longer supported in this version of ...
Global Const badBaudRateError = -10030                 ' The specified baud rate for communicating with the serial port is not ...
Global Const badChassisIDError = -10031                ' The specified baud rate for communicating with the serial port is not ...
Global Const badModuleSlotError = -10032               ' The SCXI module slot that was specified is invalid or corresponds to an ...
Global Const invalidWinHandleError = -10033            ' The window handle passed to the function is invalid.
Global Const noSuchMessageError = -10034               ' No configured message matches the one you tried to delete.
Global Const irrelevantAttributeError = -10035         ' The specified attribute is not relevant.
Global Const badYearError = -10036                     ' The specified year is invalid.
Global Const badMonthError = -10037                    ' The specified month is invalid.
Global Const badDayError = -10038                      ' The specified day is invalid.
Global Const stringTooLongError = -10039               ' The specified input string is too long.  For instance, DAQScope 5102 devices ...
Global Const badGroupSizeError = -10040                ' The group size is invalid.
Global Const badTaskIDError = -10041                   ' The specified task ID is invalid. For instance, you may have connected ...
Global Const inappropriateControlCodeError = -10042    ' The specified control code is inappropriate for the current configuration ...
Global Const badDivisorError = -10043                  ' The specified divisor is invalid.
Global Const badPolarityError = -10044                 ' The specified polarity is invalid.
Global Const badInputModeError = -10045                ' The specified input mode is invalid.
Global Const badExcitationError = -10046               ' The excitation value specified is not valid for this device.
Global Const badConnectionTypeError = -10047           ' The excitation value specified is not valid for this device.
Global Const badExcitationTypeError = -10048           ' The excitation type specified is not valid for this device.
Global Const badChanListError = -10050                 ' There is more than one channel name in the channel list that corresponds ...
Global Const badTrigSkipCountError = -10079            ' The trigger skip count is invalid.
Global Const badGainError = -10080                     ' The gain or gain adjust is invalid.
Global Const badPretrigCountError = -10081             ' The pretrigger sample count is invalid.
Global Const badPosttrigCountError = -10082            ' The posttrigger sample count is invalid.
Global Const badTrigModeError = -10083                 ' The trigger mode is invalid.
Global Const badTrigCountError = -10084                ' The trigger count is invalid.
Global Const badTrigRangeError = -10085                ' The trigger range or trigger hysteresis window is invalid.
Global Const badExtRefError = -10086                   ' The external reference  is invalid.
Global Const badTrigTypeError = -10087                 ' The trigger type is invalid.
Global Const badTrigLevelError = -10088                ' The trigger level is invalid.
Global Const badTotalCountError = -10089               ' The total count is inconsistent with the buffer size and pretrigger scan ...
Global Const badRPGError = -10090                      ' The individual range, polarity, and gain settings are valid but the combination ...
Global Const badIterationsError = -10091               ' You have attempted to use an invalid setting for the iterations parameter. ...
Global Const lowScanIntervalError = -10092             ' Some devices require a time gap between the last sample in a scan and ...
Global Const fifoModeError = -10093                    ' FIFO mode waveform generation cannot be used because at least one condition ...
Global Const badCalDACconstError = -10094              ' The calDAC constant passed to the function is invalid.
Global Const badCalStimulusError = -10095              ' The calibration stimulus passed to the function is invalid.
Global Const badCalibrationConstantError = -10096      ' The specified calibration constant is invalid.
Global Const badCalOpError = -10097                    ' The specified calibration operation is invalid.
Global Const badCalConstAreaError = -10098             ' The specified calibration constant area is invalid.  For instance, the ...
Global Const badPortWidthError = -10100                ' The requested digital port width is not a multiple of the hardware port ...
Global Const gpctrBadApplicationError = -10120         ' Invalid application used.
Global Const gpctrBadCtrNumberError = -10121           ' Invalid counterNumber used.
Global Const gpctrBadParamValueError = -10122          ' Invalid paramValue used.
Global Const gpctrBadParamIDError = -10123             ' Invalid paramID used.
Global Const gpctrBadEntityIDError = -10124            ' Invalid entityID used.
Global Const gpctrBadActionError = -10125              ' Invalid action used.
Global Const gpctrSourceSelectError = -10126           ' Invalid source selected.
Global Const badCountDirError = -10127                 ' The specified counter does not support the specified count direction.
Global Const badGateOptionError = -10128               ' The specified gating option is invalid.
Global Const badGateModeError = -10129                 ' The specified gate mode is invalid.
Global Const badGateSourceError = -10130               ' The specified gate source is invalid.
Global Const badGateSignalError = -10131               ' The specified gate signal is invalid.
Global Const badSourceEdgeError = -10132               ' The specified source edge is invalid.
Global Const badOutputTypeError = -10133               ' The specified output type is invalid.
Global Const badOutputPolarityError = -10134           ' The specified output polarity is invalid.
Global Const badPulseModeError = -10135                ' The specified pulse mode is invalid.
Global Const badDutyCycleError = -10136                ' The specified duty cycle is invalid.
Global Const badPulsePeriodError = -10137              ' The specified pulse period is invalid.
Global Const badPulseDelayError = -10138               ' The specified pulse delay is invalid.
Global Const badPulseWidthError = -10139               ' The specified pulse width is invalid.
Global Const badFOUTportError = -10140                 ' The specified frequency output (FOUT or FREQ_OUT) port is invalid.
Global Const badAutoIncrementModeError = -10141        ' The specified autoincrement mode is invalid.
Global Const badNotchFilterError = -10180              ' The specified notch filter is invalid.
Global Const badMeasModeError = -10181                 ' The specified measurement mode is invalid.
Global Const EEPROMreadError = -10200                  ' Unable to read data from EEPROM.
Global Const EEPROMwriteError = -10201                 ' Unable to write data to EEPROM.
Global Const EEPROMwriteProtectionError = -10202       ' You cannot write into this location or area of your EEPROM because it ...
Global Const EEPROMinvalidLocationError = -10203       ' The specified EEPROM location is invalid.
Global Const EEPROMinvalidPasswordError = -10204       ' The password for accessing the EEPROM is incorrect.
Global Const noDriverError = -10240                    ' The driver interface could not locate or open the driver..
Global Const oldDriverError = -10241                   ' One of the driver files or the configuration utility is out of date, or ...
Global Const functionNotFoundError = -10242            ' The specified function is not located in the driver.
Global Const configFileError = -10243                  ' The driver could not locate or open the configuration file, or the format ...
Global Const deviceInitError = -10244                  ' The driver encountered a hardware-initialization error while attempting ...
Global Const osInitError = -10245                      ' The driver encountered an operating-system error while attempting to perform ...
Global Const communicationsError = -10246              ' The driver encountered an operating-system error while attempting to perform ...
Global Const cmosConfigError = -10247                  ' The CMOS configuration-memory for the device is empty or invalid, or the ...
Global Const dupAddressError = -10248                  ' The base addresses for two or more devices are the same; consequently, ...
Global Const intConfigError = -10249                   ' The interrupt configuration is incorrect given the capabilities of the ...
Global Const dupIntError = -10250                      ' The interrupt levels for two or more devices are the same.
Global Const dmaConfigError = -10251                   ' The DMA configuration is incorrect given the capabilities of the computer/DMA ...
Global Const dupDMAError = -10252                      ' The DMA channels for two or more devices are the same.
Global Const jumperlessBoardError = -10253             ' Unable to find one or more jumperless boards you have configured using ...
Global Const DAQCardConfError = -10254                 ' Cannot configure the DAQCard because 1) the correct version of the card ...
Global Const remoteChassisDriverInitError = -10255     ' There was an error in initializing the driver for Remote SCXI.
Global Const comPortOpenError = -10256                 ' There was an error in opening the specified COM port.
Global Const baseAddressError = -10257                 ' Bad base address specified in the configuration utility.
Global Const dmaChannel1Error = -10258                 ' Bad DMA channel 1 specified in the configuration utility or by the operating ...
Global Const dmaChannel2Error = -10259                 ' Bad DMA channel 2 specified in the configuration utility or by the operating ...
Global Const dmaChannel3Error = -10260                 ' Bad DMA channel 3 specified in the configuration utility or by the operating ...
Global Const userModeToKernelModeCallError = -10261    ' The user mode code failed when calling the kernel mode code.
Global Const noConnectError = -10340                   ' No RTSI or PFI signal/line is connected, or the specified signal and the ...
Global Const badConnectError = -10341                  ' The RTSI or PFI signal/line cannot be connected as specified.
Global Const multConnectError = -10342                 ' The specified RTSI signal is already being driven by a RTSI line, or the ...
Global Const SCXIConfigError = -10343                  ' The specified SCXI configuration parameters are invalid, or the function ...
Global Const chassisSynchedError = -10344              ' The Remote SCXI unit is not synchronized with the host. Reset the chassis ...
Global Const chassisMemAllocError = -10345             ' The required amount of memory cannot be allocated on the Remote SCXI unit ...
Global Const badPacketError = -10346                   ' The packet received by the Remote SCXI unit is invalid.  Check your serial ...
Global Const chassisCommunicationError = -10347        ' There was an error in sending a packet to the remote chassis.  Check your ...
Global Const waitingForReprogError = -10348            ' The Remote SCXI unit is in reprogramming mode and is waiting for reprogramming ...
Global Const SCXIModuleTypeConflictError = -10349      ' The module ID read from the SCXI module conflicts with the configured ...
Global Const CannotDetermineEntryModuleError = -10350  ' Neither an SCXI entry module (i.e.: the SCXI module cabled to the measurement ...
Global Const DSPInitError = -10360                     ' The DSP driver was unable to load the kernel for its operating system.
Global Const badScanListError = -10370                 ' The scan list is invalid; for example, you are mixing AMUX-64T channels ...
Global Const invalidSignalSrcError = -10380            ' The specified signal source is invalid for the selected signal name.
Global Const invalidSignalNameError = -10381           ' The specified signal name is invalid.
Global Const invalidSrcSpecError = -10382              ' The specified source specification is invalid for the signal source or ...
Global Const invalidSignalDestError = -10383           ' The specified signal destination is invalid.
Global Const userOwnedRsrcError = -10400               ' The specified resource is owned by the user and cannot be accessed or ...
Global Const unknownDeviceError = -10401               ' The specified device is not a National Instruments product, the driver ...
Global Const deviceNotFoundError = -10402              ' The specified device is not a National Instruments product, the driver ...
Global Const deviceSupportError = -10403               ' The specified device does not support the requested action (the driver ...
Global Const noLineAvailError = -10404                 ' No line is available.
Global Const noChanAvailError = -10405                 ' No channel is available.
Global Const noGroupAvailError = -10406                ' No group is available.
Global Const lineBusyError = -10407                    ' The specified line is in use.
Global Const chanBusyError = -10408                    ' The specified channel is in use.
Global Const groupBusyError = -10409                   ' The specified group is in use.
Global Const relatedLCGBusyError = -10410              ' A related line, channel, or group is in use; if the driver configures ...
Global Const counterBusyError = -10411                 ' The specified counter is in use.
Global Const noGroupAssignError = -10412               ' No group is assigned, or the specified line or channel cannot be assigned ...
Global Const groupAssignError = -10413                 ' A group is already assigned, or the specified line or channel is already ...
Global Const reservedPinError = -10414                 ' The selected signal requires a pin that is reserved and configured only ...
Global Const externalMuxSupportError = -10415          ' This function does not support your DAQ device when an external multiplexer ...
Global Const sysOwnedRsrcError = -10440                ' The specified resource is owned by the driver and cannot be accessed or ...
Global Const memConfigError = -10441                   ' No memory is configured to support the current data-transfer mode, or ...
Global Const memDisabledError = -10442                 ' The specified memory is disabled or is unavailable given the current addressing ...
Global Const memAlignmentError = -10443                ' The transfer buffer is not aligned properly for the current data-transfer ...
Global Const memFullError = -10444                     ' No more system memory is available on the heap, or no more memory is available ...
Global Const memLockError = -10445                     ' The transfer buffer cannot be locked into physical memory. On PC AT machines, ...
Global Const memPageError = -10446                     ' The transfer buffer contains a page break; system resources may require ...
Global Const memPageLockError = -10447                 ' The operating environment is unable to grant a page lock.
Global Const stackMemError = -10448                    ' The operating environment is unable to grant a page lock.
Global Const cacheMemError = -10449                    ' A cache-related error occurred, or caching is not supported in the current ...
Global Const physicalMemError = -10450                 ' A hardware error occurred in physical memory, or no memory is located ...
Global Const virtualMemError = -10451                  ' The driver is unable to make the transfer buffer contiguous in virtual ...
Global Const noIntAvailError = -10452                  ' No interrupt level is available for use.
Global Const intInUseError = -10453                    ' The specified interrupt level is already in use by another device.
Global Const noDMACError = -10454                      ' No DMA controller is available in the system.
Global Const noDMAAvailError = -10455                  ' No DMA channel is available for use.
Global Const DMAInUseError = -10456                    ' The specified DMA channel is already in use by another device.
Global Const badDMAGroupError = -10457                 ' DMA cannot be configured for the specified group because it is too small, ...
Global Const diskFullError = -10458                    ' The storage disk you specified is full.
Global Const DLLInterfaceError = -10459                ' The NI-DAQ DLL could not be called due to an interface error.
Global Const interfaceInteractionError = -10460        ' You have mixed VIs from the DAQ library and the _DAQ compatibility library ...
Global Const resourceReservedError = -10461            ' The specified resource is unavailable because it has already been reserved ...
Global Const resourceNotReservedError = -10462         ' The specified resource is unavailable because it has already been reserved ...
Global Const mdResourceAlreadyReservedError = -10463   ' Another entity has already reserved the requested resource.
Global Const mdResourceReservedError = -10464          ' Another entity has already reserved the requested resource.
Global Const mdResourceNotReservedError = -10465       ' Attempting to lift a reservation off a resouce that previously had no ...
Global Const mdResourceAccessKeyError = -10466         ' The requested operation cannot be performed because the key supplied is ...
Global Const mdResourceNotRegisteredError = -10467     ' The resource requested is not registered with the minidriver.
Global Const muxMemFullError = -10480                  ' The resource requested is not registered with the minidriver.
Global Const bufferNotInterleavedError = -10481        ' You must provide a single buffer of interleaved data, and the channels ...
Global Const SCXIModuleNotSupportedError = -10540      ' You must provide a single buffer of interleaved data, and the channels ...
Global Const TRIG1ResourceConflict = -10541            ' CTRB1 will drive COUTB1, however CTRB1 will also drive TRIG1.  This may ...
Global Const matrixTerminalBlockError = -10542         ' This function requires that no Matrix terminal block is configured with ...
Global Const noMatrixTerminalBlockError = -10543       ' This function requires that some matrix terminal block is configured with ...
Global Const invalidMatrixTerminalBlockError = -10544  ' The type of matrix terminal block configured will not allow proper operation ...
Global Const invalidDSPHandleError = -10560            ' The DSP handle input is not valid .
Global Const DSPDataPathBusyError = -10561             ' Either DAQ or WFM can use a PC memory buffer, but not both at the same ...
Global Const noSetupError = -10600                     ' No setup operation has been performed for the specified resources. Or, ...
Global Const multSetupError = -10601                   ' No setup operation has been performed for the specified resources. Or, ...
Global Const noWriteError = -10602                     ' No output data has been written into the transfer buffer.
Global Const groupWriteError = -10603                  ' The output data associated with a group must be for a single channel or ...
Global Const activeWriteError = -10604                 ' Once data generation has started, only the transfer buffers originally ...
Global Const endWriteError = -10605                    ' No data was written to the transfer buffer because the final data block ...
Global Const notArmedError = -10606                    ' The specified resource is not armed.
Global Const armedError = -10607                       ' The specified resource is already armed.
Global Const noTransferInProgError = -10608            ' No transfer is in progress for the specified resource.
Global Const transferInProgError = -10609              ' A transfer is already in progress for the specified resource, or the operation ...
Global Const transferPauseError = -10610               ' A single output channel in a group may not be paused if the output data ...
Global Const badDirOnSomeLinesError = -10611           ' Some of the lines in the specified channel are not configured for the ...
Global Const badLineDirError = -10612                  ' The specified line does not support the specified transfer direction.
Global Const badChanDirError = -10613                  ' The specified channel does not support the specified transfer direction, ...
Global Const badGroupDirError = -10614                 ' The specified group does not support the specified transfer direction.
Global Const masterClkError = -10615                   ' The clock configuration for the clock master is invalid.
Global Const slaveClkError = -10616                    ' The clock configuration for the clock slave is invalid.
Global Const noClkSrcError = -10617                    ' No source signal has been assigned to the clock resource.
Global Const badClkSrcError = -10618                   ' The specified source signal cannot be assigned to the clock resource.
Global Const multClkSrcError = -10619                  ' A source signal has already been assigned to the clock resource.
Global Const noTrigError = -10620                      ' No trigger signal has been assigned to the trigger resource.
Global Const badTrigError = -10621                     ' No trigger signal has been assigned to the trigger resource.
Global Const preTrigError = -10622                     ' The pretrigger mode is not supported or is not available in the current ...
Global Const postTrigError = -10623                    ' No posttrigger source has been assigned.
Global Const delayTrigError = -10624                   ' The delayed trigger mode is not supported or is not available in the current ...
Global Const masterTrigError = -10625                  ' The trigger configuration for the trigger master is invalid.
Global Const slaveTrigError = -10626                   ' The trigger configuration for the trigger slave is invalid.
Global Const noTrigDrvError = -10627                   ' No signal has been assigned to the trigger resource.
Global Const multTrigDrvError = -10628                 ' A signal has already been assigned to the trigger resource.
Global Const invalidOpModeError = -10629               ' The specified operating mode is invalid, or the resources have not been ...
Global Const invalidReadError = -10630                 ' The parameters specified to read data were invalid in the context of the ...
Global Const noInfiniteModeError = -10631              ' Continuous input or output transfers are not allowed in the current operating ...
Global Const someInputsIgnoredError = -10632           ' Certain inputs were ignored because they are not relevant in the current ...
Global Const invalidRegenModeError = -10633            ' The specified analog output regeneration mode is not allowed for this ...
Global Const noContTransferInProgressError = -10634    ' No continuous (double buffered) transfer is in progress for the specified ...
Global Const invalidSCXIOpModeError = -10635           ' Either the SCXI operating mode specified in a configuration call is invalid, ...
Global Const noContWithSynchError = -10636             ' You cannot start a continuous (double-buffered) operation with a synchronous ...
Global Const bufferAlreadyConfigError = -10637         ' Attempted to configure a buffer after the buffer had already been configured. ...
Global Const badClkDestError = -10638                  ' The clock cannot be assigned to the specified destination.
Global Const rangeBadForMeasModeError = -10670         ' The input range is invalid for the configured measurement mode.
Global Const autozeroModeConflictError = -10671        ' Autozero cannot be enabled for the configured measurement mode.
Global Const badChanGainError = -10680                 ' All channels of this board must have the same gain.
Global Const badChanRangeError = -10681                ' All channels of this board must have the same range.
Global Const badChanPolarityError = -10682             ' All channels of this board must be the same polarity.
Global Const badChanCouplingError = -10683             ' All channels of this board must have the same coupling.
Global Const badChanInputModeError = -10684            ' All channels of this board must have the same input mode.
Global Const clkExceedsBrdsMaxConvRateError = -10685   ' The clock rate exceeds the board's recommended maximum rate.
Global Const scanListInvalidError = -10686             ' A configuration change has invalidated the scan list.
Global Const bufferInvalidError = -10687               ' A configuration change has invalidated the acquisition buffer, or an acquisition ...
Global Const noTrigEnabledError = -10688               ' The number of total scans and pretrigger scans implies that a triggered ...
Global Const digitalTrigBError = -10689                ' Digital trigger B is illegal for the number of total scans and pretrigger ...
Global Const digitalTrigAandBError = -10690            ' This board does not allow digital triggers A and B to be enabled at the ...
Global Const extConvRestrictionError = -10691          ' This board does not allow an external sample clock with an external scan ...
Global Const chanClockDisabledError = -10692           ' This board does not allow an external sample clock with an external scan ...
Global Const extScanClockError = -10693                ' You cannot use an external scan clock when doing a single scan of a single ...
Global Const unsafeSamplingFreqError = -10694          ' The scan rate is above the maximum or below the minimum for the hardware, ...
Global Const DMAnotAllowedError = -10695               ' You have set up an operation that requires the use of interrupts.  DMA ...
Global Const multiRateModeError = -10696               ' Multi-rate scanning cannot be used with the AMUX-64, SCXI, or pretriggered ...
Global Const rateNotSupportedError = -10697            ' Unable to convert your timebase/interval pair to match the actual hardware ...
Global Const timebaseConflictError = -10698            ' You cannot use this combination of scan and sample clock timebases for ...
Global Const polarityConflictError = -10699            ' You cannot use this combination of scan and sample clock source polarities ...
Global Const signalConflictError = -10700              ' You cannot use this combination of scan and convert clock signal sources ...
Global Const noLaterUpdateError = -10701               ' The call had no effect because the specified channel had not been set ...
Global Const prePostTriggerError = -10702              ' Pretriggering and posttriggering cannot be used simultaneously on the ...
Global Const noHandshakeModeError = -10710             ' The specified port has not been configured for handshaking.
Global Const noEventCtrError = -10720                  ' The specified counter is not configured for event-counting operation.
Global Const SCXITrackHoldError = -10740               ' A signal has already been assigned to the SCXI track-and-hold trigger ...
Global Const sc2040InputModeError = -10780             ' When you have an SC2040 attached to your device, all analog input channels ...
Global Const outputTypeMustBeVoltageError = -10781     ' When you have an SC2040 attached to your device, all analog input channels ...
Global Const sc2040HoldModeError = -10782              ' The specified operation cannot be performed with the SC-2040 configured ...
Global Const calConstPolarityConflictError = -10783    ' Calibration constants in the load area have a different polarity from ...
Global Const timeOutError = -10800                     ' The operation could not complete within the time limit.
Global Const calibrationError = -10801                 ' An error occurred during the calibration process.  Possible reasons for ...
Global Const dataNotAvailError = -10802                ' The requested amount of data has not yet been acquired.
Global Const transferStoppedError = -10803             ' The on-going transfer has been stopped.   This is to prevent regeneration ...
Global Const earlyStopError = -10804                   ' The transfer stopped prior to reaching the end of the transfer buffer.
Global Const overRunError = -10805                     ' The clock rate is faster than the hardware can support.  An attempt to ...
Global Const noTrigFoundError = -10806                 ' No trigger value was found in the input transfer buffer.
Global Const earlyTrigError = -10807                   ' The trigger occurred before sufficient pretrigger data was acquired.
Global Const LPTcommunicationError = -10808            ' The trigger occurred before sufficient pretrigger data was acquired.
Global Const gateSignalError = -10809                  ' Attempted to start a pulse width measurement with the pulse in the phase ...
Global Const internalDriverError = -10810              ' An unexpected error occurred inside the driver when performing this given ...
Global Const softwareError = -10840                    ' The contents or the location of the driver file was changed between accesses ...
Global Const firmwareError = -10841                    ' The firmware does not support the specified operation, or the firmware ...
Global Const hardwareError = -10842                    ' The hardware is not responding to the specified operation, or the response ...
Global Const underFlowError = -10843                   ' Because of system and/or bus-bandwidth limitations, the driver could not ...
Global Const underWriteError = -10844                  ' Your application was unable to deliver data to the background generation ...
Global Const overFlowError = -10845                    ' Because of system and/or bus-bandwidth limitations, the driver could not ...
Global Const overWriteError = -10846                   ' Your application was unable to retrieve data from the background acquisition ...
Global Const dmaChainingError = -10847                 ' New buffer information was not available at the time of the DMA chaining ...
Global Const noDMACountAvailError = -10848             ' The driver could not obtain a valid reading from the transfer-count register ...
Global Const OpenFileError = -10849                    ' The configuration file or DSP kernel file could not be opened.
Global Const closeFileError = -10850                   ' Unable to close a file.
Global Const fileSeekError = -10851                    ' Unable to seek within a file.
Global Const readFileError = -10852                    ' Unable to read from a file.
Global Const writeFileError = -10853                   ' Unable to write to a file.
Global Const miscFileError = -10854                    ' An error occurred accessing a file.
Global Const osUnsupportedError = -10855               ' NI-DAQ does not support the current operation on this particular version ...
Global Const osError = -10856                          ' An unexpected error occurred from the operating system while performing ...
Global Const internalKernelError = -10857              ' An unexpected error occurred inside the kernel of the device while performing ...
Global Const hardwareConfigChangedError = -10858       ' The system has reconfigured the device and has invalidated the existing ...
Global Const updateRateChangeError = -10880            ' A change to the update rate is not possible at this time because 1) when ...
Global Const partialTransferCompleteError = -10881     ' You cannot do another transfer after a successful partial transfer.
Global Const daqPollDataLossError = -10882             ' The data collected on the Remote SCXI unit was overwritten before it could ...
Global Const wfmPollDataLossError = -10883             ' New data could not be transferred to the waveform buffer of the Remote ...
Global Const pretrigReorderError = -10884              ' Could not rearrange data after a pretrigger acquisition completed.
Global Const overLoadError = -10885                    ' The input signal exceeded the input range of the ADC.
Global Const gpctrDataLossError = -10920               ' One or more data points may have been lost during buffered GPCTR operations ...
Global Const chassisResponseTimeoutError = -10940      ' No response was received from the Remote SCXI unit within the specified ...
Global Const reprogrammingFailedError = -10941         ' Reprogramming the Remote SCXI unit was unsuccessful. Please try again.
Global Const invalidResetSignatureError = -10942       ' Reprogramming the Remote SCXI unit was unsuccessful. Please try again.
Global Const chassisLockupError = -10943               ' The interrupt service routine on the remote SCXI unit is taking longer ...

'*********************************************************************'
'*
'* Mapping of old errors and warnings to new
'*
'* Warnings
'*
'* dupIOaddrRange                  -(dupAddressError)
'* dupIntLevels                    -(dupIntError)
'* dupDMALevels                    -(dupDMAError)
'* readOutputPort                  -(badChanDirError)
'* calibrationErr                  -(calibrationError)
'* noPreTrigUnwrap                 -(memFullError)
'* relatedPortBusy                 -(relatedLCGBusyError)
'* readOutputLine                  -(badDirOnSomeLinesError)
'* outOnSomeInLines                -(badDirOnSomeLinesError)
'* inOnSomeOutLines                -(badDirOnSomeLinesError)
'* simulOpAcrossChips              -(invalidOpModeError)
'* overWriteBeforeCopy             -(overWriteError)
'* pageBreakinWFbuf                -(memPageError)
'* wrongNumConfigBytes             -(noSetupError)
'* DMAReprogramming                -(memPageError)
'* SCXImoduleTypeConflict          -(SCXIModuleTypeConflictError)
'* notEnoughExtMem                 -(memFullError)
'* inputModeConflict               -(invalidOpModeError)
'* SCXIConfigWarning               -(SCXIConfigError)
'* messageIntervalTooLong          -(badDAQEventError)
'* logicalDeviceWarning            -(badDeviceError)
'* calConstPolarityConflict        -(calConstPolarityConflictError)
'* irqConflict                     -(dupIntError)
'* dmaConflict                     -(dupDMAError)
'* jumperlessBoardWarning          -(jumperlessBoardError)
'* gpctrDataLossWarning            -(gpctrDataLossError)
'*
'*
'* Errors
'*
'* notOurBrdErr                    unknownDeviceError
'* badBrdNumErr                    badDeviceError
'* badGainErr                      badGainError
'* badChanErr                      badChanError
'* noSupportErr                    deviceSupportError
'* badPortErr                      badChanError
'* badOutPortErr                   badChanDirError
'* noLatchModeErr                  noHandshakeModeError
'* noGroupAssign                   noGroupAssignError
'* badInputValErr                  invalidValueError
'* timeOutErr                      timeOutError
'* outOfRangeErr                   badRangeError
'* daqInProgErr                    transferInProgError
'* counterInUseErr                 counterBusyError
'* noDAQErr                        noTransferInProgError
'* overFlowErr                     overFlowError
'* overRunErr                      overRunError
'* badCntErr                       badCountError
'* brdTypeErr                      deviceSupportError
'* noCountOpErr                    noEventCtrError
'* ctrReservedErr                  sysOwnedRsrcError
'* portAssignToGrp                 groupAssignError
'* noPortAssignErr                 noGroupAssignError
'* badGrpDirErr                    badGroupDirError
'* noGrpBlockInProg                noTransferInProgError
'* grpBlockInProg                  transferInProgError
'* setLatchWGrpCall                invalidValueError
'* laterIntUpdateNotSet            noLaterUpdateError
'* wfInProgErr                     transferInProgError
'* noWfLoadErr                     noWriteError
'* noWfInProgErr                   noTransferInProgError
'* badPreTrigCntErr                badPretrigCountError
'* buffNotFullErr                  earlyTrigError
'* prePostTrigErr                  prePostTriggerError
'* extConvErr                      extConvRestrictionError
'* badSigDirErr                    badLineDirError
'* noDbDaqErr                      noContTransferInProgError
'* overWriteErr                    overWriteError
'* memErr                          memFullError
'* noConfigFile                    configFileError
'* badGrpSize                      badGroupError
'* intLevelInUse                   intInUseError
'* DMAChanInUse                    DMAInUseError
'* multSourceInputErr              multConnectError
'* lowScanIntervalErr              lowScanIntervalError
'* noConnectionErr                 noConnectError
'* noPGInProg                      noTransferInProgError
'* PGInProg                        transferInProgError
'* grpRateErr                      counterBusyError
'* extGateErr                      invalidOpModeError
'* openFileErr                     openFileError
'* writeFileErr                    writeFileError
'* noDbWvfmErr                     noTransferInProgError
'* oldDataErr                      transferStoppedError
'* dataNotAvailErr                 dataNotAvailError
'* DMATransferCntNotAvail          noDMACountAvailError
'* noLabScanErr                    noTransferInProgError
'* dbOpErr                         noContWithSynchError
'* DMADisabledErr                  noDMAAvailError
'* invalidConfigErr                cmosConfigError
'* brdIsArmedErr                   armedError
'* clockSourceErr                  multClkSrcError
'* noSetupErr                      noSetupError
'* extConvDrvErr                   multClkSrcError
'* triggerSourceErr                badTrigError
'* noArmErr                        notArmedError
'* intDisabledErr                  noIntAvailError
'* keyNotFoundErr                  configFileError
'* noTrigEnabledErr                preTrigError
'* digPortReserved                 sysOwnedRsrcError
'* RTSIlineInUseErr                sysOwnedRsrcError
'* dacUpdateRTSIinUseErr           sysOwnedRsrcError
'* noRTSIlineAvailErr              noLineAvailError
'* preTrigScansErr                 badPretrigCountError
'* postTrigScansErr                badPosttrigCountError
'* scanRateErr                     badIntervalError
'* invalidGetErr                   invalidReadError
'* calInputOutOfRange              badExtRefError
'* EEPROMaddrErr                   EEPROMreadError
'* EEPROMresponseErr               EEPROMreadError
'* EEPROMreadErr                   EEPROMreadError
'* EEPROMwriteErr                  EEPROMwriteError
'* calResponseErr                  calibrationError
'* calConvergeErr                  calibrationError
'* calDACerr                       calibrationError
'* externalCalRefErr               badExtRefError
'* internalCalRefErr               hardwareError
'* badOutLineErr                   badLineDirError
'* relatedPortAssignToGrpBusy      relatedLCGBusyError
'* dacUpdateErr                    underFlowError
'* muxMemFullErr                   muxMemFullError
'* interlvdDataAlignErr            memAlignmentError
'* cannotAlignBufErr               memAlignmentError
'* cannotLockBufErr                memLockError
'* cannotPageLockErr               memPageLockError
'* invalidChassisIDErr             badChassisIDError
'* invalidModuleSlotErr            badModuleSlotError
'* configFileErr                   configFileError
'* outdatedVDMADErr                oldDriverError
'* ctrRTSINotAvailErr              lineBusyError
'* dacUpdateRTSINotAvailErr        lineBusyError
'* SCXIConfigErr                   SCXIConfigError
'* noDbDigErr                      noTransferInProgError
'* DbDigPartialComplete            transferStoppedError
'* SCXITrackHoldErr                SCXITrackHoldError
'* wvfmGrpAssignErr                groupAssignError
'* chanNotAssignedGrpErr           noGroupAssignError
'* grpLoadErr                      groupWriteError
'* loadAfterStartErr               activeWriteError
'* noUpdateRateErr                 noClkSrcError
'* chanPauseErr                    transferPauseError
'* DSPInitFailure                  DSPInitError
'* DSPDataPathInUse                DSPDataPathBusyError
'* DSPDAQErr                       internalKernelError
'* DSPreserved3                    badErrorCodeError
'* DSPreserved4                    badErrorCodeError
'* DSPreserved5                    badErrorCodeError
'* SCXICommErr                     communicationsError
'* invalidOpModeErr                invalidSCXIOpModeError
'* moduleNotSupported              SCXIModuleNotSupportedError
'* DAQboardNotSupported            deviceSupportError
'* noNIDAQLibErr                   noDriverError
'* noNIDAQFuncErr                  functionNotFoundError
'* incompatibleVISRDErr            oldDriverError
'* port1InLatchedModeErr           relatedLCGBusyError
'* invalidMemRegionErr             memLockError
'* fifoModeErr                     fifoModeError
'* cannotFreeMemErr                memConfigError
'* memNotLockedErr                 memConfigError
'* invalidWinHandleErr             invalidWinHandleError
'* trigEventNotAvailErr            DMANotAllowedError
'* memTypeNotSupportedErr          memConfigError
'* badChanStrErr                   syntaxError
'* parseErr                        syntaxError
'* noSuchMessageErr                noSuchMessageError
'* badChanTypeErr                  badChanError
'* badTrigValErr                   badDAQEventError
'* notOurDSPHandleErr              invalidDSPHandleError
'* NIDAQInternalErr                internalDriverError
'* preTrigReorderErr               pretrigReorderError
'* badCtrErr                       badCounterError
'* invalidCtrErr                   badCounterError
'* timedMsgInUseErr                counterBusyError
'* invDAQModeTimedMsgErr           DMANotAllowedError
'* lptCommunicationErr             LPTcommunicationError
'* multiRateAMUXErr                multiRateModeError
'* multiRatePreTrigErr             multiRateModeError
'* functionNotLinkedErr            internalDriverError
'* scanIntervalTooLongErr          badIntervalError
'* sampleIntervalTooLongErr        badIntervalError
'* updateIntervalTooLongErr        badIntervalError
'* gpctrBadApplicationErr          gpctrBadApplicationError
'* gpctrBadCounterNumberErr        gpctrBadCounterNumberError
'* gpctrBadParamValueErr           gpctrBadParamValueError
'* gpctrBadParamIdErr              gpctrBadParamIdError
'* gpctrBadEntityIdErr             gpctrBadEntityIdError
'* gpctrBadActionErr               gpctrBadActionError
'* gpctrBadGateSignalErr           gateSignalError
'* gpctrNotArmedErr                noSetupError
'* gpctrNotResetErr                counterBusyError
'* gpctrNotProgrammedErr           noSetupError
'* gpctrApplicationNotSetErr       noSetupError
'* gpctrBufferNotConfiguredErr     bufferInvalidError
'* gpctrCantChangeParameterErr     counterBusyError
'* lptProtocolNotSupported         LPTcommunicationError
'* rateNotSupportedErr             rateNotSupportedError
'* timebaseConflictErr             timebaseConflictError
'* polarityConflictErr             polarityConflictError
'* signalConflictErr               signalConflictError
'* baseAddressErr                  baseAddressError
'* interruptLevel1Err              badErrorCodeError
'* interruptLevel2Err              badErrorCodeError
'* dmaChannel1Err                  dmaChannel1Error
'* dmaChannel2Err                  dmaChannel2Error
'* openSCManagerErr                badErrorCodeError
'* openNIDAQServiceErr             badErrorCodeError
'* startNIDAQServiceErr            badErrorCodeError
'* criticalResourceConflictErr     badErrorCodeError
'* jumperlessBoardErr              jumperlessBoardError
'* reservedPinErr                  reservedPinError
'* bufferNotInterleavedErr         bufferNotInterleavedError
'* gpctrInUseErr                   counterBusyError
'* gpctrDataLossErr                gpctrDataLossError
'* updateRateChangeErr             updateRateChangeError
'* gpctrBufferConfiguredErr        bufferAlreadyConfigError
'* gpctrBufOprnNotInProgErr        noTransferInProgError
'* badFilterFreqErr                badFilterCutoffError
'* sc2040HoldModeErr               sc2040HoldModeError
'* sc2040InputModeErr              sc2040InputModeError
'* noSC2040ConfigErr               noSetupError
'* DAQCardConfigErr                DAQCardConfigError
'* partialTransferCompleteErr      partialTransferCompleteError
'* DMABufferAlignmentErr           memAlignmentError
'* outputTypeMustBeVoltageErr      outputTypeMustBeVoltageError
'* osUnsupportedErr                osUnsupportedError
'* osErr                           osError
'*********************************************************************'
