/*
 * Decompiled with CFR 0.152.
 */
package RTADiscoveryProtocol;

import RTADiscoveryProtocol.RTADevice;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class DiscoveryClient {
    private static final int RECEIVE_PORT = 28250;
    private static final int SEND_PORT = 51000;
    private static final String MULTICAST_IP = "224.0.5.128";
    private static final byte DELAY_MULTIPLIER = 10;
    private static final int WAIT_MS = 1000;
    private static final String DISCOVERY_REQUEST_HEADER = "RTA Device DiscoveryRTAD";
    private static final String DISCOVERY_RESPONSE_HEADER = "RTAD";
    private static final int IP_FIELD_LENGTH = 4;
    private static final int RTA_DISC_TAG_IP = 2;
    private static final int RTA_DISC_TAG_MAC = 1;
    private static final int RTA_DISC_TAG_MASK = 3;
    private static final int RTA_DISC_TAG_GW = 11;
    private static final int RTA_DISC_TAG_HW = 129;
    private static final int RTA_DISC_TAG_APP = 13;
    private static final int RTA_DISC_TAG_VER = 8;
    private static final int RTA_DISC_TAG_SEQ = 130;
    private static final int RTA_DISC_TAG_CRCS = 150;
    private static final int RTA_DISC_TAG_CRC = 240;
    private static final int RTA_DISC_TAG_TICK = 131;
    private static final int RTA_DISC_TAG_RND2 = 147;
    private static final int RTA_DISC_TAG_RND1 = 132;
    private static final int RTA_DISC_TAG_RND = 148;
    private static final int RTA_DISC_TAG_PSWD = 133;
    private static final int RTA_DISC_TAG_LOC = 134;
    private static final int RTA_DISC_TAG_DISC = 149;
    private static final int RTA_DISC_TAG_MULT = 242;

    public static RTADevice[] discoverRTADevicesLocalBroadcast() throws UnknownHostException, IOException {
        return DiscoveryClient.discoverRTADevicesLocalBroadcast(null);
    }

    public static RTADevice[] discoverRTADevicesLocalBroadcast(InetAddress ipaLocal) throws UnknownHostException, IOException {
        RTADevice[] rtaList = new RTADevice[]{};
        boolean i = false;
        int j = 0;
        InetAddress multicastAddress = InetAddress.getByName(MULTICAST_IP);
        MulticastSocket socket = new MulticastSocket(28250);
        socket.joinGroup(multicastAddress);
        byte[] discoveryMessage = DiscoveryClient.createMulticastDiscoveryRequest();
        DatagramPacket sendPacket = new DatagramPacket(discoveryMessage, 0, discoveryMessage.length, InetAddress.getByName("255.255.255.255"), 51000);
        socket.setBroadcast(true);
        socket.setSoTimeout(1000);
        socket.send(sendPacket);
        try {
            while (true) {
                byte[] receiveMessage = new byte[205];
                DatagramPacket receivePacket = new DatagramPacket(receiveMessage, receiveMessage.length);
                socket.receive(receivePacket);
                RTADevice tempRTA = DiscoveryClient.parseDiscoveryResponse(receiveMessage);
                if (tempRTA == null) continue;
                RTADevice[] tempRTAList = new RTADevice[rtaList.length + 1];
                for (j = 0; j < rtaList.length; ++j) {
                    tempRTAList[j] = rtaList[j];
                }
                tempRTAList[j] = tempRTA;
                rtaList = tempRTAList;
            }
        }
        catch (SocketTimeoutException ste) {
        }
        catch (Exception e) {
            System.out.println("an exception occured!");
            return null;
        }
        socket.close();
        return rtaList;
    }

    private static byte[] createMulticastDiscoveryRequest() {
        int i;
        byte[] discoveryRequest = new byte[DISCOVERY_REQUEST_HEADER.length() + 9];
        for (i = 0; i < DISCOVERY_REQUEST_HEADER.length(); ++i) {
            discoveryRequest[i] = (byte)DISCOVERY_REQUEST_HEADER.charAt(i);
        }
        discoveryRequest[DISCOVERY_REQUEST_HEADER.length()] = 2;
        discoveryRequest[DISCOVERY_REQUEST_HEADER.length() + 1] = 4;
        String[] ipValues = MULTICAST_IP.split("[.]+");
        for (i = DISCOVERY_REQUEST_HEADER.length() + 2; i < DISCOVERY_REQUEST_HEADER.length() + 6; ++i) {
            discoveryRequest[i] = (byte)Integer.parseInt(ipValues[i - 2 - DISCOVERY_REQUEST_HEADER.length()]);
        }
        discoveryRequest[i] = -14;
        discoveryRequest[i + 1] = 1;
        discoveryRequest[i + 2] = 10;
        return discoveryRequest;
    }

    private static RTADevice parseDiscoveryResponse(byte[] abResponse) throws UnknownHostException {
        int i;
        RTADevice rtad = new RTADevice();
        for (i = 0; i < DISCOVERY_RESPONSE_HEADER.length(); ++i) {
            if (abResponse[i] == DISCOVERY_RESPONSE_HEADER.charAt(i)) continue;
            return null;
        }
        while (i < abResponse.length) {
            int iFieldLength = abResponse[i + 1];
            if (i + 2 + iFieldLength > abResponse.length) {
                return null;
            }
            switch (abResponse[i]) {
                case 1: {
                    for (int k = 0; k < iFieldLength; ++k) {
                        rtad.m_macstring = k == 0 ? String.format("%02x", abResponse[i + 2 + k] >= 0 ? abResponse[i + 2 + k] : abResponse[i + 2 + k] + 256) : rtad.m_macstring + "-" + String.format("%02x", abResponse[i + 2 + k] >= 0 ? abResponse[i + 2 + k] : abResponse[i + 2 + k] + 256);
                    }
                    break;
                }
                case 2: {
                    if (iFieldLength != 4) {
                        return null;
                    }
                    rtad.m_ipa = DiscoveryClient.IPFromSubArray(abResponse, i + 2);
                    break;
                }
                case 3: {
                    if (iFieldLength != 4) {
                        return null;
                    }
                    rtad.m_ipaNetmask = DiscoveryClient.IPFromSubArray(abResponse, i + 2);
                    break;
                }
                case 13: {
                    rtad.m_strApplication = "";
                    for (int j = 0; j < iFieldLength; ++j) {
                        rtad.m_strApplication = rtad.m_strApplication + (char)abResponse[i + 2 + j];
                    }
                    break;
                }
            }
            i += iFieldLength + 2;
        }
        return rtad;
    }

    private static InetAddress IPFromSubArray(byte[] abPacket, int iStartPos) throws UnknownHostException {
        byte[] abSubArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            abSubArray[i] = abPacket[iStartPos + i];
        }
        return InetAddress.getByAddress(abSubArray);
    }
}

