/*
 * Decompiled with CFR 0.152.
 */
package com.atiia.automation.sensors;

import com.atiia.automation.sensors.NetFTRDTCommand;
import com.atiia.automation.sensors.NetFTRDTPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class NetFTSensor {
    private static final String VERSION = "1.0.2";
    private InetAddress m_iaNetFTAddress;
    private final int RDTPORT = 49152;
    private final int NETFT_RDT_COMMAND_LENGTH = 8;
    private final int NETFT_RDT_DATA_LENGTH = 36;

    public NetFTSensor(InetAddress setAddress) throws UnknownHostException {
        this.m_iaNetFTAddress = InetAddress.getByAddress(setAddress.getAddress());
    }

    public NetFTRDTPacket readSingleFTRecord() throws SocketException, IOException {
        NetFTRDTCommand netFTCommand = new NetFTRDTCommand();
        netFTCommand.setCount(1L);
        DatagramSocket netFTSocket = new DatagramSocket();
        int SINGLE_RDT_TIMEOUT = 500;
        netFTSocket.setSoTimeout(500);
        netFTSocket.connect(this.m_iaNetFTAddress, 49152);
        DatagramPacket commandPacket = this.getDatagramPacketFromNetFTRDTCommand(netFTCommand);
        netFTSocket.send(commandPacket);
        DatagramPacket NetFTRDTDataPacket = new DatagramPacket(new byte[36], 36);
        netFTSocket.receive(NetFTRDTDataPacket);
        return this.getNetFTRDTPacketFromDatagramPacket(NetFTRDTDataPacket);
    }

    public DatagramSocket startHighSpeedDataCollection(int iCount) throws SocketException, IOException {
        NetFTRDTCommand cNetFTCommand = new NetFTRDTCommand(2, iCount);
        int HIGH_SPEED_RDT_TIMEOUT = 1500;
        DatagramSocket cNetFTSocket = new DatagramSocket();
        cNetFTSocket.setSoTimeout(1500);
        cNetFTSocket.connect(this.m_iaNetFTAddress, 49152);
        DatagramPacket cRDTCommandPacket = this.getDatagramPacketFromNetFTRDTCommand(cNetFTCommand);
        cNetFTSocket.send(cRDTCommandPacket);
        return cNetFTSocket;
    }

    public void tare() throws SocketException, IOException {
        NetFTRDTCommand cNetFTCommand = new NetFTRDTCommand(66, 1L);
        DatagramSocket cNetFTSocket = new DatagramSocket();
        cNetFTSocket.connect(this.m_iaNetFTAddress, 49152);
        DatagramPacket cRDTCommandPacket = this.getDatagramPacketFromNetFTRDTCommand(cNetFTCommand);
        cNetFTSocket.send(cRDTCommandPacket);
        cNetFTSocket.close();
    }

    public NetFTRDTPacket[] readHighSpeedData(DatagramSocket cNetFTSocket, int iCount) throws IOException {
        DatagramPacket cNetFTRDTPacket = new DatagramPacket(new byte[36], 36);
        NetFTRDTPacket[] caNetFTRDTPackets = new NetFTRDTPacket[iCount];
        for (int i = 0; i < iCount; ++i) {
            cNetFTSocket.receive(cNetFTRDTPacket);
            caNetFTRDTPackets[i] = this.getNetFTRDTPacketFromDatagramPacket(cNetFTRDTPacket);
        }
        return caNetFTRDTPackets;
    }

    public void stopDataCollection(DatagramSocket cNetFTSocket) throws IOException {
        NetFTRDTCommand cNetFTStopCommand = new NetFTRDTCommand(0, 0L);
        DatagramPacket cNetFTStopPacket = this.getDatagramPacketFromNetFTRDTCommand(cNetFTStopCommand);
        cNetFTSocket.send(cNetFTStopPacket);
        cNetFTSocket.close();
    }

    private NetFTRDTPacket getNetFTRDTPacketFromDatagramPacket(DatagramPacket NetFTRDTDataPacket) {
        int NUM_RDT_FIELDS = 9;
        int[] rdtFields = new int[9];
        byte[] dataBuf = NetFTRDTDataPacket.getData();
        for (int i = 8; i >= 0; --i) {
            rdtFields[i] = dataBuf[i * 4] & 0xFF;
            for (int j = i * 4 + 1; j < i * 4 + 4; ++j) {
                rdtFields[i] = rdtFields[i] << 8 | dataBuf[j] & 0xFF;
            }
        }
        return new NetFTRDTPacket(rdtFields);
    }

    private DatagramPacket getDatagramPacketFromNetFTRDTCommand(NetFTRDTCommand netFTCommand) {
        int NUM_RDT_COMMAND_FIELDS = 3;
        byte[] dataBuf = new byte[]{(byte)(netFTCommand.getHeader() >> 8 & 0xFF), (byte)(netFTCommand.getHeader() & 0xFF), (byte)(netFTCommand.getCommand() >> 8 & 0xFF), (byte)(netFTCommand.getCommand() & 0xFF), (byte)(netFTCommand.getCount() >> 24 & 0xFFL), (byte)(netFTCommand.getCount() >> 16 & 0xFFL), (byte)(netFTCommand.getCount() >> 8 & 0xFFL), (byte)(netFTCommand.getCount() & 0xFFL)};
        return new DatagramPacket(dataBuf, 8);
    }

    public static String getVersion() {
        return VERSION;
    }
}

