/*
 * Decompiled with CFR 0.152.
 */
package com.atiia.automation.sensors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;

public class FTVisualizationCube
extends JPanel {
    private double m_dfocalLength = 2.5;
    private double m_dPitch = 0.0;
    private double m_dRoll = 0.0;
    private double m_dYaw = 0.0;
    private int m_iEdgeLength = 0;
    private final double FILL_SCALE = 1.15;
    private double[][] m_adRotationMatrix;
    private double[] m_adFTValues = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private double m_dMaxForce = 100.0;
    private double m_dMaxTorque = 100.0;

    public FTVisualizationCube() {
        this.updateRotationMatrix();
        this.initComponents();
        MyMouseAdapter mma = new MyMouseAdapter();
        this.addMouseMotionListener(mma);
        this.addMouseListener(mma);
        this.addMouseWheelListener(mma);
    }

    public void setPitch(double dPitch) {
        this.m_dPitch = dPitch;
        this.updateRotationMatrix();
        this.update(this.getGraphics());
    }

    public void setYaw(double dYaw) {
        this.m_dYaw = dYaw;
        this.updateRotationMatrix();
        this.update(this.getGraphics());
    }

    public void setRoll(double dRoll) {
        this.m_dRoll = dRoll;
        this.updateRotationMatrix();
        this.update(this.getGraphics());
    }

    public void setMaxForce(double dMaxForce) {
        this.m_dMaxForce = dMaxForce;
        this.update(this.getGraphics());
    }

    public void setMaxTorque(double dMaxTorque) {
        this.m_dMaxTorque = dMaxTorque;
        this.update(this.getGraphics());
    }

    public void setFTValues(double[] adFTValues) {
        for (int i = 0; i < 6; ++i) {
            this.m_adFTValues[i] = adFTValues[i];
        }
        this.update(this.getGraphics());
    }

    @Override
    public void paint(Graphics g) {
        if (null == g) {
            return;
        }
        this.m_iEdgeLength = (int)((double)(this.getHeight() > this.getWidth() ? this.getWidth() : this.getHeight()) * 1.15);
        int iHalfEdgeLength = this.m_iEdgeLength / 2;
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        this.draw3DLine(g, iHalfEdgeLength, 0.0, 0.0, -iHalfEdgeLength, 0.0, 0.0, "+X");
        this.draw3DLine(g, 0.0, iHalfEdgeLength, 0.0, 0.0, -iHalfEdgeLength, 0.0, "+Y");
        this.draw3DLine(g, 0.0, 0.0, iHalfEdgeLength, 0.0, 0.0, -iHalfEdgeLength, "+Z");
        g.setColor(Color.BLACK);
        this.draw3DLine(g, iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, "");
        this.draw3DLine(g, iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, "");
        this.draw3DLine(g, iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, "");
        this.draw3DLine(g, iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, "");
        this.draw3DLine(g, iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, "");
        this.draw3DLine(g, iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, "");
        this.draw3DLine(g, -iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, "");
        this.draw3DLine(g, -iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, "");
        this.draw3DLine(g, -iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, "");
        this.draw3DLine(g, -iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, "");
        this.draw3DLine(g, -iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, iHalfEdgeLength, "");
        this.draw3DLine(g, -iHalfEdgeLength, -iHalfEdgeLength, iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, -iHalfEdgeLength, "");
        g.setColor(Color.GREEN);
        this.draw3DLine(g, (double)iHalfEdgeLength * this.m_adFTValues[0] / this.m_dMaxForce, (double)iHalfEdgeLength * this.m_adFTValues[1] / this.m_dMaxForce, (double)iHalfEdgeLength * this.m_adFTValues[2] / this.m_dMaxForce, 0.0, 0.0, 0.0, "F");
        g.setColor(Color.BLUE);
        this.draw3DLine(g, (double)iHalfEdgeLength * this.m_adFTValues[3] / this.m_dMaxTorque, (double)iHalfEdgeLength * this.m_adFTValues[4] / this.m_dMaxTorque, (double)iHalfEdgeLength * this.m_adFTValues[5] / this.m_dMaxTorque, 0.0, 0.0, 0.0, "T");
    }

    public void draw3DLine(Graphics g, double dStartX, double dStartY, double dStartZ, double dEndX, double dEndY, double dEndZ, String strLabel) {
        double[] dStartPointVector = new double[]{dStartX, dStartY, dStartZ};
        this.rotateVector(dStartPointVector);
        double dZDivider = (this.m_dfocalLength * (double)this.m_iEdgeLength - dStartPointVector[2]) / (double)this.m_iEdgeLength;
        if (0.0 >= dZDivider) {
            dZDivider = 1.0E-4;
        }
        int i2DXStart = (int)(dStartPointVector[0] / dZDivider + (double)(this.getWidth() / 2));
        int i2DYStart = (int)(dStartPointVector[1] / dZDivider + (double)(this.getHeight() / 2));
        double[] dEndPointVector = new double[]{dEndX, dEndY, dEndZ};
        this.rotateVector(dEndPointVector);
        dZDivider = (this.m_dfocalLength * (double)this.m_iEdgeLength - dEndPointVector[2]) / (double)this.m_iEdgeLength;
        if (0.0 >= dZDivider) {
            dZDivider = 1.0E-4;
        }
        int i2DXEnd = (int)(dEndPointVector[0] / dZDivider + (double)(this.getWidth() / 2));
        int i2DYEnd = (int)(dEndPointVector[1] / dZDivider + (double)(this.getHeight() / 2));
        g.drawLine(i2DXStart, i2DYStart, i2DXEnd, i2DYEnd);
        if ("" != strLabel) {
            g.drawString(strLabel, i2DXStart - 5, i2DYStart);
        }
    }

    private void rotateVector(double[] ad3DVector) {
        double[] adResultVector = new double[]{this.m_adRotationMatrix[0][0] * ad3DVector[0] + this.m_adRotationMatrix[0][1] * ad3DVector[1] + this.m_adRotationMatrix[0][2] * ad3DVector[2], this.m_adRotationMatrix[1][0] * ad3DVector[0] + this.m_adRotationMatrix[1][1] * ad3DVector[1] + this.m_adRotationMatrix[1][2] * ad3DVector[2], this.m_adRotationMatrix[2][0] * ad3DVector[0] + this.m_adRotationMatrix[2][1] * ad3DVector[1] + this.m_adRotationMatrix[2][2] * ad3DVector[2]};
        ad3DVector[0] = adResultVector[0];
        ad3DVector[1] = adResultVector[1];
        ad3DVector[2] = adResultVector[2];
    }

    private void updateRotationMatrix() {
        double dRollRadians = this.m_dRoll * Math.PI / 180.0;
        double dPitchRadians = this.m_dPitch * Math.PI / 180.0;
        double dYawRadians = this.m_dYaw * Math.PI / 180.0;
        double cx = Math.cos(dRollRadians);
        double sx = Math.sin(dRollRadians);
        double cy = Math.cos(dPitchRadians);
        double sy = Math.sin(dPitchRadians);
        double cz = Math.cos(dYawRadians);
        double sz = Math.sin(dYawRadians);
        double[][] adNewRotationMatrix = new double[][]{{cy * cz, sx * sy * cz + cx * sz, sx * sz - cx * sy * cz}, {-cy * sz, -sx * sy * sz + cx * cz, sx * cz + cx * sy * sz}, {sy, -sx * cy, cx * cy}};
        this.m_adRotationMatrix = adNewRotationMatrix;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class MyMouseAdapter
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Point m_pLastPoint = null;

        private MyMouseAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (null != this.m_pLastPoint) {
                double dRollChange = (float)(e.getPoint().x - this.m_pLastPoint.x) * 360.0f / (float)FTVisualizationCube.this.getWidth();
                FTVisualizationCube.this.m_dRoll += dRollChange;
                if (180.0 < FTVisualizationCube.this.m_dRoll) {
                    FTVisualizationCube.this.m_dRoll = 180.0;
                } else if (-180.0 > FTVisualizationCube.this.m_dRoll) {
                    FTVisualizationCube.this.m_dRoll = -180.0;
                }
                double dPitchChange = (float)(e.getPoint().y - this.m_pLastPoint.y) * 360.0f / (float)FTVisualizationCube.this.getHeight();
                FTVisualizationCube.this.m_dPitch += dPitchChange;
                if (180.0 < FTVisualizationCube.this.m_dPitch) {
                    FTVisualizationCube.this.m_dPitch = 180.0;
                } else if (-180.0 > FTVisualizationCube.this.m_dPitch) {
                    FTVisualizationCube.this.m_dPitch = -180.0;
                }
                FTVisualizationCube.this.updateRotationMatrix();
                FTVisualizationCube.this.update(FTVisualizationCube.this.getGraphics());
            }
            this.m_pLastPoint = e.getPoint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.m_pLastPoint = e.getPoint();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            FTVisualizationCube.this.m_dYaw += e.getWheelRotation();
            if (180.0 < FTVisualizationCube.this.m_dYaw) {
                FTVisualizationCube.this.m_dYaw = 180.0;
            } else if (-180.0 > FTVisualizationCube.this.m_dYaw) {
                FTVisualizationCube.this.m_dYaw = -180.0;
            }
            FTVisualizationCube.this.updateRotationMatrix();
            FTVisualizationCube.this.update(FTVisualizationCube.this.getGraphics());
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

