/*
 * Decompiled with CFR 0.152.
 */
package netftsample;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MovingLineChart
extends JPanel {
    private double[][] m_FTYValues = null;
    private int[] m_FTXCoords = null;
    private int[][] m_FTYCoords = null;
    private int m_dataBufferPointer = 0;
    private boolean m_dataHasBeenSet = false;
    private int m_xMinPos = 0;
    private int m_yMinPos = 0;
    private int m_xMaxPos = 0;
    private int m_yMaxPos = 0;
    private int m_yZeroPos = 0;
    private double m_maxYValue = 100.0;
    private boolean m_autoscaling = false;
    private double m_autoScalingMaxValue = 0.0;
    private static final int NUM_XAXIS_TICKS = 10;
    private static final int NUM_YAXIS_TICKS = 10;

    public MovingLineChart() {
    }

    public MovingLineChart(JFrame window, Graphics graphics, Graphics2D g2d, BufferedImage bi) {
        this();
        this.setGraphingArea(window, graphics, g2d, bi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGraphics(JFrame window, Graphics graphics, Graphics2D g2d, BufferedImage bi, int xPos, int yPos) {
        if (this.m_dataHasBeenSet) {
            int i = 0;
            int j = 0;
            window.createBufferStrategy(1);
            BufferStrategy buffer = window.getBufferStrategy();
            if (this.m_autoscaling) {
                this.findMaxYValue();
                if (this.m_maxYValue < this.m_autoScalingMaxValue / 1000.0) {
                    this.m_maxYValue = this.m_autoScalingMaxValue / 1000.0;
                }
            }
            this.calculateYCoords();
            this.setGraphingArea(window, graphics, g2d, bi);
            this.calculateXCoords();
            try {
                g2d = bi.createGraphics();
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.fillRect(0, 0, bi.getWidth() - 1, bi.getHeight() - 1);
                int tempBufferPointer = this.m_dataBufferPointer;
                for (i = 0; i < 6; ++i) {
                    j = 0;
                    if (++tempBufferPointer > this.m_FTYValues[i].length - 1) {
                        tempBufferPointer = 0;
                    }
                    do {
                        this.setColor(i, g2d);
                        if (j < this.m_FTYValues[i].length - 2) {
                            if (tempBufferPointer < this.m_FTYValues[i].length - 1) {
                                g2d.drawLine(this.m_FTXCoords[j], this.m_FTYCoords[i][tempBufferPointer], this.m_FTXCoords[j + 1], this.m_FTYCoords[i][tempBufferPointer + 1]);
                            } else {
                                g2d.drawLine(this.m_FTXCoords[j], this.m_FTYCoords[i][tempBufferPointer], this.m_FTXCoords[j + 1], this.m_FTYCoords[i][0]);
                            }
                        }
                        if (++tempBufferPointer > this.m_FTYValues[i].length - 1) {
                            tempBufferPointer = 0;
                        }
                        if (++j <= this.m_FTYValues[i].length - 1) continue;
                        j = 0;
                    } while (tempBufferPointer != this.m_dataBufferPointer);
                }
                g2d.setColor(Color.BLACK);
                g2d.drawLine(this.m_xMinPos, this.m_yMaxPos, this.m_xMinPos, this.m_yMinPos);
                g2d.drawLine(this.m_xMinPos, this.m_yZeroPos, this.m_xMaxPos, this.m_yZeroPos);
                for (i = 0; i <= 10; ++i) {
                    int xtickPosition = this.m_xMinPos + (int)((double)i * (Math.abs((double)this.m_xMaxPos - (double)this.m_xMinPos) / 10.0));
                    g2d.drawLine(xtickPosition, this.m_yZeroPos + 5, xtickPosition, this.m_yZeroPos - 5);
                }
                for (i = 0; i <= 10; ++i) {
                    double yValue;
                    int ytickPosition = this.m_yMinPos - (int)((double)i * (Math.abs((double)this.m_yMaxPos - (double)this.m_yMinPos) / 10.0));
                    if (i == 5) {
                        ytickPosition = this.m_yZeroPos;
                    }
                    g2d.drawLine(this.m_xMinPos - 5, ytickPosition, this.m_xMinPos + 5, ytickPosition);
                    String yLabel = this.formatYAxisDigit(this.m_maxYValue, i);
                    int yLabelXPos = this.m_xMinPos - (6 + 7 * yLabel.length());
                    if (i < 5) {
                        yLabelXPos += 3;
                    }
                    if ((Math.abs(yValue = this.m_maxYValue * (((double)i - 5.0) / 5.0)) < 0.001 || Math.abs(yValue) > 99999.0) && yValue != 0.0) {
                        yLabelXPos += 3;
                    }
                    g2d.drawString(yLabel, yLabelXPos, ytickPosition + 5);
                }
                g2d.drawLine(0, 0, bi.getWidth(), 0);
                g2d.drawLine(0, 0, 0, bi.getHeight());
                for (i = 0; i <= 5; ++i) {
                    int legendLabelPosition = this.m_yMaxPos + 26 + (int)((double)i * ((Math.abs((double)this.m_yMaxPos - (double)this.m_yMinPos) - 50.0) / 5.0));
                    String[] legendLabels = new String[]{"Fx", "Fy", "Fz", "Tx", "Ty", "Tz"};
                    g2d.setColor(Color.BLACK);
                    g2d.drawString(legendLabels[i], this.m_xMaxPos + 35, legendLabelPosition + 5);
                    this.setColor(i, g2d);
                    g2d.drawLine(this.m_xMaxPos + 10, legendLabelPosition, this.m_xMaxPos + 30, legendLabelPosition);
                }
                graphics = buffer.getDrawGraphics();
                graphics.drawImage(bi, xPos, yPos, window);
                if (!buffer.contentsLost()) {
                    buffer.show();
                }
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
                if (g2d != null) {
                    g2d.dispose();
                }
            }
        }
    }

    public void ClearData() {
        if (this.m_dataHasBeenSet) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < this.m_FTYValues[0].length; ++j) {
                    this.m_FTYValues[i][j] = 0.0;
                    this.m_FTXCoords[j] = 0;
                    this.m_FTYCoords[i][j] = this.m_yZeroPos;
                }
            }
        }
    }

    public void addDataPoint(double[] newValues) {
        if (this.m_xMinPos != 0 && this.m_dataHasBeenSet) {
            for (int i = 0; i < 6; ++i) {
                this.m_FTYValues[i][this.m_dataBufferPointer] = -newValues[i];
                this.m_FTYCoords[i][this.m_dataBufferPointer] = (int)((double)this.m_yZeroPos + this.m_FTYValues[i][this.m_dataBufferPointer] * ((double)Math.abs(this.m_yMaxPos - this.m_yZeroPos) / (this.m_maxYValue / 2.0)));
            }
            ++this.m_dataBufferPointer;
            if (this.m_dataBufferPointer > this.m_FTYValues[0].length - 1) {
                this.m_dataBufferPointer = 0;
            }
        }
    }

    public void setArraySize(int size) {
        this.m_FTYValues = new double[6][size];
        this.m_FTXCoords = new int[size];
        this.m_FTYCoords = new int[6][size];
        this.m_dataHasBeenSet = true;
        this.m_dataBufferPointer = 0;
        this.ClearData();
        this.calculateXCoords();
    }

    private void setGraphingArea(JFrame window, Graphics graphics, Graphics2D g2d, BufferedImage bi) {
        int maxStringLength = 0;
        for (int i = 0; i < 6; ++i) {
            String labelString = this.formatYAxisDigit(this.m_maxYValue, i);
            if (labelString.length() <= maxStringLength) continue;
            maxStringLength = labelString.length();
        }
        this.m_xMinPos = 60;
        this.m_yMinPos = bi.getHeight() - 10;
        this.m_xMaxPos = bi.getWidth() - 55;
        this.m_yMaxPos = 10;
        this.m_yZeroPos = Math.abs(this.m_yMaxPos - this.m_yMinPos) / 2 + this.m_yMaxPos;
    }

    private void calculateXCoords() {
        for (int i = 0; i < this.m_FTYValues[0].length; ++i) {
            this.m_FTXCoords[i] = (int)((double)this.m_xMinPos + (double)i * ((double)(this.m_xMaxPos - this.m_xMinPos) / (double)this.m_FTYValues[0].length));
        }
    }

    private void calculateYCoords() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.m_FTYValues[i].length; ++j) {
                this.m_FTYCoords[i][j] = (int)((double)this.m_yZeroPos + this.m_FTYValues[i][j] * ((double)Math.abs(this.m_yMaxPos - this.m_yZeroPos) / this.m_maxYValue));
            }
        }
    }

    private void findMaxYValue() {
        double max = 0.0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.m_FTYValues[i].length; ++j) {
                if (!(Math.abs(this.m_FTYValues[i][j]) > Math.abs(max))) continue;
                max = Math.abs(this.m_FTYValues[i][j]);
            }
        }
        this.m_maxYValue = max;
    }

    private void setColor(int color, Graphics2D g2d) {
        switch (color) {
            case 0: {
                g2d.setColor(Color.RED);
                break;
            }
            case 1: {
                g2d.setColor(Color.BLUE);
                break;
            }
            case 2: {
                g2d.setColor(Color.GREEN);
                break;
            }
            case 3: {
                g2d.setColor(Color.MAGENTA);
                break;
            }
            case 4: {
                g2d.setColor(Color.ORANGE);
                break;
            }
            case 5: {
                g2d.setColor(Color.DARK_GRAY);
                break;
            }
            default: {
                g2d.setColor(Color.BLACK);
            }
        }
    }

    public boolean isAutoscaling() {
        return this.m_autoscaling;
    }

    public void setAutoscaling(boolean autoscaling, double maxValue) {
        if (autoscaling) {
            this.findMaxYValue();
            if (this.m_maxYValue < maxValue / 1000.0) {
                this.m_maxYValue = maxValue / 1000.0;
            }
            this.m_autoScalingMaxValue = maxValue;
            this.calculateYCoords();
        } else {
            this.m_maxYValue = maxValue;
            this.calculateYCoords();
        }
        this.m_autoscaling = autoscaling;
    }

    private String formatYAxisDigit(double maxValue, int i) {
        double yValue = maxValue * (((double)i - 5.0) / 5.0);
        String yLabel = null;
        DecimalFormat formatter = new DecimalFormat("0.##E0");
        if ((Math.abs(yValue) < 0.001 || Math.abs(yValue) >= 100000.0) && yValue != 0.0) {
            yLabel = formatter.format(yValue);
            return yLabel;
        }
        if (Math.abs(yValue) >= 10000.0 && Math.abs(yValue) < 100000.0) {
            yLabel = Double.toString(yValue);
            if (yValue < 0.0) {
                if (yLabel.length() > 6) {
                    yLabel = yLabel.substring(0, 6);
                }
            } else if (yLabel.length() > 5) {
                yLabel = yLabel.substring(0, 5);
            }
            return yLabel;
        }
        yLabel = Double.toString(yValue);
        if (yValue < 0.0) {
            if (yLabel.length() > 7) {
                yLabel = yLabel.substring(0, 7);
            }
        } else if (yLabel.length() > 6) {
            yLabel = yLabel.substring(0, 6);
        }
        return yLabel;
    }
}

