/*
 * Decompiled with CFR 0.152.
 */
package netftsample;

import RTADiscoveryProtocol.DiscoveryClient;
import RTADiscoveryProtocol.RTADevice;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netftsample.NetFTOptions;
import netftsample.NetFTSampleGUI;

public class NetFTDiscoveryGUI
extends JFrame {
    private NetFTOptions m_demoOptions = null;
    private String m_optionsFileLocation = "ATINetFTDemoOptions.xml";
    private String m_tempMACAddress = null;
    private JTextField jAddressField;
    private JLabel jAddressLabel;
    private JButton jClearMessagesButton;
    private JButton jConnectButton;
    private JList jDeviceList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JButton jRefreshButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;
    private JTextArea jTextFeedback;

    public NetFTDiscoveryGUI() {
        this.initComponents();
        this.loadSettings();
        this.refreshDeviceList();
        if (this.m_demoOptions.getLastIPAddress() == null) {
            this.jAddressField.setText("IP Address");
        } else {
            this.jAddressField.setText(this.m_demoOptions.getLastIPAddress());
        }
        this.m_tempMACAddress = this.m_demoOptions.getLastMACAddress();
        this.saveSettings();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jConnectButton = new JButton();
        this.jAddressField = new JTextField();
        this.jAddressLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jDeviceList = new JList();
        this.jRefreshButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextFeedback = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jClearMessagesButton = new JButton();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.setDefaultCloseOperation(3);
        this.setTitle("ATI Industrial Automation Net F/T Demo");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("ati1.jpg")));
        this.setMinimumSize(new Dimension(548, 275));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NetFTDiscoveryGUI.this.formWindowClosing(evt);
            }
        });
        this.jConnectButton.setText("Connect");
        this.jConnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTDiscoveryGUI.this.jConnectButtonActionPerformed(evt);
            }
        });
        this.jAddressField.setText("222.222.222.222");
        this.jAddressField.setToolTipText("");
        this.jAddressField.setMinimumSize(new Dimension(90, 20));
        this.jAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NetFTDiscoveryGUI.this.jAddressFieldKeyTyped(evt);
            }
        });
        this.jAddressLabel.setText("IP Address:");
        this.jDeviceList.setFont(new Font("Courier New", 0, 11));
        this.jDeviceList.setSelectionMode(0);
        this.jDeviceList.setToolTipText("");
        this.jDeviceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                NetFTDiscoveryGUI.this.jDeviceListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jDeviceList);
        this.jRefreshButton.setText("Refresh Devices");
        this.jRefreshButton.setMaximumSize(new Dimension(130, 23));
        this.jRefreshButton.setMinimumSize(new Dimension(130, 23));
        this.jRefreshButton.setPreferredSize(new Dimension(130, 23));
        this.jRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTDiscoveryGUI.this.jRefreshButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Available devices listed below:");
        this.jTextFeedback.setColumns(20);
        this.jTextFeedback.setEditable(false);
        this.jTextFeedback.setRows(3);
        this.jScrollPane3.setViewportView(this.jTextFeedback);
        this.jLabel2.setText("Message Area:");
        this.jClearMessagesButton.setText("Clear Messages");
        this.jClearMessagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTDiscoveryGUI.this.jClearMessagesButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jRefreshButton, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 155, Short.MAX_VALUE).addComponent(this.jAddressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAddressField, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jConnectButton)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jClearMessagesButton)).addComponent(this.jScrollPane3)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(22, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 194, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConnectButton).addComponent(this.jAddressField, -2, -1, -2).addComponent(this.jAddressLabel).addComponent(this.jRefreshButton, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jClearMessagesButton).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 64, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 556) / 2, (screenSize.height - 407) / 2, 556, 407);
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    private void jDeviceListValueChanged(ListSelectionEvent evt) {
        if (this.jDeviceList.getSelectedValue() != null) {
            String selectedItem = (String)this.jDeviceList.getSelectedValue();
            String subString = selectedItem.substring(3, selectedItem.indexOf(" "));
            this.jAddressField.setText(subString);
            int macStartIndex = selectedItem.indexOf("M", selectedItem.indexOf(" ")) + 4;
            this.m_tempMACAddress = subString = selectedItem.substring(macStartIndex, selectedItem.indexOf(" ", selectedItem.indexOf("M")));
        }
    }

    private void jRefreshButtonActionPerformed(ActionEvent evt) {
        this.refreshDeviceList();
    }

    private void jClearMessagesButtonActionPerformed(ActionEvent evt) {
        this.jTextFeedback.setText("");
    }

    private void jConnectButtonActionPerformed(ActionEvent evt) {
        try {
            String deviceAddress = this.jAddressField.getText().trim();
            String[] splitIPAddress = new String[4];
            int[] temp = new int[4];
            if (deviceAddress.length() < 16 && deviceAddress.length() > 6) {
                int i;
                int periodCount = 0;
                for (i = 0; i < deviceAddress.length(); ++i) {
                    if (deviceAddress.charAt(i) != '.') continue;
                    ++periodCount;
                }
                if (periodCount == 3) {
                    splitIPAddress = deviceAddress.split("[.]+");
                    for (i = 0; i < splitIPAddress.length; ++i) {
                        temp[i] = Integer.parseInt(splitIPAddress[i]);
                        if (temp[i] <= 255 && temp[i] >= 0) continue;
                        this.InvalidInputMessage();
                        return;
                    }
                    this.m_demoOptions.setLastMACAddress(this.m_tempMACAddress);
                    this.m_demoOptions.setLastIPAddress(deviceAddress);
                    this.saveSettings();
                    final String deviceAddressToPassToSampleGui = deviceAddress;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new NetFTSampleGUI(deviceAddressToPassToSampleGui + " - ATINetFT Demo").setVisible(true);
                        }
                    });
                    this.setVisible(false);
                } else {
                    this.InvalidInputMessage();
                }
            } else {
                this.InvalidInputMessage();
            }
        }
        catch (Exception e) {
            this.InvalidInputMessage();
        }
    }

    private void InvalidInputMessage() {
        this.jAddressField.setText("");
        this.jTextFeedback.append("Invalid IP Address.  Enter the valid IPv4 address of the device or select a device above.");
    }

    private void jAddressFieldKeyTyped(KeyEvent evt) {
        if (!Character.isDigit(evt.getKeyChar()) && evt.getKeyChar() != '.') {
            evt.consume();
        }
    }

    public static void main(String[] args) {
    }

    private void loadSettings() {
        this.m_demoOptions = null;
        try {
            FileInputStream fis = new FileInputStream(this.m_optionsFileLocation);
            BufferedInputStream bis = new BufferedInputStream(fis);
            XMLDecoder xmlDecoder = new XMLDecoder(bis);
            this.m_demoOptions = (NetFTOptions)xmlDecoder.readObject();
            xmlDecoder.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Options file not found, using default settings.");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (this.m_demoOptions == null) {
            this.m_demoOptions = new NetFTOptions();
        }
    }

    private void saveSettings() {
        try {
            FileOutputStream fos = new FileOutputStream(this.m_optionsFileLocation);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            XMLEncoder e = new XMLEncoder(bos);
            e.writeObject(this.m_demoOptions);
            e.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void refreshDeviceList() {
        this.jRefreshButton.setEnabled(false);
        this.jRefreshButton.setText("Refreshing...");
        this.jDeviceList.setListData(new String[0]);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiscoveryClient dc = new DiscoveryClient();
                RTADevice[] rtadList = null;
                try {
                    rtadList = DiscoveryClient.discoverRTADevicesLocalBroadcast();
                }
                catch (Exception e) {
                    System.out.println(e);
                    NetFTDiscoveryGUI.this.jRefreshButton.setEnabled(true);
                    NetFTDiscoveryGUI.this.jRefreshButton.setText("Refresh Devices");
                    return;
                }
                if (rtadList.length == 0) {
                    NetFTDiscoveryGUI.this.NoDevicesFoundError();
                    return;
                }
                String[] stringList = null;
                for (int i = 0; i < rtadList.length; ++i) {
                    String outputString = rtadList[i].toString();
                    String[] tempList = new String[i + 1];
                    for (int j = 0; j < i; ++j) {
                        tempList[j] = stringList[j];
                    }
                    tempList[j] = outputString;
                    stringList = tempList;
                }
                if (stringList == null) {
                    NetFTDiscoveryGUI.this.NoDevicesFoundError();
                    return;
                }
                NetFTDiscoveryGUI.this.jDeviceList.setListData(stringList);
                NetFTDiscoveryGUI.this.FindLastMACAddress(stringList);
                NetFTDiscoveryGUI.this.jRefreshButton.setEnabled(true);
                NetFTDiscoveryGUI.this.jRefreshButton.setText("Refresh Devices");
            }
        });
    }

    private void NoDevicesFoundError() {
        String[] errorMessage = new String[]{"No Devices Found."};
        this.jDeviceList.setListData(errorMessage);
        this.jTextFeedback.append(errorMessage[0] + "\n");
        this.jRefreshButton.setEnabled(true);
        this.jRefreshButton.setText("Refresh Devices");
    }

    private void FindLastMACAddress(String[] stringList) {
        if (this.m_demoOptions.getLastMACAddress() != null) {
            String macAddress = null;
            for (int i = 0; i < stringList.length; ++i) {
                macAddress = stringList[i].substring(stringList[i].indexOf("M") + 4, stringList[i].indexOf(" ", stringList[i].indexOf("M")));
                if (macAddress.equals(this.m_demoOptions.getLastMACAddress())) {
                    String deviceIP = stringList[i].substring(3, stringList[i].indexOf(" "));
                    this.jAddressField.setText(deviceIP);
                    this.jTextFeedback.append("Last connected device found:    MAC = " + this.m_demoOptions.getLastMACAddress() + "    IP = " + deviceIP + "\n");
                    break;
                }
                if (i != stringList.length - 1) continue;
                this.jTextFeedback.append("Last connected device not found, defaulting to last connected IP Address.\n");
            }
        } else {
            this.jTextFeedback.append("Last connected device not found, please select a device above.\n");
        }
    }
}

