/*
 * Decompiled with CFR 0.152.
 */
package netftsample;

import com.atiia.automation.sensors.FTVisualizationCube;
import com.atiia.automation.sensors.NetFTRDTPacket;
import com.atiia.automation.sensors.NetFTSensor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import netftsample.MovingLineChart;
import netftsample.NetFTDiscoveryGUI;
import netftsample.NetFTOptions;

public class NetFTSampleGUI
extends JFrame {
    private static final String VERSION = "1.1.0";
    private static final String COPYRIGHT = "2013";
    private double[] m_daftMaxes = new double[]{100.0, 100.0, 100.0, 100.0, 100.0, 100.0};
    private double[] m_daftCountsPerUnit = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private FTVisualizationCube m_ftvc;
    private String m_strForceUnits;
    private String m_strTorqueUnits;
    private String m_strCalSN;
    private String m_strCalIndex;
    private String m_strCfgName;
    private String m_strCfgIndex;
    private JLabel[] m_lblaFTLabel;
    private String m_strSensorAddress;
    private JProgressBar[] m_progaFTReadingBar;
    private static final int NUM_FT_AXES = 6;
    private static final int FX_INDEX = 0;
    private static final int FY_INDEX = 1;
    private static final int FZ_INDEX = 2;
    private static final int TX_INDEX = 3;
    private static final int TY_INDEX = 4;
    private static final int TZ_INDEX = 5;
    private static final String[] MAX_RATED_PARAMETER_NAME = new String[]{"MAXFX", "MAXFY", "MAXFZ", "MAXTX", "MAXTY", "MAXTZ"};
    private static final Color POSITIVE_COLOR = Color.blue;
    private static final Color NEGATIVE_COLOR = Color.green;
    private DecimalFormat m_dfReading;
    private NetFTSensor m_netFT;
    private NetFTReaderThread m_NetFTReaderThread = null;
    private DatagramSocket m_cNetFTFastSocket;
    private DatagramSocket m_cNetFTSlowSocket;
    private boolean m_bDoingHighSpeedCollection = false;
    private boolean m_recordNextCollection = false;
    private PrintWriter m_cDataWriter;
    private int m_iRDTSampleRate = 0;
    private NetFTOptions m_demoOptions = null;
    private String m_optionsFileLocation = "ATINetFTDemoOptions.xml";
    private int m_lastWindowHeight = 0;
    private int m_lastWindowWidth = 0;
    private int m_maxHistoryDuration = 120;
    private MovingLineChart drawingPanel = new MovingLineChart();
    private Graphics graphics = null;
    private Graphics2D g2d = null;
    private GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private GraphicsDevice gd = this.ge.getDefaultScreenDevice();
    private GraphicsConfiguration gc = this.gd.getDefaultConfiguration();
    private BufferedImage bi = this.gc.createCompatibleImage(801, 601);
    private JButton btnClear;
    private JButton btnCollect;
    private JButton btnDataPoint;
    private JButton btnSelectFile;
    private JButton btnSelectFile1;
    private JDialog dialogLogData;
    private JCheckBoxMenuItem historyViewMenuItem;
    private JButton jButton1;
    private JButton jButtonApplyHistoryDuration;
    private JButton jButtonResetGraph;
    private JCheckBoxMenuItem jCheckBoxAutoScaleHistory;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLayeredPane jLayeredPane2;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPopupMenu.Separator jSeparator1;
    private JTextField jTextFieldHistoryDuration;
    private JLabel lblCalIndex;
    private JLabel lblCalSN;
    private JLabel lblConfigIndex;
    private JLabel lblConfigName;
    private JLabel lblFTSeq;
    private JLabel lblForceUnits;
    private JLabel lblFx;
    private JLabel lblFy;
    private JLabel lblFz;
    private JLabel lblRDTSeq;
    private JLabel lblStatus;
    private JLabel lblTorqueUnits;
    private JLabel lblTx;
    private JLabel lblTy;
    private JLabel lblTz;
    private JList lstErrors;
    private JMenu menuDataLog;
    private JProgressBar progFx;
    private JProgressBar progFy;
    private JProgressBar progFz;
    private JProgressBar progTx;
    private JProgressBar progTy;
    private JProgressBar progTz;
    private JScrollPane scrollErrors;
    private JPanel standardPanel;
    private JCheckBoxMenuItem standardViewMenuItem;
    private JTextField txtFileName;
    private JTextField txtFileName1;
    private JLayeredPane visualCubePane;

    private String dataCollectionLine(NetFTRDTPacket nftrdtp) {
        String outputString = "\"0x" + Integer.toHexString(nftrdtp.getStatus()) + "\",\"" + nftrdtp.getRDTSequence() + "\",\"" + nftrdtp.getFTSequence() + "\",\"" + (double)nftrdtp.getFx() / this.m_daftCountsPerUnit[0] + "\",\"" + (double)nftrdtp.getFy() / this.m_daftCountsPerUnit[1] + "\",\"" + (double)nftrdtp.getFz() / this.m_daftCountsPerUnit[2] + "\",\"" + (double)nftrdtp.getTx() / this.m_daftCountsPerUnit[3] + "\",\"" + (double)nftrdtp.getTy() / this.m_daftCountsPerUnit[4] + "\",\"" + (double)nftrdtp.getTz() / this.m_daftCountsPerUnit[5] + "\",\"" + DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()) + "\"";
        return outputString;
    }

    public NetFTSampleGUI() {
        this.initComponents();
        this.loadSettings();
        this.m_ftvc = new FTVisualizationCube();
        this.getContentPane().add(this.m_ftvc);
        this.visualCubePane.setLayout(new BorderLayout(0, 0));
        this.visualCubePane.add((Component)this.m_ftvc, "Center");
        this.m_ftvc.setYaw(90.0);
        this.m_ftvc.setPitch(20.0);
        this.m_ftvc.setRoll(70.0);
        this.m_dfReading = new DecimalFormat("#.000");
        this.m_lblaFTLabel = new JLabel[]{this.lblFx, this.lblFy, this.lblFz, this.lblTx, this.lblTy, this.lblTz};
        this.m_progaFTReadingBar = new JProgressBar[]{this.progFx, this.progFy, this.progFz, this.progTx, this.progTy, this.progTz};
        this.m_strSensorAddress = this.m_demoOptions.getLastIPAddress();
        URL urlIconPath = this.getClass().getResource("ati1.jpg");
        Image img = Toolkit.getDefaultToolkit().getImage(urlIconPath);
        if (null != img) {
            this.setIconImage(img);
        }
        if (this.m_demoOptions.isShowHistoryView()) {
            this.standardPanel.setVisible(false);
            this.standardViewMenuItem.setState(false);
            this.historyViewMenuItem.setState(true);
            this.jPanel1.setVisible(true);
        } else {
            this.standardPanel.setVisible(true);
            this.standardViewMenuItem.setState(true);
            this.historyViewMenuItem.setState(false);
            this.jPanel1.setVisible(false);
        }
        this.jTextFieldHistoryDuration.setText(Integer.toString(this.m_demoOptions.getHistoryDuration()));
        if (this.m_demoOptions.isAutoScaleHistory()) {
            this.jCheckBoxAutoScaleHistory.setSelected(true);
        } else {
            this.jCheckBoxAutoScaleHistory.setSelected(false);
        }
        this.drawingPanel.setArraySize(this.m_demoOptions.getHistoryDuration() * 10);
        this.saveSettings();
        this.stopAndRestartSingleReadings();
    }

    public NetFTSampleGUI(String titleString) {
        this();
        this.setTitle(titleString);
    }

    private void stopReaderThread() {
        if (null != this.m_NetFTReaderThread) {
            this.m_NetFTReaderThread.stopReading();
            this.m_NetFTReaderThread = null;
        }
    }

    private void stopAndRestartSingleReadings() {
        if (null != this.m_NetFTReaderThread) {
            this.m_NetFTReaderThread.stopReading();
            this.m_NetFTReaderThread = null;
        }
        try {
            this.m_netFT = new NetFTSensor(InetAddress.getByName(this.m_strSensorAddress));
        }
        catch (UnknownHostException uhex) {
            this.displayError("Unknown Host Exception: " + uhex.getMessage());
            return;
        }
        if (!this.readConfigurationInfo()) {
            return;
        }
        this.lblForceUnits.setText("Force Units: " + this.m_strForceUnits);
        this.lblTorqueUnits.setText("Torque Units: " + this.m_strTorqueUnits);
        this.lblCalIndex.setText("Calibration Index: " + (Integer.parseInt(this.m_strCalIndex) + 1));
        this.lblConfigIndex.setText("Config Index: " + (Integer.parseInt(this.m_strCfgIndex) + 1));
        this.lblCalSN.setText("Calibration Serial#: " + this.m_strCalSN);
        this.lblConfigName.setText("Config Name: " + this.m_strCfgName);
        try {
            this.m_cNetFTSlowSocket = this.m_netFT.initLowSpeedData();
        }
        catch (SocketException sexc) {
            this.displayError("SocketException: " + sexc.getMessage());
        }
        catch (IOException iexc) {
            this.displayError("IOException: " + iexc.getMessage());
        }
        this.StartNetFTReaderThread();
    }

    private void StartNetFTReaderThread() {
        this.m_NetFTReaderThread = new NetFTReaderThread(this.m_netFT, this);
        this.m_NetFTReaderThread.start();
    }

    private String readWebPageText(String strUrlSuffix) throws MalformedURLException, IOException {
        String strCurLine;
        String strURL = "http://" + this.m_strSensorAddress + "/" + strUrlSuffix;
        BufferedReader cBufferedReader = new BufferedReader(new InputStreamReader(new URL(strURL).openConnection().getInputStream()));
        String strPageText = "";
        while (null != (strCurLine = cBufferedReader.readLine())) {
            strPageText = strPageText + strCurLine;
        }
        return strPageText;
    }

    private String readNetFTAPI(int index) {
        try {
            String strXML = this.readWebPageText("netftapi2.xml?index=" + index);
            return strXML;
        }
        catch (Exception e) {
            return "";
        }
    }

    private String readNetFTCalAPI(int index) {
        try {
            String strXML = this.readWebPageText("netftcalapi.xml?index=" + index);
            return strXML;
        }
        catch (Exception e) {
            return "";
        }
    }

    private int findActiveCFG(String xmlText) {
        String[] strret = xmlText.split("<setcfgsel>");
        String[] strret2 = strret[1].split("</setcfgsel>");
        int activeConfig = Integer.parseInt(strret2[0]);
        return activeConfig;
    }

    private boolean readConfigurationInfo() {
        try {
            String mDoc = this.readNetFTAPI(0);
            int activeConfig = this.findActiveCFG(mDoc);
            mDoc = this.readNetFTAPI(activeConfig);
            this.m_strCfgIndex = "" + activeConfig;
            String[] parseStep1 = mDoc.split("<cfgcalsel>");
            String[] parseStep2 = parseStep1[1].split("</cfgcalsel>");
            String mCal = this.readNetFTCalAPI(Integer.parseInt(parseStep2[0]));
            this.m_strCalIndex = parseStep2[0];
            parseStep1 = mCal.split("<calsn>");
            parseStep2 = parseStep1[1].split("</calsn>");
            this.m_strCalSN = parseStep2[0];
            mDoc = this.readNetFTAPI(activeConfig);
            parseStep1 = mDoc.split("<cfgnam>");
            parseStep2 = parseStep1[1].split("</cfgnam>");
            this.m_strCfgName = parseStep2[0];
            parseStep1 = mDoc.split("<cfgcpf>");
            parseStep2 = parseStep1[1].split("</cfgcpf>");
            this.setCountsPerForce(Double.parseDouble(parseStep2[0]));
            parseStep1 = mDoc.split("<cfgcpt>");
            parseStep2 = parseStep1[1].split("</cfgcpt>");
            this.setCountsPerTorque(Double.parseDouble(parseStep2[0]));
            parseStep1 = mDoc.split("<comrdtrate>");
            parseStep2 = parseStep1[1].split("</comrdtrate>");
            this.m_iRDTSampleRate = Integer.parseInt(parseStep2[0]);
            parseStep1 = mDoc.split("<scfgfu>");
            parseStep2 = parseStep1[1].split("</scfgfu>");
            this.m_strForceUnits = parseStep2[0];
            parseStep1 = mDoc.split("<scfgtu>");
            parseStep2 = parseStep1[1].split("</scfgtu>");
            this.m_strTorqueUnits = parseStep2[0];
            parseStep1 = mDoc.split("<cfgmr>");
            parseStep2 = parseStep1[1].split("</cfgmr>");
            String[] asRatings = parseStep2[0].split(";");
            for (int i = 0; i < asRatings.length; ++i) {
                this.m_daftMaxes[i] = Double.parseDouble(asRatings[i]);
                if (0.0 != this.m_daftMaxes[i]) continue;
                this.m_daftMaxes[i] = 32768.0;
            }
            this.m_ftvc.setMaxForce(this.m_daftMaxes[2]);
            this.m_ftvc.setMaxTorque(this.m_daftMaxes[5]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void setCountsPerForce(double counts) {
        double dCountsPerForce = counts;
        if (0.0 == dCountsPerForce) {
            dCountsPerForce = 1.0;
            this.displayError("Read a counts per force value of 0, setting it to 1 instead.");
        }
        for (int i = 0; i < 3; ++i) {
            this.m_daftCountsPerUnit[i] = dCountsPerForce;
        }
    }

    private void setCountsPerTorque(double counts) {
        double dCountsPerTorque = counts;
        if (0.0 == dCountsPerTorque) {
            dCountsPerTorque = 1.0;
            this.displayError("Read a counts per torque value of 0, setting it to 1 instead.");
        }
        for (int i = 0; i < 3; ++i) {
            this.m_daftCountsPerUnit[i + 3] = dCountsPerTorque;
        }
    }

    private String subStringBetween(String strSearchText, String strPrefix, String strSuffix) {
        int iStartIndex = strSearchText.indexOf(strPrefix) + strPrefix.length();
        int iSuffixIndex = strSearchText.indexOf(strSuffix, iStartIndex);
        return strSearchText.substring(iStartIndex, iSuffixIndex);
    }

    private void loadSettings() {
        this.m_demoOptions = null;
        try {
            FileInputStream fis = new FileInputStream(this.m_optionsFileLocation);
            BufferedInputStream bis = new BufferedInputStream(fis);
            XMLDecoder xmlDecoder = new XMLDecoder(bis);
            this.m_demoOptions = (NetFTOptions)xmlDecoder.readObject();
            xmlDecoder.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Options file not found, using default settings.");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (this.m_demoOptions == null) {
            this.m_demoOptions = new NetFTOptions();
        }
    }

    private void saveSettings() {
        try {
            FileOutputStream fos = new FileOutputStream(this.m_optionsFileLocation);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            XMLEncoder e = new XMLEncoder(bos);
            e.writeObject(this.m_demoOptions);
            e.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void initComponents() {
        this.dialogLogData = new JDialog();
        this.btnCollect = new JButton();
        this.txtFileName1 = new JTextField();
        this.btnSelectFile1 = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.lblStatus = new JLabel();
        this.lblFx = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblFy = new JLabel();
        this.jLabel6 = new JLabel();
        this.lblTx = new JLabel();
        this.lblFz = new JLabel();
        this.jLabel5 = new JLabel();
        this.lblTz = new JLabel();
        this.lblTy = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel7 = new JLabel();
        this.lblRDTSeq = new JLabel();
        this.jLabel8 = new JLabel();
        this.lblFTSeq = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jTextFieldHistoryDuration = new JTextField();
        this.jButtonApplyHistoryDuration = new JButton();
        this.jButtonResetGraph = new JButton();
        this.jLayeredPane2 = new JLayeredPane();
        this.standardPanel = new JPanel();
        this.progTz = new JProgressBar();
        this.progFz = new JProgressBar();
        this.progTx = new JProgressBar();
        this.progTy = new JProgressBar();
        this.progFy = new JProgressBar();
        this.progFx = new JProgressBar();
        this.jPanel2 = new JPanel();
        this.lblConfigName = new JLabel();
        this.btnSelectFile = new JButton();
        this.jLabel10 = new JLabel();
        this.scrollErrors = new JScrollPane();
        this.lstErrors = new JList();
        this.lstErrors.setModel(new DefaultListModel());
        this.lblCalIndex = new JLabel();
        this.txtFileName = new JTextField();
        this.lblCalSN = new JLabel();
        this.btnClear = new JButton();
        this.jButton1 = new JButton();
        this.lblForceUnits = new JLabel();
        this.lblTorqueUnits = new JLabel();
        this.lblConfigIndex = new JLabel();
        this.btnDataPoint = new JButton();
        this.visualCubePane = new JLayeredPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu2 = new JMenu();
        this.standardViewMenuItem = new JCheckBoxMenuItem();
        this.historyViewMenuItem = new JCheckBoxMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jCheckBoxAutoScaleHistory = new JCheckBoxMenuItem();
        this.menuDataLog = new JMenu();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.dialogLogData.setMinimumSize(new Dimension(230, 120));
        this.dialogLogData.getContentPane().setLayout(null);
        this.btnCollect.setText("Collect Streaming");
        this.btnCollect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.btnCollectActionPerformed(evt);
            }
        });
        this.dialogLogData.getContentPane().add(this.btnCollect);
        this.btnCollect.setBounds(10, 40, 160, 23);
        this.txtFileName1.setText("<please select a file>");
        this.dialogLogData.getContentPane().add(this.txtFileName1);
        this.txtFileName1.setBounds(10, 10, 128, 20);
        this.btnSelectFile1.setText("...");
        this.btnSelectFile1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.btnSelectFile1ActionPerformed(evt);
            }
        });
        this.dialogLogData.getContentPane().add(this.btnSelectFile1);
        this.btnSelectFile1.setBounds(140, 10, 31, 20);
        this.setDefaultCloseOperation(3);
        this.setTitle("ATI Industrial Automation Net F/T Demo");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("ati1.jpg")));
        this.setMinimumSize(new Dimension(636, 780));
        this.setPreferredSize(new Dimension(636, 780));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NetFTSampleGUI.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                NetFTSampleGUI.this.formComponentResized(evt);
            }
        });
        this.getContentPane().setLayout(null);
        this.jPanel3.setLayout(null);
        this.jPanel4.setLayout(null);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Tx");
        this.jPanel4.add(this.jLabel4);
        this.jLabel4.setBounds(0, 135, 40, 14);
        this.lblStatus.setHorizontalAlignment(4);
        this.lblStatus.setText("0");
        this.lblStatus.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel4.add(this.lblStatus);
        this.lblStatus.setBounds(50, 11, 100, 18);
        this.lblFx.setHorizontalAlignment(4);
        this.lblFx.setText("0");
        this.lblFx.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel4.add(this.lblFx);
        this.lblFx.setBounds(50, 47, 100, 18);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Fz");
        this.jPanel4.add(this.jLabel3);
        this.jLabel3.setBounds(0, 105, 40, 14);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Fy");
        this.jPanel4.add(this.jLabel2);
        this.jLabel2.setBounds(0, 77, 40, 14);
        this.lblFy.setHorizontalAlignment(4);
        this.lblFy.setText("0");
        this.lblFy.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel4.add(this.lblFy);
        this.lblFy.setBounds(50, 77, 100, 18);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Tz");
        this.jPanel4.add(this.jLabel6);
        this.jLabel6.setBounds(0, 195, 40, 14);
        this.lblTx.setHorizontalAlignment(4);
        this.lblTx.setText("0");
        this.lblTx.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel4.add(this.lblTx);
        this.lblTx.setBounds(50, 137, 100, 18);
        this.lblFz.setHorizontalAlignment(4);
        this.lblFz.setText("0");
        this.lblFz.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel4.add(this.lblFz);
        this.lblFz.setBounds(50, 107, 100, 18);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Ty");
        this.jPanel4.add(this.jLabel5);
        this.jLabel5.setBounds(0, 165, 40, 14);
        this.lblTz.setHorizontalAlignment(4);
        this.lblTz.setText("0");
        this.lblTz.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel4.add(this.lblTz);
        this.lblTz.setBounds(50, 197, 100, 18);
        this.lblTy.setHorizontalAlignment(4);
        this.lblTy.setText("0");
        this.lblTy.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel4.add(this.lblTy);
        this.lblTy.setBounds(50, 167, 100, 18);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Fx");
        this.jPanel4.add(this.jLabel1);
        this.jLabel1.setBounds(0, 47, 40, 14);
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Status");
        this.jPanel4.add(this.jLabel9);
        this.jLabel9.setBounds(0, 13, 40, 14);
        this.jPanel3.add(this.jPanel4);
        this.jPanel4.setBounds(10, 0, 160, 220);
        this.jPanel5.setLayout(null);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("FTSeq");
        this.jPanel5.add(this.jLabel7);
        this.jLabel7.setBounds(168, 13, 40, 14);
        this.lblRDTSeq.setHorizontalAlignment(4);
        this.lblRDTSeq.setText("0");
        this.lblRDTSeq.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel5.add(this.lblRDTSeq);
        this.lblRDTSeq.setBounds(62, 11, 100, 18);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("RDTSeq");
        this.jPanel5.add(this.jLabel8);
        this.jLabel8.setBounds(0, 13, 56, 14);
        this.lblFTSeq.setHorizontalAlignment(4);
        this.lblFTSeq.setText("0");
        this.lblFTSeq.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel5.add(this.lblFTSeq);
        this.lblFTSeq.setBounds(214, 11, 100, 18);
        this.jPanel3.add(this.jPanel5);
        this.jPanel5.setBounds(176, 0, 370, 33);
        this.jPanel1.setMinimumSize(new Dimension(100, 30));
        this.jPanel1.setLayout(null);
        this.jLabel11.setText("<html>History<br>Duration (sec.):");
        this.jPanel1.add(this.jLabel11);
        this.jLabel11.setBounds(0, 0, 90, 30);
        this.jTextFieldHistoryDuration.setText("5");
        this.jTextFieldHistoryDuration.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NetFTSampleGUI.this.jTextFieldHistoryDurationKeyTyped(evt);
            }
        });
        this.jPanel1.add(this.jTextFieldHistoryDuration);
        this.jTextFieldHistoryDuration.setBounds(90, 10, 30, 20);
        this.jButtonApplyHistoryDuration.setText("Apply");
        this.jButtonApplyHistoryDuration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.jButtonApplyHistoryDurationActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonApplyHistoryDuration);
        this.jButtonApplyHistoryDuration.setBounds(0, 40, 70, 23);
        this.jButtonResetGraph.setText("Reset Graph");
        this.jButtonResetGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.jButtonResetGraphActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonResetGraph);
        this.jButtonResetGraph.setBounds(0, 70, 110, 23);
        this.jPanel3.add(this.jPanel1);
        this.jPanel1.setBounds(10, 232, 150, 109);
        this.standardPanel.setMaximumSize(new Dimension(330, 190));
        this.standardPanel.setPreferredSize(new Dimension(330, 190));
        this.standardPanel.setLayout(null);
        this.progTz.setMaximumSize(null);
        this.progTz.setMinimumSize(new Dimension(10, 18));
        this.progTz.setPreferredSize(new Dimension(170, 18));
        this.standardPanel.add(this.progTz);
        this.progTz.setBounds(10, 158, 400, 18);
        this.progFz.setMaximumSize(null);
        this.progFz.setMinimumSize(new Dimension(10, 18));
        this.progFz.setPreferredSize(new Dimension(146, 18));
        this.standardPanel.add(this.progFz);
        this.progFz.setBounds(10, 68, 400, 18);
        this.progTx.setMaximumSize(null);
        this.progTx.setMinimumSize(new Dimension(10, 18));
        this.progTx.setPreferredSize(new Dimension(146, 18));
        this.standardPanel.add(this.progTx);
        this.progTx.setBounds(10, 98, 400, 18);
        this.progTy.setMaximumSize(null);
        this.progTy.setMinimumSize(new Dimension(10, 18));
        this.progTy.setPreferredSize(new Dimension(146, 18));
        this.standardPanel.add(this.progTy);
        this.progTy.setBounds(10, 128, 400, 18);
        this.progFy.setMaximumSize(null);
        this.progFy.setMinimumSize(new Dimension(10, 18));
        this.progFy.setPreferredSize(new Dimension(146, 18));
        this.standardPanel.add(this.progFy);
        this.progFy.setBounds(10, 38, 400, 18);
        this.progFx.setMaximumSize(null);
        this.progFx.setMinimumSize(new Dimension(10, 18));
        this.progFx.setPreferredSize(new Dimension(146, 18));
        this.standardPanel.add(this.progFx);
        this.progFx.setBounds(10, 8, 400, 18);
        this.standardPanel.setBounds(0, 0, 420, 210);
        this.jLayeredPane2.add((Component)this.standardPanel, JLayeredPane.DEFAULT_LAYER);
        this.jPanel3.add(this.jLayeredPane2);
        this.jLayeredPane2.setBounds(176, 39, 434, 250);
        this.getContentPane().add(this.jPanel3);
        this.jPanel3.setBounds(0, 0, 620, 380);
        this.jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, 320));
        this.jPanel2.setMinimumSize(new Dimension(620, 320));
        this.jPanel2.setName("");
        this.jPanel2.setLayout(null);
        this.lblConfigName.setText("Config Name: ?");
        this.jPanel2.add(this.lblConfigName);
        this.lblConfigName.setBounds(10, 95, 520, 14);
        this.btnSelectFile.setText("...");
        this.btnSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.btnSelectFileActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnSelectFile);
        this.btnSelectFile.setBounds(144, 155, 31, 20);
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Errors");
        this.jPanel2.add(this.jLabel10);
        this.jLabel10.setBounds(10, 210, 60, 14);
        this.scrollErrors.setOpaque(false);
        this.scrollErrors.setPreferredSize(new Dimension(100, 100));
        this.lstErrors.setForeground(new Color(255, 0, 0));
        this.scrollErrors.setViewportView(this.lstErrors);
        this.jPanel2.add(this.scrollErrors);
        this.scrollErrors.setBounds(10, 230, 580, 90);
        this.lblCalIndex.setText("Calibration Index: ?");
        this.jPanel2.add(this.lblCalIndex);
        this.lblCalIndex.setBounds(10, 115, 490, 14);
        this.txtFileName.setText("<please select a file>");
        this.jPanel2.add(this.txtFileName);
        this.txtFileName.setBounds(10, 155, 128, 20);
        this.lblCalSN.setText("Calibration Serial#: ?");
        this.jPanel2.add(this.lblCalSN);
        this.lblCalSN.setBounds(10, 135, 480, 14);
        this.btnClear.setText("Clear Errors");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.btnClearPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnClear);
        this.btnClear.setBounds(500, 180, 110, 23);
        this.jButton1.setText("Bias");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jButton1.setBounds(10, 6, 70, 23);
        this.lblForceUnits.setText("Force units: ?");
        this.jPanel2.add(this.lblForceUnits);
        this.lblForceUnits.setBounds(10, 35, 470, 14);
        this.lblTorqueUnits.setText("Torque units: ?");
        this.jPanel2.add(this.lblTorqueUnits);
        this.lblTorqueUnits.setBounds(10, 55, 470, 14);
        this.lblConfigIndex.setText("Config Index: ?");
        this.jPanel2.add(this.lblConfigIndex);
        this.lblConfigIndex.setBounds(10, 75, 508, 14);
        this.btnDataPoint.setText("Collect Data Point");
        this.btnDataPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.btnDataPoint(evt);
            }
        });
        this.jPanel2.add(this.btnDataPoint);
        this.btnDataPoint.setBounds(10, 180, 140, 23);
        this.getContentPane().add(this.jPanel2);
        this.jPanel2.setBounds(0, 390, 620, 350);
        this.visualCubePane.setDoubleBuffered(true);
        this.getContentPane().add(this.visualCubePane);
        this.visualCubePane.setBounds(230, 260, 290, 290);
        this.jMenu2.setText("View");
        this.standardViewMenuItem.setSelected(true);
        this.standardViewMenuItem.setText("Standard View");
        this.standardViewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.standardViewMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.standardViewMenuItem);
        this.historyViewMenuItem.setActionCommand("History View");
        this.historyViewMenuItem.setLabel("History View");
        this.historyViewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.historyViewMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.historyViewMenuItem);
        this.jMenu2.add(this.jSeparator1);
        this.jCheckBoxAutoScaleHistory.setSelected(true);
        this.jCheckBoxAutoScaleHistory.setText("Auto Scale History Chart");
        this.jCheckBoxAutoScaleHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.jCheckBoxAutoScaleHistoryActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jCheckBoxAutoScaleHistory);
        this.jMenuBar1.add(this.jMenu2);
        this.menuDataLog.setText("Log Data");
        this.menuDataLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NetFTSampleGUI.this.menuDataLogMouseClicked(evt);
            }
        });
        this.jMenuBar1.add(this.menuDataLog);
        this.jMenu1.setText("Help");
        this.jMenu1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.jMenu1ActionPerformed(evt);
            }
        });
        this.jMenuItem1.setText("About...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetFTSampleGUI.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.getAccessibleContext().setAccessibleDescription("");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 636) / 2, (screenSize.height - 782) / 2, 636, 782);
    }

    private void jMenu1ActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        JFrame fAbout = new JFrame("About ATINetFT Demo");
        URL urlIconPath = this.getClass().getResource("ati1.jpg");
        Image img = Toolkit.getDefaultToolkit().getImage(urlIconPath);
        if (null != img) {
            fAbout.setIconImage(img);
        }
        fAbout.setLayout(null);
        int iLabelXPosition = 10;
        this.addLabelToFrame("<HTML><U>ATI Net F/T Java Software</U>", fAbout, 10, 0, 200, 20);
        this.addLabelToFrame("UI Version " + NetFTSampleGUI.getVersion(), fAbout, 10, 20, 200, 20);
        this.addLabelToFrame("Net F/T Interface Version " + NetFTSensor.getVersion(), fAbout, 10, 40, 200, 20);
        this.addLabelToFrame("Copyright 2013", fAbout, 10, 80, 200, 20);
        this.addLabelToFrame("by ATI Industrial Automation, Inc.", fAbout, 10, 100, 200, 20);
        this.addLabelToFrame("All rights reserved", fAbout, 10, 120, 200, 20);
        this.addLabelToFrame("http://www.ati-ia.com", fAbout, 10, 140, 200, 20);
        fAbout.setBounds(100, 100, 260, 200);
        fAbout.setResizable(false);
        fAbout.setVisible(true);
    }

    private JLabel addLabelToFrame(String strText, JFrame jfr, int x, int y, int length, int height) {
        JLabel jlbl = new JLabel(strText);
        this.addComponentToFrame(jlbl, jfr, x, y, length, height);
        return jlbl;
    }

    private void addComponentToFrame(Component cmp, JFrame jfr, int x, int y, int length, int height) {
        jfr.getContentPane().add(cmp);
        cmp.setBounds(x, y, length, height);
    }

    private void btnSelectFileActionPerformed(ActionEvent evt) {
        FileDialog cDataFileChooser = new FileDialog((Frame)this, "Choose File to Save Data to", 0);
        cDataFileChooser.setVisible(true);
        if (null == cDataFileChooser.getFile()) {
            return;
        }
        this.txtFileName.setText(cDataFileChooser.getDirectory() + cDataFileChooser.getFile());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.stopReaderThread();
        this.m_cNetFTSlowSocket.close();
        try {
            if (this.m_bDoingHighSpeedCollection) {
                this.m_netFT.stopDataCollection(this.m_cNetFTFastSocket);
            }
        }
        catch (IOException ioexc) {
            JOptionPane.showMessageDialog(this, "An IOException has occurred: " + ioexc.getMessage(), "IOException", 0);
        }
        this.saveSettings();
    }

    private void btnClearPerformed(ActionEvent evt) {
        this.lstErrors.setModel(new DefaultListModel());
    }

    private void standardViewMenuItemActionPerformed(ActionEvent evt) {
        this.standardViewMenuItem.setState(true);
        this.historyViewMenuItem.setState(false);
        this.standardPanel.setVisible(true);
        this.jPanel1.setVisible(false);
        this.m_demoOptions.setShowHistoryView(false);
        this.saveSettings();
    }

    private void historyViewMenuItemActionPerformed(ActionEvent evt) {
        this.standardViewMenuItem.setState(false);
        this.historyViewMenuItem.setState(true);
        this.standardPanel.setVisible(false);
        this.jPanel1.setVisible(true);
        this.m_demoOptions.setShowHistoryView(true);
        this.saveSettings();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            this.m_netFT.tare();
        }
        catch (SocketException sexc) {
            this.displayError("SocketException: " + sexc.getMessage());
        }
        catch (IOException ioexc) {
            this.displayError("IOException: " + ioexc.getMessage());
        }
    }

    private void jButtonApplyHistoryDurationActionPerformed(ActionEvent evt) {
        this.ApplyHistoryDurationChange();
    }

    private void jButtonResetGraphActionPerformed(ActionEvent evt) {
        this.drawingPanel.setArraySize(10 * this.m_demoOptions.getHistoryDuration());
    }

    private void jCheckBoxAutoScaleHistoryActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxAutoScaleHistory.isSelected()) {
            this.m_demoOptions.setAutoScaleHistory(true);
        } else {
            this.m_demoOptions.setAutoScaleHistory(false);
        }
        this.saveSettings();
    }

    private void jTextFieldHistoryDurationKeyTyped(KeyEvent evt) {
        String userInput = this.jTextFieldHistoryDuration.getText().trim();
        String selectedText = null;
        if (evt.getKeyChar() == '\n') {
            this.ApplyHistoryDurationChange();
            return;
        }
        try {
            selectedText = this.jTextFieldHistoryDuration.getSelectedText().trim();
            if (Character.isDigit(evt.getKeyChar())) {
                userInput.replace(selectedText, "" + evt.getKeyChar());
            } else {
                userInput.replace(selectedText, "");
            }
            return;
        }
        catch (Exception e) {
            char newChar = evt.getKeyChar();
            if (Character.isDigit(newChar) && userInput.length() < 3) {
                userInput = userInput + newChar;
            }
            this.jTextFieldHistoryDuration.setText(userInput);
            evt.consume();
            return;
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.m_lastWindowWidth != this.getWidth() || this.m_lastWindowHeight != this.getHeight()) {
            int width = this.m_lastWindowWidth = this.getWidth();
            int height = this.m_lastWindowHeight = this.getHeight();
            int minWidth = this.getMinimumSize().width;
            int minHeight = this.getMinimumSize().height;
            int jPanel3Width = width;
            int jPanel3Height = 380;
            this.jPanel3.setBounds(0, 0, jPanel3Width, jPanel3Height);
            int jLayeredPane2Width = jPanel3Width - 206;
            int jLayeredPane2Height = jPanel3Height - 130;
            this.jLayeredPane2.setBounds(176, 39, jLayeredPane2Width, jLayeredPane2Height);
            int jHistoryPaneWidth = jLayeredPane2Width;
            int jHistoryPaneHeight = jLayeredPane2Height - 47;
            this.bi = this.gc.createCompatibleImage(jHistoryPaneWidth + 1, jHistoryPaneHeight + 1);
            int standardPanelWidth = jLayeredPane2Width;
            int standardPanelHeight = jLayeredPane2Height - 50;
            this.standardPanel.setBounds(0, 0, standardPanelWidth, standardPanelHeight);
            int progressBarWidth = standardPanelWidth - 20;
            int progressBarHeight = 18;
            this.progFx.setBounds(10, 8, progressBarWidth, progressBarHeight);
            this.progFy.setBounds(10, 38, progressBarWidth, progressBarHeight);
            this.progFz.setBounds(10, 68, progressBarWidth, progressBarHeight);
            this.progTx.setBounds(10, 98, progressBarWidth, progressBarHeight);
            this.progTy.setBounds(10, 128, progressBarWidth, progressBarHeight);
            this.progTz.setBounds(10, 158, progressBarWidth, progressBarHeight);
            int jPanel2Width = width - 20;
            int jPanel2Height = 380;
            this.jPanel2.setBounds(0, height - 380, jPanel2Width, jPanel2Height);
            int scrollErrorsWidth = jPanel2Width - 15;
            int scrollErrorsHeight = 75;
            this.scrollErrors.setBounds(10, jPanel2Height - 150, scrollErrorsWidth, scrollErrorsHeight);
            int btnClearWidth = 130;
            int btnClearHeight = 23;
            this.btnClear.setBounds(jPanel2Width - btnClearWidth - 7, 190, btnClearWidth, btnClearHeight);
            int visCubeNormSize = 330;
            int cubeExpansionSize = width - minWidth;
            if (height - minHeight < cubeExpansionSize) {
                cubeExpansionSize = height - minHeight;
            }
            this.visualCubePane.setBounds(180 + (width - minWidth) / 3, 240, visCubeNormSize + cubeExpansionSize, visCubeNormSize + cubeExpansionSize);
        }
    }

    private void btnDataPoint(ActionEvent evt) {
        try {
            this.m_cDataWriter = new PrintWriter(new FileWriter(this.txtFileName.getText(), true));
            this.m_recordNextCollection = true;
        }
        catch (IOException cIOExc) {
            this.displayError("IOException: " + cIOExc.getMessage());
            this.m_recordNextCollection = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnCollectActionPerformed(ActionEvent evt) {
        System.out.println("Collect button pressed.");
        NetFTSensor netFTSensor = this.m_netFT;
        synchronized (netFTSensor) {
            if (this.m_bDoingHighSpeedCollection) {
                this.btnCollect.setText("Start Collecting");
                this.m_bDoingHighSpeedCollection = false;
                try {
                    this.m_netFT.stopDataCollection(this.m_cNetFTFastSocket);
                    this.m_cDataWriter.close();
                }
                catch (IOException cIOexc) {
                    this.displayError("IOException: " + cIOexc.getMessage());
                }
                return;
            }
        }
        try {
            this.m_cDataWriter = new PrintWriter(new FileWriter(this.txtFileName1.getText()));
            Calendar curTime = Calendar.getInstance();
            String dateTimeString = DateFormat.getDateTimeInstance(3, 3).format(curTime.getTime());
            this.m_cDataWriter.println("Start Time: " + dateTimeString);
            this.m_cDataWriter.println("RDT Sample Rate: " + this.m_iRDTSampleRate);
            this.m_cDataWriter.println("\"PLEASE NOTE: The sample rate is read from the Net F/T when the program starts.  If you have changed the sample rate since the program started, this will be incorrect.\"");
            this.m_cDataWriter.println(this.lblForceUnits.getText());
            this.m_cDataWriter.println("Counts per Unit Force: " + this.m_daftCountsPerUnit[0]);
            this.m_cDataWriter.println(this.lblTorqueUnits.getText());
            this.m_cDataWriter.println("Counts per Unit Torque: " + this.m_daftCountsPerUnit[3]);
            this.m_cDataWriter.println("Status (hex), RDT Sequence, F/T Sequence, Fx, Fy, Fz, Tx, Ty, Tz, Time");
        }
        catch (IOException cIOExc) {
            this.displayError("IOException: " + cIOExc.getMessage());
            this.m_bDoingHighSpeedCollection = false;
            return;
        }
        this.btnCollect.setText("Stop Collecting");
        try {
            this.m_cNetFTFastSocket = this.m_netFT.startHighSpeedDataCollection(0);
            this.m_bDoingHighSpeedCollection = true;
        }
        catch (SocketException cSexc) {
            this.displayError("SocketException: " + cSexc.getMessage());
        }
        catch (IOException cIOexc) {
            this.displayError("IOException" + cIOexc.getMessage());
        }
    }

    private void btnSelectFile1ActionPerformed(ActionEvent evt) {
        FileDialog cDataFileChooser = new FileDialog((Frame)this, "Choose File to Save Data to", 1);
        cDataFileChooser.setVisible(true);
        if (null == cDataFileChooser.getFile()) {
            return;
        }
        this.txtFileName1.setText(cDataFileChooser.getDirectory() + cDataFileChooser.getFile());
    }

    private void menuDataLogMouseClicked(MouseEvent evt) {
        if (this.dialogLogData.isVisible()) {
            this.dialogLogData.setVisible(false);
            return;
        }
        this.dialogLogData.setVisible(true);
        this.dialogLogData.setLocation(this.getLocationOnScreen().x, this.getLocationOnScreen().y + 50);
        this.dialogLogData.toFront();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new NetFTDiscoveryGUI().setVisible(true);
            }
        });
    }

    public void displayError(String errDesc) {
        UpdateErrorDisplay updateDisplay = new UpdateErrorDisplay(errDesc);
        SwingUtilities.invokeLater(updateDisplay);
    }

    public void displayFTData(NetFTRDTPacket displayRDT) {
        UpdateFTDisplay updater = new UpdateFTDisplay(displayRDT);
        SwingUtilities.invokeLater(updater);
    }

    private void GetFTValues() {
        try {
            NetFTRDTPacket rdtData = this.m_netFT.readLowSpeedData(this.m_cNetFTSlowSocket);
        }
        catch (SocketException sexc) {
            this.displayError("SocketException: " + sexc.getMessage());
        }
        catch (IOException iexc) {
            this.displayError("IOException: " + iexc.getMessage());
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    private void ApplyHistoryDurationChange() {
        String userInput = this.jTextFieldHistoryDuration.getText().trim();
        if (!userInput.matches("^([0-9]|[0-9][0-9]|[0-9][0-9][0-9])$")) {
            this.jTextFieldHistoryDuration.setText("");
        } else {
            int historyDuration = Integer.parseInt(userInput);
            if (historyDuration < 2) {
                historyDuration = 2;
            } else if (historyDuration > this.m_maxHistoryDuration) {
                historyDuration = this.m_maxHistoryDuration;
            }
            this.jTextFieldHistoryDuration.setText(Integer.toString(historyDuration));
            this.m_demoOptions.setHistoryDuration(historyDuration);
            this.drawingPanel.setArraySize(historyDuration * 10);
        }
    }

    private class UpdateFTDisplay
    implements Runnable {
        private NetFTRDTPacket m_rdtPacket;

        public UpdateFTDisplay(NetFTRDTPacket setRDTPacket) {
            this.m_rdtPacket = setRDTPacket;
        }

        @Override
        public void run() {
            NetFTSampleGUI.this.lblStatus.setText("0x" + String.format("%08x", this.m_rdtPacket.getStatus()));
            NetFTSampleGUI.this.lblRDTSeq.setText("" + this.m_rdtPacket.getRDTSequence());
            NetFTSampleGUI.this.lblFTSeq.setText("" + this.m_rdtPacket.getFTSequence());
            int[] ftCountsReading = this.m_rdtPacket.getFTArray();
            double[] ftRealReading = new double[6];
            for (int i = 0; i < 6; ++i) {
                ftRealReading[i] = (double)ftCountsReading[i] / NetFTSampleGUI.this.m_daftCountsPerUnit[i];
                NetFTSampleGUI.this.m_lblaFTLabel[i].setText(NetFTSampleGUI.this.m_dfReading.format(ftRealReading[i]));
                if (!NetFTSampleGUI.this.standardViewMenuItem.getState()) continue;
                if (ftRealReading[i] < 0.0) {
                    NetFTSampleGUI.this.m_progaFTReadingBar[i].setForeground(NEGATIVE_COLOR);
                } else {
                    NetFTSampleGUI.this.m_progaFTReadingBar[i].setForeground(POSITIVE_COLOR);
                }
                NetFTSampleGUI.this.m_progaFTReadingBar[i].setValue((int)Math.abs(ftRealReading[i] / NetFTSampleGUI.this.m_daftMaxes[i] * 100.0));
            }
            if (NetFTSampleGUI.this.historyViewMenuItem.getState()) {
                double max = 0.0;
                for (int j = 0; j < 6; ++j) {
                    if (!(NetFTSampleGUI.this.m_daftMaxes[j] > max)) continue;
                    max = NetFTSampleGUI.this.m_daftMaxes[j];
                }
                if (NetFTSampleGUI.this.m_demoOptions.isAutoScaleHistory()) {
                    NetFTSampleGUI.this.drawingPanel.setAutoscaling(true, max);
                } else {
                    NetFTSampleGUI.this.drawingPanel.setAutoscaling(false, max);
                }
                NetFTSampleGUI.this.drawingPanel.addDataPoint(ftRealReading);
                NetFTSampleGUI.this.drawingPanel.drawGraphics((JFrame)NetFTSampleGUI.this.jPanel3.getTopLevelAncestor(), NetFTSampleGUI.this.graphics, NetFTSampleGUI.this.g2d, NetFTSampleGUI.this.bi, NetFTSampleGUI.this.jLayeredPane2.getX() + NetFTSampleGUI.this.jPanel3.getX(), NetFTSampleGUI.this.jLayeredPane2.getY() + NetFTSampleGUI.this.jPanel3.getY() + 50);
            }
            NetFTSampleGUI.this.m_ftvc.setFTValues(ftRealReading);
        }
    }

    private class UpdateErrorDisplay
    implements Runnable {
        private String m_sErrDesc;

        @Override
        public void run() {
            Calendar curTime = Calendar.getInstance();
            String errString = DateFormat.getTimeInstance(2).format(curTime.getTime()) + " - " + this.m_sErrDesc;
            DefaultListModel errListModel = (DefaultListModel)NetFTSampleGUI.this.lstErrors.getModel();
            errListModel.add(0, errString);
        }

        public UpdateErrorDisplay(String setErrDesc) {
            this.m_sErrDesc = setErrDesc;
        }
    }

    private class NetFTReaderThread
    extends Thread {
        private NetFTSensor m_netFT;
        private NetFTSampleGUI m_guiParent;
        private boolean m_bKeepGoing = true;

        public NetFTReaderThread(NetFTSensor setNetFT, NetFTSampleGUI setParent) {
            this.m_netFT = setNetFT;
            this.m_guiParent = setParent;
        }

        public void stopReading() {
            this.m_bKeepGoing = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.m_bKeepGoing) {
                try {
                    NetFTRDTPacket cRDTData;
                    Thread.yield();
                    NetFTSensor netFTSensor = this.m_netFT;
                    synchronized (netFTSensor) {
                        if (NetFTSampleGUI.this.m_bDoingHighSpeedCollection) {
                            int PACKETS_TO_READ = Math.max(NetFTSampleGUI.this.m_iRDTSampleRate / 10, 1);
                            NetFTRDTPacket[] caRDTPackets = new NetFTRDTPacket[PACKETS_TO_READ];
                            caRDTPackets = this.m_netFT.readHighSpeedData(NetFTSampleGUI.this.m_cNetFTFastSocket, PACKETS_TO_READ);
                            for (int i = 0; i < PACKETS_TO_READ; ++i) {
                                NetFTSampleGUI.this.m_cDataWriter.println(NetFTSampleGUI.this.dataCollectionLine(caRDTPackets[i]));
                            }
                            cRDTData = caRDTPackets[PACKETS_TO_READ - 1];
                        } else {
                            cRDTData = this.m_netFT.readLowSpeedData(NetFTSampleGUI.this.m_cNetFTSlowSocket);
                            if (NetFTSampleGUI.this.m_recordNextCollection) {
                                NetFTSampleGUI.this.m_cDataWriter.println(this.m_guiParent.dataCollectionLine(cRDTData) + ", " + NetFTSampleGUI.this.lblForceUnits.getText() + ", " + NetFTSampleGUI.this.lblTorqueUnits.getText());
                                NetFTSampleGUI.this.m_cDataWriter.close();
                            }
                        }
                    }
                    this.m_guiParent.displayFTData(cRDTData);
                }
                catch (SocketException sexc) {
                    this.m_guiParent.displayError("Socket Exception: " + sexc.getMessage());
                }
                catch (IOException iexc) {
                    this.m_guiParent.displayError("IO Exception: " + iexc.getMessage());
                }
                try {
                    if (NetFTSampleGUI.this.m_bDoingHighSpeedCollection) continue;
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

