/*
 * NetFTDiscovery.java
 *
 * Created on May 29, 2012, 11:56:11 AM
 */

package netftsample;

import RTADiscoveryProtocol.DiscoveryClient;
import RTADiscoveryProtocol.RTADevice;
import java.awt.Toolkit;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.*;

/**
 *
 * @author fleda
 */
public class NetFTDiscoveryGUI extends javax.swing.JFrame{

    /** Creates new form NetFTDiscovery */
    private NetFTOptions m_demoOptions = null;
    private String m_optionsFileLocation = "ATINetFTDemoOptions.xml";
    private String m_tempMACAddress = null;

    public NetFTDiscoveryGUI(){
        initComponents();
        loadSettings();
        refreshDeviceList();
        
        //put last IP Address in text field
        if(m_demoOptions.getLastIPAddress() == null){
            jAddressField.setText("IP Address");
        }
        else{
            jAddressField.setText(m_demoOptions.getLastIPAddress());
        }
        
        m_tempMACAddress = m_demoOptions.getLastMACAddress();
        
        saveSettings();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane2 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        jConnectButton = new javax.swing.JButton();
        jAddressField = new javax.swing.JTextField();
        jAddressLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jDeviceList = new javax.swing.JList();
        jRefreshButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextFeedback = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        jClearMessagesButton = new javax.swing.JButton();

        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jScrollPane2.setViewportView(jTextArea1);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("ATI Industrial Automation Net F/T Demo");
        setIconImage(Toolkit.getDefaultToolkit().getImage(getClass().getResource("ati1.jpg")));
        setMinimumSize(new java.awt.Dimension(548, 275));
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jConnectButton.setText("Connect");
        jConnectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jConnectButtonActionPerformed(evt);
            }
        });

        jAddressField.setText("222.222.222.222");
        jAddressField.setToolTipText("");
        jAddressField.setMinimumSize(new java.awt.Dimension(90, 20));
        jAddressField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jAddressFieldKeyTyped(evt);
            }
        });

        jAddressLabel.setText("IP Address:");

        jDeviceList.setFont(new java.awt.Font("Courier New", 0, 11)); // NOI18N
        jDeviceList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jDeviceList.setToolTipText("");
        jDeviceList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jDeviceListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jDeviceList);

        jRefreshButton.setText("Refresh Devices");
        jRefreshButton.setMaximumSize(new java.awt.Dimension(130, 23));
        jRefreshButton.setMinimumSize(new java.awt.Dimension(130, 23));
        jRefreshButton.setPreferredSize(new java.awt.Dimension(130, 23));
        jRefreshButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRefreshButtonActionPerformed(evt);
            }
        });

        jLabel1.setText("Available devices listed below:");

        jTextFeedback.setColumns(20);
        jTextFeedback.setEditable(false);
        jTextFeedback.setRows(3);
        jScrollPane3.setViewportView(jTextFeedback);

        jLabel2.setText("Message Area:");

        jClearMessagesButton.setText("Clear Messages");
        jClearMessagesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jClearMessagesButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1)
                    .addComponent(jLabel1)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addComponent(jRefreshButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 155, Short.MAX_VALUE)
                        .addComponent(jAddressLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jAddressField, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jConnectButton))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jClearMessagesButton))
                    .addComponent(jScrollPane3))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap(22, Short.MAX_VALUE)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 194, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jConnectButton)
                    .addComponent(jAddressField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jAddressLabel)
                    .addComponent(jRefreshButton, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jClearMessagesButton)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 64, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-556)/2, (screenSize.height-407)/2, 556, 407);
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        
    }//GEN-LAST:event_formWindowClosing

    private void jDeviceListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jDeviceListValueChanged
        //grab selected IP address and put it in jAddressField
        if(jDeviceList.getSelectedValue() != null){
            String selectedItem = (String)jDeviceList.getSelectedValue();
            String subString = selectedItem.substring(3, selectedItem.indexOf(" "));
            jAddressField.setText(subString);
            //grab selected MAC address to be saved once a connection is started
            int macStartIndex = selectedItem.indexOf("M", selectedItem.indexOf(" ")) + 4;
            subString = selectedItem.substring(macStartIndex, selectedItem.indexOf(" ", selectedItem.indexOf("M")));
            m_tempMACAddress = subString;
        }
    }//GEN-LAST:event_jDeviceListValueChanged

    private void jRefreshButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRefreshButtonActionPerformed
        refreshDeviceList();
    }//GEN-LAST:event_jRefreshButtonActionPerformed

    private void jClearMessagesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jClearMessagesButtonActionPerformed
        jTextFeedback.setText("");
    }//GEN-LAST:event_jClearMessagesButtonActionPerformed

    private void jConnectButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jConnectButtonActionPerformed
        try{
            //Strict input testing for IPV4 address such as "0.0.0.0" - "255.255.255.255"
            String deviceAddress = jAddressField.getText().trim();
            String[] splitIPAddress = new String[4];
            int[] temp = new int[4];
            //Test input string length
            if(deviceAddress.length() < 16 && deviceAddress.length() > 6){
                //Count number of periods in input
                int periodCount = 0;
                for(int i = 0; i < deviceAddress.length(); i++){
                    if(deviceAddress.charAt(i) == '.') periodCount++;
                }
                if(periodCount == 3){
                    splitIPAddress = deviceAddress.split("[.]+");
                    for(int i = 0; i < splitIPAddress.length; i++){
                        temp[i] = Integer.parseInt(splitIPAddress[i]);
                        if(temp[i] > 255 || temp[i] < 0){
                            InvalidInputMessage();
                            return;
                        }
                    }
                    //String input is valid, start sample gui
                    m_demoOptions.setLastMACAddress(m_tempMACAddress);
                    m_demoOptions.setLastIPAddress(deviceAddress);
                    saveSettings();
                    //Java complains about giving a non final variable to
                    //an inner class.
                    final String deviceAddressToPassToSampleGui = deviceAddress;
                    java.awt.EventQueue.invokeLater(new Runnable() {
                        @Override
                        public void run() {
                            new NetFTSampleGUI(deviceAddressToPassToSampleGui + " - ATINetFT Demo").setVisible(true);
                        }
                    });
                    this.setVisible(false);
                }
                else InvalidInputMessage();
            }
            else InvalidInputMessage();
        }
        catch(Exception e) { InvalidInputMessage(); }
    }//GEN-LAST:event_jConnectButtonActionPerformed
    
    private void InvalidInputMessage(){
        jAddressField.setText("");
        jTextFeedback.append("Invalid IP Address.  Enter the valid IPv4 address of the device or select a device above.");
    }
    
    private void jAddressFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jAddressFieldKeyTyped
        if(!(Character.isDigit(evt.getKeyChar()) || evt.getKeyChar() == '.')){
            evt.consume();
        }
    }//GEN-LAST:event_jAddressFieldKeyTyped

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        /*java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new NetFTDiscoveryGUI().setVisible(true);
            }
        });*/
    }

    private void loadSettings(){
        //Load Settings
        m_demoOptions = null;
        
        //Read in from options file
        try{
            FileInputStream fis = new FileInputStream(m_optionsFileLocation);
            BufferedInputStream bis = new BufferedInputStream(fis);
            XMLDecoder xmlDecoder = new XMLDecoder(bis);
            m_demoOptions = (NetFTOptions)xmlDecoder.readObject();
            xmlDecoder.close();
        }
        catch(FileNotFoundException fnfe){
            System.out.println("Options file not found, using default settings.");
        }
        catch(Exception e){
         System.out.println(e);
        }

        //generate new options object and init if no file found
        if(m_demoOptions == null){
            m_demoOptions = new NetFTOptions();
        }
    }

    private void saveSettings(){
        //save to options file
        try{
            FileOutputStream fos = new FileOutputStream(m_optionsFileLocation);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            XMLEncoder e = new XMLEncoder(bos);
            e.writeObject(m_demoOptions);
            e.close();
        }
        catch(Exception e){
            System.out.println(e);
        }
    }

    private void refreshDeviceList(){
        //Handle GUI Changes
        jRefreshButton.setEnabled(false);
        jRefreshButton.setText("Refreshing...");
        jDeviceList.setListData(new String[0]);

        //Create worker thread to refresh devices
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
        public void run() {
            int i,j;
            //Create new discovery client to send out discovery request
            DiscoveryClient dc = new DiscoveryClient();
            RTADevice[] rtadList = null;
            try{
                //Get list of RTADevices
                rtadList = DiscoveryClient.discoverRTADevicesLocalBroadcast();
            }
            catch(Exception e){
                //For debugging purposes, need more error handling
                System.out.println(e);
                jRefreshButton.setEnabled(true);
                jRefreshButton.setText("Refresh Devices");
                return;
            }
            //If no devices are found, do nothing else, but inform the user and enable GUI items again
            if(rtadList.length == 0){
                NoDevicesFoundError();
                return;
            }
            
            //generate string list to put in jDeviceList
            String outputString;
            String[] stringList = null;
            for(i = 0; i < rtadList.length; i++){
                outputString = rtadList[i].toString();
                String[] tempList = new String[i + 1];
                for(j = 0; j < i; j++)tempList[j] = stringList[j];
                tempList[j] = outputString;
                stringList = tempList;
            }
            
            //Check for empty string list
            if(stringList != null) jDeviceList.setListData(stringList);
            else{
                NoDevicesFoundError();
                return;
            }
            
            //Look for last MAC Address and grab its IP
            FindLastMACAddress(stringList);
            
            //Enable GUI items again
            jRefreshButton.setEnabled(true);
            jRefreshButton.setText("Refresh Devices");
            }
        });
    }   
    private void NoDevicesFoundError(){
        String[] errorMessage = new String[1];
        errorMessage[0] = "No Devices Found.";
        jDeviceList.setListData(errorMessage);
        jTextFeedback.append(errorMessage[0] + "\n");
        //Enable GUI items again
        jRefreshButton.setEnabled(true);
        jRefreshButton.setText("Refresh Devices");
    }
    
    private void FindLastMACAddress(String[] stringList){
        ////Look for last MAC Address and grab its IP
        int i;
        if(m_demoOptions.getLastMACAddress() != null){
            String macAddress = null;
            for(i = 0; i < stringList.length; i++){
                macAddress = stringList[i].substring(stringList[i].indexOf("M") + 4,
                        stringList[i].indexOf(" ", stringList[i].indexOf("M")));
                //found the last mac address, get its ip and place it in the ip text field
                if(macAddress.equals(m_demoOptions.getLastMACAddress())){
                    String deviceIP = stringList[i].substring(3, stringList[i].indexOf(" "));
                    jAddressField.setText(deviceIP);
                    jTextFeedback.append("Last connected device found:    MAC = " + m_demoOptions.getLastMACAddress() +
                            "    IP = " + deviceIP + "\n");
                    break;
                }
                else if(i == stringList.length - 1){
                    jTextFeedback.append("Last connected device not found, defaulting to last connected IP Address.\n");
                }
            }
        }
        else{
            jTextFeedback.append("Last connected device not found, please select a device above.\n");
        }
    }
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField jAddressField;
    private javax.swing.JLabel jAddressLabel;
    private javax.swing.JButton jClearMessagesButton;
    private javax.swing.JButton jConnectButton;
    private javax.swing.JList jDeviceList;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton jRefreshButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextArea jTextFeedback;
    // End of variables declaration//GEN-END:variables

}
